package com.ejianc.foundation.share.api;

import com.ejianc.foundation.share.hystrix.ProjectSetHystrix;
import com.ejianc.foundation.share.vo.PunishVO;
import com.ejianc.foundation.share.vo.SubleadersPushVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;


/**
 * 项目立项rpc服务
 */
@FeignClient(name= "ejc-share-web", url="${common.env.feign-client-url}", path="ejc-share-web", fallback = ProjectSetHystrix
		.class)
public interface IProjectSetApi {

	/**
	 * 供应商准入推送，生成企业供应商 适用于供应商本体推送，包括物资设备供应商、劳务分包供应商 分包负责人准入使用本方法下面方法
	 *
	 * @return supplyByte 是SupplierVO的json字符串生成的字节数组
	 */
	@PostMapping(value = "/api/projectPoolSetApi/pushProjectPoolSet")
	public CommonResponse<String> pushProjectPoolSet(@RequestBody  byte[] supplyByte);



}
