package com.ejianc.foundation.share.api;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.share.hystrix.ProjectPoolHystrix;
import com.ejianc.foundation.share.vo.ProjectSurveyVO;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.share.vo.ProjectVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * 项目统计
 */
@FeignClient(name = "ejc-share-web", url = "${common.env.feign-client-url}", path = "ejc-share-web", fallback = ProjectPoolHystrix.class)
public interface IProjectPoolApi {



    @GetMapping(value = "/api/projectPool/queryProjectList")
    CommonResponse<List<ProjectSurveyVO>> queryProjectList(@RequestParam(value = "projectStatus",required = false) String projectStatus, @RequestParam(value = "dateIn",required = false) String dateIn, @RequestParam(value = "orgId",required = false) Long orgId,@RequestParam(value = "currentProvince",required = false) String currentProvince);

    @GetMapping(value = "/api/projectPool/queryProjectPoolList")
    CommonResponse<JSONArray> queryProjectPoolList(@RequestParam(value = "projectStatus",required = false) String projectStatus, @RequestParam(value = "dateIn",required = false) String dateIn, @RequestParam(value = "orgId",required = false) Long orgId);

    @PostMapping(value = "/api/projectPool/getProjectPoolList")
    CommonResponse<JSONArray> getProjectPoolList(@RequestBody QueryParam param);

    @GetMapping(value = "/api/projectPool/queryProjectPoolById")
    CommonResponse<JSONArray> queryProjectPoolById(@RequestParam("id") Long id);


    // 根据项目名称和项目编码和租户id查询项目池中的项目
    @GetMapping(value = "/api/projectPool/queryProjectListByNameAndCodeAndTenantId")
    CommonResponse<List<ProjectPoolSetVO>> queryProjectListByNameAndCodeAndTenantId(@RequestParam("name") String name, @RequestParam("code") String code, @RequestParam("tenantId") Long tenantId);

    // 根据项目项目编码和租户id查询项目池中的项目
    @GetMapping(value = "/api/projectPool/queryProjectListByCodeAndTenantId")
    CommonResponse<List<ProjectPoolSetVO>> queryProjectListByCodeAndTenantId(@RequestParam("code") String code, @RequestParam("tenantId") Long tenantId);

    // 根据项目名称和租户id查询项目池中的项目
    @GetMapping(value = "/api/projectPool/queryProjectListByNameAndTenantId")
    CommonResponse<List<ProjectPoolSetVO>> queryProjectListByNameAndTenantId(@RequestParam("name") String name, @RequestParam("tenantId") Long tenantId);

    // 根据 项目部组织id 查询项目池中的项目
    @GetMapping(value = "/api/projectPool/queryProjectListByProjectDepartmentId")
    CommonResponse<List<ProjectPoolSetVO>> queryProjectListByProjectDepartmentId(@RequestParam("projectDepartmentId") Long projectDepartmentId);

    // 查询项目池中的项目
    @PostMapping("/api/projectPool/queryProjectIPage")
    CommonResponse<Page<ProjectPoolSetVO>> queryProjectIPage(@RequestBody QueryParam param);

    //根据组织id 业务类型 查询在建的的项目列表的ids
    @GetMapping(value = "/api/projectPool/queryProjectIdsByorgId")
    CommonResponse<List<Long>> queryProjectIdsByorgId(@RequestParam("orgId") Long orgId,@RequestParam(value = "projectStatus",required = false) String projectStatus,@RequestParam(value = "dateIn",required = false) String dateIn);

    //根据项目id，查询该项目下所有的子项目(本下)
    @GetMapping(value = "/api/projectPool/queryProjectIdsByParentProjectId")
    CommonResponse<List<Long>> queryProjectIdsByParentProjectId(@RequestParam(value = "parentProjectId",required = false) Long parentProjectId);


    //根据项目Id查询项目信息
    @GetMapping(value = "/api/projectPool/queryDetailById")
    CommonResponse<ProjectVO> queryDetailById(@RequestParam(value = "id") Long id);

    //根据ids查询项目详情
    @GetMapping(value = "/api/projectPool/queryProjectArray")
    CommonResponse<JSONArray> queryProjectArray(@RequestBody List<Long> ids);

    //根据ids查询项目详情
    @GetMapping(value = "/api/projectPool/queryProjectByIds")
    CommonResponse<JSONArray> queryProjectByIds(@RequestBody List<Long> ids);

    //根据项目部id查询项目信息
    @GetMapping(value = "/api/projectPool/queryProjectByProjectDepartmentId")
    CommonResponse<ProjectVO> queryProjectByProjectDepartmentId(@RequestParam(value = "projectDepartmentId") Long projectDepartmentId);

    //查询项目
    @GetMapping(value = "/api/projectPool/queryProjects")
    CommonResponse<List<ProjectVO>> queryProjects(@RequestBody QueryParam param);

    //查询项目
    @PostMapping(value = "/api/projectPool/queryArray")
    CommonResponse<JSONArray> queryArray(@RequestBody QueryParam param);

    //查询当前组织下所有启用且在建的项目
    @GetMapping(value = "/api/projectPool/queryProjectsByOrgId")
    CommonResponse<List<ProjectVO>> queryProjectsByOrgId(@RequestParam("orgId") Long orgId);

    //查询当前组织下所有启用且在建的项目
    @GetMapping("/api/projectPool/queryArrayByOrgId")
    CommonResponse<JSONArray> queryArrayByOrgId(@RequestParam("orgId") Long orgId);


    /**
     * 获取项目年度状态分布情况
     *
     * @return
     */
    @GetMapping(value = "/api/projectPool/getProjectStatusDistributionInYear")
    CommonResponse<List<JSONObject>> getProjectStatusDistributionInYear(@RequestParam(value = "dateIn") String dateIn,
                                                                               @RequestParam(value = "orgId") Long orgId);

}
