package com.ejianc.foundation.share.api;

import com.ejianc.foundation.share.hystrix.BankHystrix;
import com.ejianc.foundation.share.hystrix.CustomerProHystrix;
import com.ejianc.foundation.support.vo.BankAccountVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.netflix.hystrix.Hystrix;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;


/**
 *
 */
@FeignClient(name = "ejc-share-web", url = "${common.env.feign-client-url}", path = "ejc-share-web", fallback = CustomerProHystrix.class)
public interface ICustomerProApi {


    /**
     *获取子项目
     */
    @GetMapping(value = "/customerPro/queryChildrenId")
    CommonResponse<List<Long>> queryChildrenId(@RequestParam(value = "id") Long id);


}
