package com.ejianc.foundation.share.consts;

import java.util.HashMap;
import java.util.Map;

/**
 * 项目业务状态
 * 业务状态：1、未开工 2、在施 3、停工 4、项目中止 5、待竣工 6、竣工 7、复工 12、缺陷责任期 13、缺陷责任期结束
 */
public enum ProjectBusinessStatusEnum {

    未开工("1","未开工"),
    在施("2","在施"),
    停工("3","停工"),
    项目中止("4","项目中止"),
    待竣工("5","待竣工"),
    竣工("6","竣工"),
    复工("7","复工"),
    缺陷责任期("12","缺陷责任期"),
    缺陷责任期结束("13","缺陷责任期结束");


    private static Map<String, String> enumMap;

    static {
        enumMap = new HashMap<>();
        for (ProjectBusinessStatusEnum enumVal : ProjectBusinessStatusEnum.values()) {
            enumMap.put(enumVal.getBusinessStatus(), enumVal.getBusinessStatusName());
        }
    }

    public static String getNameByCode(String code) {
        return enumMap.get(code);
    }


    private String businessStatus;

    private String businessStatusName;

    ProjectBusinessStatusEnum(String businessStatus, String businessStatusName) {
        this.businessStatus = businessStatus;
        this.businessStatusName = businessStatusName;
    }

    public String getBusinessStatus() {
        return businessStatus;
    }

    public void setBusinessStatus(String businessStatus) {
        this.businessStatus = businessStatus;
    }

    public String getBusinessStatusName() {
        return businessStatusName;
    }

    public void setBusinessStatusName(String businessStatusName) {
        this.businessStatusName = businessStatusName;
    }

}
