package com.ejianc.foundation.share.api;

import java.util.List;
import java.util.Map;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import com.ejianc.foundation.share.hystrix.ShareMaterialHystrix;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.core.response.CommonResponse;

/**
 * 物资rpc服务
 *
 * @author cJ
 *
 */
@FeignClient(name= "ejc-share-web", url="${common.env.feign-client-url}", path="ejc-share-web", fallback = ShareMaterialHystrix.class)
public interface IShareMaterialApi {

	/**
	 * 根据物资名称、规格型号、计量单位、物料分类进行唯一性查询
	 *
	 * @param materialVO(name,spac,unitName,categoryId,property)
	 * @return
	 */
	@PostMapping(value = "/api/shareMaterialApi/queryExitFlag")
	public CommonResponse<MaterialVO> queryExitFlag(@RequestBody MaterialVO materialVO);
	/**
	 * 根据物资名称、规格型号、计量单位、物料分类名称进行唯一性查询
	 *
	 * @param materialVO(name,spec,unitName,categoryName,property)
	 * @return
	 */
	@PostMapping(value = "/api/shareMaterialApi/queryExcelFlag")
	public CommonResponse<List<MaterialVO>> queryExcelFlag(@RequestBody MaterialVO materialVO);

	/**
	 * 根据编码查询物料分类详情
	 *
	 * @param code
	 * @return
	 */
	@GetMapping(value = "/api/shareMaterialApi/queryCategoryByCode")
	public CommonResponse<MaterialCategoryVO> queryCategoryByCode(@RequestParam(value = "code") String code);

	/**
	 * 根据父id询全部物料分类
	 *
	 * @param id
	 * @return
	 */
	@GetMapping(value = "/api/shareMaterialApi/queryCategoryListByPid")
	public CommonResponse<List<MaterialCategoryVO>> queryCategoryListByPid(@RequestParam(value = "id") Long id);

	/**
	 * 根据父id询全部物料下级分类
	 * @Author sunyj
	 * @param id
	 * @return
	 */
	@GetMapping(value = "/api/shareMaterialApi/queryCategoryAllListByPid")
	public CommonResponse<List<MaterialCategoryVO>> queryCategoryAllListByPid(@RequestParam(value = "id") Long id);

	/**
	 * 根据ids查询上级全部分类
	 *
	 * @param ids
	 * @return
	 */
	@GetMapping(value = "/api/shareMaterialApi/queryCategoryListByChildren")
	CommonResponse<List<MaterialCategoryVO>> queryCategoryListByChildren(@RequestParam(value = "ids") List<Long> ids);

	/**
	 * @Author mrsir_wxp
	 * @Date 2020/10/19 根据sourceId查询物资
	 * @Description queryMaterialBySourceId
	 * @Param [sourceId]
	 * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.foundation.share.vo.MaterialVO>
	 */
	@GetMapping(value = "/api/shareMaterialApi/queryMaterialBySourceId")
	CommonResponse<MaterialVO> queryMaterialBySourceId(@RequestParam(value = "sourceId") String sourceId);

	/**
	 * @Author liyj
	 * @Date 2020/10/29 根据ids查询物资列表（包括物资来源id，物资分类来源id）
	 * @Param [ids]
	 * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.foundation.share.vo.MaterialVO>
	 */
	@GetMapping(value = "/api/shareMaterialApi/queryMaterialByIds")
	CommonResponse<List<MaterialVO>> queryMaterialByIds(@RequestParam(value = "ids") List<Long> ids);

	/**
	 * @Author xuannl
	 * @Date 2022/04/18 根据id查询物资
	 * @Param [id]
	 * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.foundation.share.vo.MaterialVO>
	 */
	@GetMapping(value = "/api/shareMaterialApi/queryMaterialItemByIds")
	CommonResponse<List<MaterialVO>> queryMaterialItemByIds(@RequestParam(value = "ids") List<Long> ids);
	/**
	 * 根据主键查询物料分类详情
	 * @Author zhangwx
	 * @param id
	 * @return
	 */
	@GetMapping(value = "/api/shareMaterialApi/queryCategoryById")
	CommonResponse<MaterialCategoryVO> queryCategoryById(@RequestParam(value = "id") Long id);

	/**
	 * 根据物资分类主键查询所有物料详情列表
	 * @Author zhangwx
	 * @param ids
	 * @return
	 */
	@PostMapping(value = "/api/shareMaterialApi/queryMaterialByCategoryId")
	CommonResponse<List<MaterialVO>> queryMaterialByCategoryId(@RequestBody List<Long> ids);

	/**
	 * 根据编码查询物料详情
	 * @Author liyongjia
	 * @param code
	 * @return
	 */
	@GetMapping(value = "/api/shareMaterialApi/queryMaterialByCode")
	CommonResponse<MaterialVO> queryMaterialByCode(@RequestParam(value = "code") String code);

	/**
	 * 根据材料主键查对应的所有上级分类
	 *
	 * @param ids
	 * @return
	 */
	@GetMapping(value = "/api/shareMaterialApi/queryCategoryListByMaterialId")
	CommonResponse<Map<Long,List<MaterialCategoryVO>>> queryCategoryListByMaterialId(@RequestParam(value = "ids") List<Long> ids);

	/**
	 * 根据ids查询分类
	 *
	 * @param ids
	 * @return
	 */
	@GetMapping(value = "/api/shareMaterialApi/queryCategoryListByIds")
	CommonResponse<List<MaterialCategoryVO>> queryCategoryListByIds(@RequestParam(value = "ids") List<Long> ids);

	/**
	 * 获取不启用物资分类id
	 *
	 * @param
	 * @return
	 */
	@GetMapping(value = "/api/shareMaterialApi/queryUnenabledCategoryListId")
	CommonResponse<List<Long>> queryUnenabledCategoryListId();

}
