package com.ejianc.foundation.share.consts;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author jiangyikai
 * @version 1.0
 * @description:
 * @date 2022/6/13
 *  1:材料价格库 2:周转材价格库 3:设备采购价格库  4:设备租赁价格库 5: 劳务分包价格库 6:专业分包价格库
 */
public enum PrinceDepotEnum {

    材料价格库(1, "材料价格库"),
    周转材价格库(2, "周转材价格库"),
    设备采购价格库(3, "设备采购价格库"),
    设备租赁价格库(4, "设备租赁价格库"),
    劳务分包价格库(5, "劳务分包价格库"),
    专业分包价格库(6, "专业分包价格库");

    private Integer code;

    private String name;

    private static Map<String, PrinceDepotEnum> enumMap = new HashMap();

    private PrinceDepotEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }



    public static void setEnumMap(Map<String, PrinceDepotEnum> enumMap) {
        PrinceDepotEnum.enumMap = enumMap;
    }

    public static PrinceDepotEnum getByCode(Integer code) {
        return (PrinceDepotEnum)enumMap.get(code);
    }

    static {
        enumMap = (Map) EnumSet.allOf(PrinceDepotEnum.class).stream().collect(Collectors.toMap(PrinceDepotEnum::getCode, Function.identity(), (k1, k2) -> {
            return k2;
        }));
    }
}
