package com.ejianc.foundation.supplier.api;

import com.ejianc.foundation.share.vo.SubleadersVO;
import com.ejianc.foundation.share.vo.dto.SubleadersDTO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.supplier.hystrix.ShareSubleadersHystrix;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;


@FeignClient(name= "ejc-share-web", url="${common.env.feign-client-url}", path="ejc-share-web", fallback = ShareSubleadersHystrix.class)
public interface IShareSubleadersApi {
    /**
     * 供应商 评级更新供应商库
     * @param subleaderId
     * @param gradeId 评定等级id
     * @param gradeName 评定等级名称
     */
    @GetMapping(value = "/api/shareSubleadersApi/upGradeSubleader")
    public CommonResponse<String> upgradeSupplier(@RequestParam("subleaderId") Long subleaderId,
                                                  @RequestParam("gradeId") Long gradeId,
                                                  @RequestParam("gradeName") String gradeName);

    @PostMapping(value = "/api/shareSubleadersApi/getSubleaderList")
    public CommonResponse<List<SubleadersVO>> getSubleaderList(@RequestBody Map<String, List<Long>> idsMap);

    /**
     * 根据修改时间查询分包负责人信息
     *
     * @return
     */
    @GetMapping("/api/shareSubleadersApi/selectByUpDateSubLeaders")
    public CommonResponse<List<SubleadersDTO>> selectByUpDateSubLeaders(@RequestParam(value = "upDate") String upDate);


    /**
     * 根据分包负责人Id查询供应商和分包负责人信息
     *
     * @param id 负责人Id
     * @return
     */
    @GetMapping("/api/shareSubleadersApi/querySupplierByLeaderId")
    CommonResponse<SubleadersVO> querySupplierByLeaderId(@RequestParam(value = "id") Long id);
    /**
     * 根据分包负责人idNum查询供应商和分包负责人信息
     *
     * @param idNum 负责人idNum
     * @return
     */
    @GetMapping("/api/shareSubleadersApi/querySupplierByLeaderNum")
    CommonResponse<List<SubleadersVO>> querySupplierByLeaderNum(@RequestParam(value = "idNum") String idNum);
}
