package com.ejianc.foundation.share.api;

import com.alibaba.fastjson.JSONArray;
import com.ejianc.foundation.share.hystrix.ProjectArchiveHystrix;
import com.ejianc.foundation.share.vo.ProjectArchiveVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;


/**
 * 项目档案rpc服务
 */
@FeignClient(name = "ejc-share-web", url = "${common.env.feign-client-url}", path = "ejc-share-web", fallback = ProjectArchiveHystrix.class)
public interface IProjectArchiveApi {

    /**
     * 推送生成项目档案
     *
     */
    @PostMapping(value = "/api/projectArchiveApi/pushProjectArchive")
    CommonResponse<String> pushProjectArchive(@RequestBody ProjectArchiveVO projectArchiveVO);


    /**
     * 更新项目阶段
     * 更新项目阶段的接口（投标立项、投标文件评审，调用时传引用商机登记的id），只有投标阶段时调用
     * 合同等之后阶段调用时传项目信息id
     */
    @GetMapping(value = "/api/projectArchiveApi/updateProjectStatus")
    CommonResponse<String> updateProjectStatus(@RequestParam("projectStatus") String projectStatus, @RequestParam("sourceId") Long sourceId);

    /**
     * 更新项目阶段
     */
    @GetMapping(value = "/api/projectArchiveApi/updateArchiveProjectStatus")
    CommonResponse<String> updateArchiveProjectStatus(@RequestParam("projectStatus") String projectStatus,
                                                    @RequestParam("sourceId") Long sourceId,
                                                    @RequestParam("billId") Long billId,
                                                    @RequestParam("manyFlag") Boolean manyFlag,
                                                    @RequestParam("updateFlag") Boolean updateFlag);

    /**
     * 更新项目信息
     * 1、合同阶段更新客户信息
     */
    @PostMapping(value = "/api/projectArchiveApi/updateProjectData")
    CommonResponse<String> updateProjectData(@RequestBody ProjectArchiveVO projectArchiveVO);


    /**
     * 根据编码查询匹配项目
     * @param code
     * @return
     */
    @GetMapping(value = "/api/projectArchiveApi/getProjectArchiveByCode")
    CommonResponse<ProjectArchiveVO> getProjectArchiveByCode(@RequestParam String code);

    /**
     * 根据id查询匹配项目
     * @param id
     * @return
     */
    @GetMapping(value = "/api/projectArchiveApi/getProjectArchiveById")
    CommonResponse<ProjectArchiveVO> getProjectArchiveById(@RequestParam Long id);

    /**
     * 根据来源Id查询匹配项目
     * @param sourceId
     * @return
     */
    @GetMapping(value = "/api/projectArchiveApi/getProjectArchiveBySourceId")
    CommonResponse<ProjectArchiveVO> getProjectArchiveBySourceId(@RequestParam Long sourceId);


    /**
     * 根据ids查询项目详情
     * @param ids
     * @return
     */
    @PostMapping(value = "/api/projectArchiveApi/getProjectArchiveByIds")
    CommonResponse<List<ProjectArchiveVO>> getProjectArchiveByIds(@RequestBody List<Long> ids);


    /**
     * 根据查询语句查项目信息
     * @param param
     * @return
     */
    @PostMapping(value = "/api/projectArchiveApi/getProjectArchiveList")
    CommonResponse<List<ProjectArchiveVO>> getProjectArchiveList(@RequestBody QueryParam param);

}
