package com.ejianc.foundation.share.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 项目档案
 * 
 * @author generator
 * 
 */
public class ProjectArchiveVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String code; // 项目编码
    private String name; // 项目名称
    private String shortName; // 项目简称
    private Long orgId; // 所属组织/区域id
    private String orgName; // 所属组织/区域
    private String orgCode; // 所属组织编码/区域
    private Long projectDepartmentId; // 施工项目部
    private String projectDepartmentName; // 施工项目部
    private String projectDepartmentCode; // 施工项目部编码
    private Long projectTypeId; // 项目类型
    private String projectTypeName; // 项目类型名称
    private String productType; // 产品类型
    private String productTypeName; // 产品类型名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date projectDate; // 立项日期
    private String projectStatus; // 项目阶段：1、商机阶段 2、投标阶段 3、未中标 4、已中标 5、合同阶段 6、生产阶段 7、供货阶段 8、结算阶段 9、完工
    private Long customId; // 客户id
    private String customName; // 客户名称
    private String customCode; // 客户编码
    private String businessCustomName; // 客户名称（来自商机登记）
    private String customLinkName; // 客户联系人
    private String customLinkPhone; // 客户联系人电话
    private String designUnit; // 设计单位
    private String constructUnit; // 总包单位
    private Long nationalId; // 国家
    private String nationalName; // 国家
    private String area; // 地区
    private String areaName; // 地区
    private String address; // 详细地址
    private String projectHeight; // 项目高度
    private String projectSpan; // 项目跨度
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date bidOpenDate; // 开标日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date bidDate; // 中标日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planProductDate; // 预计生产日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planDeliverDate; // 预计交货日期（来自商机登记）
    private String productName; // 产品名称
    private String spec; // 规格型号
    private String num; // 数量
    private Long saleLeaderId; // 销售负责人
    private String saleLeaderName; // 销售负责人名称
    private String saleLeaderPhone; // 销售负责人联系电话
    private String projectSituation; // 工程概况
    private String sourceType; // 来源类型（business 商机登记，bid 中标结果登记，）
    private Long sourceBillId; // 来源单据id
    private String sourceBillCode; // 来源单据编号
    private String sourceUpdateId; // 中标结果登记修改时记录的 中标结果登记的单据id


    private String projectStatusName; // 项目阶段：1、商机阶段 2、投标阶段 3、未中标 4、已中标 5、合同阶段 6、生产阶段 7、供货阶段 8、结算阶段 9、完工

    private List<ProjectArchiveRecordVO> recordList = new ArrayList<>(); // 项目档案-状态记录子表

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getShortName() {
        return shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    @ReferDeserialTransfer
    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    public String getProjectDepartmentName() {
        return projectDepartmentName;
    }

    public void setProjectDepartmentName(String projectDepartmentName) {
        this.projectDepartmentName = projectDepartmentName;
    }
    public String getProjectDepartmentCode() {
        return projectDepartmentCode;
    }

    public void setProjectDepartmentCode(String projectDepartmentCode) {
        this.projectDepartmentCode = projectDepartmentCode;
    }
    public Long getProjectTypeId() {
        return projectTypeId;
    }
    @ReferDeserialTransfer
    public void setProjectTypeId(Long projectTypeId) {
        this.projectTypeId = projectTypeId;
    }
    public String getProjectTypeName() {
        return projectTypeName;
    }

    public void setProjectTypeName(String projectTypeName) {
        this.projectTypeName = projectTypeName;
    }
    public String getProductType() {
        return productType;
    }
    public void setProductType(String productType) {
        this.productType = productType;
    }
    public String getProductTypeName() {
        return productTypeName;
    }

    public void setProductTypeName(String productTypeName) {
        this.productTypeName = productTypeName;
    }
    public Date getProjectDate() {
        return projectDate;
    }

    public void setProjectDate(Date projectDate) {
        this.projectDate = projectDate;
    }
    public String getProjectStatus() {
        return projectStatus;
    }

    public void setProjectStatus(String projectStatus) {
        this.projectStatus = projectStatus;
    }
    public Long getCustomId() {
        return customId;
    }

    @ReferDeserialTransfer
    public void setCustomId(Long customId) {
        this.customId = customId;
    }
    public String getCustomName() {
        return customName;
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }
    public String getCustomCode() {
        return customCode;
    }

    public void setCustomCode(String customCode) {
        this.customCode = customCode;
    }
    public String getBusinessCustomName() {
        return businessCustomName;
    }

    public void setBusinessCustomName(String businessCustomName) {
        this.businessCustomName = businessCustomName;
    }
    public String getCustomLinkName() {
        return customLinkName;
    }

    public void setCustomLinkName(String customLinkName) {
        this.customLinkName = customLinkName;
    }
    public String getCustomLinkPhone() {
        return customLinkPhone;
    }

    public void setCustomLinkPhone(String customLinkPhone) {
        this.customLinkPhone = customLinkPhone;
    }
    public String getDesignUnit() {
        return designUnit;
    }

    public void setDesignUnit(String designUnit) {
        this.designUnit = designUnit;
    }
    public String getConstructUnit() {
        return constructUnit;
    }

    public void setConstructUnit(String constructUnit) {
        this.constructUnit = constructUnit;
    }
    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getNationalId() {
        return nationalId;
    }
    @ReferDeserialTransfer
    public void setNationalId(Long nationalId) {
        this.nationalId = nationalId;
    }
    public String getNationalName() {
        return nationalName;
    }

    public void setNationalName(String nationalName) {
        this.nationalName = nationalName;
    }
    public String getArea() {
        return area;
    }

    public void setArea(String area) {
        this.area = area;
    }
    public String getAreaName() {
        return areaName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }
    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }
    public String getProjectHeight() {
        return projectHeight;
    }

    public void setProjectHeight(String projectHeight) {
        this.projectHeight = projectHeight;
    }
    public String getProjectSpan() {
        return projectSpan;
    }

    public void setProjectSpan(String projectSpan) {
        this.projectSpan = projectSpan;
    }
    public Date getBidOpenDate() {
        return bidOpenDate;
    }

    public void setBidOpenDate(Date bidOpenDate) {
        this.bidOpenDate = bidOpenDate;
    }
    public Date getBidDate() {
        return bidDate;
    }

    public void setBidDate(Date bidDate) {
        this.bidDate = bidDate;
    }
    public Date getPlanProductDate() {
        return planProductDate;
    }

    public void setPlanProductDate(Date planProductDate) {
        this.planProductDate = planProductDate;
    }
    public Date getPlanDeliverDate() {
        return planDeliverDate;
    }

    public void setPlanDeliverDate(Date planDeliverDate) {
        this.planDeliverDate = planDeliverDate;
    }
    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }
    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    public String getNum() {
        return num;
    }

    public void setNum(String num) {
        this.num = num;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getSaleLeaderId() {
        return saleLeaderId;
    }
    @ReferDeserialTransfer
    public void setSaleLeaderId(Long saleLeaderId) {
        this.saleLeaderId = saleLeaderId;
    }
    public String getSaleLeaderName() {
        return saleLeaderName;
    }

    public void setSaleLeaderName(String saleLeaderName) {
        this.saleLeaderName = saleLeaderName;
    }
    public String getSaleLeaderPhone() {
        return saleLeaderPhone;
    }

    public void setSaleLeaderPhone(String saleLeaderPhone) {
        this.saleLeaderPhone = saleLeaderPhone;
    }
    public String getProjectSituation() {
        return projectSituation;
    }

    public void setProjectSituation(String projectSituation) {
        this.projectSituation = projectSituation;
    }
    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public String getProjectStatusName() {
        return projectStatusName;
    }

    public void setProjectStatusName(String projectStatusName) {
        this.projectStatusName = projectStatusName;
    }

    public Long getSourceBillId() {
        return sourceBillId;
    }

    public void setSourceBillId(Long sourceBillId) {
        this.sourceBillId = sourceBillId;
    }

    public String getSourceBillCode() {
        return sourceBillCode;
    }

    public void setSourceBillCode(String sourceBillCode) {
        this.sourceBillCode = sourceBillCode;
    }

    public String getSourceUpdateId() {
        return sourceUpdateId;
    }

    public void setSourceUpdateId(String sourceUpdateId) {
        this.sourceUpdateId = sourceUpdateId;
    }

    public List<ProjectArchiveRecordVO> getRecordList() {
        return recordList;
    }

    public void setRecordList(List<ProjectArchiveRecordVO> recordList) {
        this.recordList = recordList;
    }
}
