package com.ejianc.foundation.share.consts;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 项目档案-项目阶段
 * 项目阶段：1、商机阶段 2、投标阶段 3、未中标 4、已中标 5、合同阶段 6、生产阶段 7、供货阶段 8、结算阶段 9、完工
 */
public enum ArchiveProjectStatusEnum {

    商机阶段("1", "商机阶段"),
    投标阶段("2", "投标阶段"),
    未中标("3", "未中标"),
    已中标("4", "已中标"),
    合同阶段("5", "合同阶段"),
    生产阶段("6", "生产阶段"),
    供货阶段("7", "供货阶段"),
    结算阶段("8", "结算阶段"),
    完工("9", "完工");

    private String code;

    private String name;

    private static Map<String, ArchiveProjectStatusEnum> enumMap = new HashMap();

    private ArchiveProjectStatusEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }



    public static void setEnumMap(Map<String, ArchiveProjectStatusEnum> enumMap) {
        ArchiveProjectStatusEnum.enumMap = enumMap;
    }

    public static ArchiveProjectStatusEnum getByCode(String code) {
        return (ArchiveProjectStatusEnum)enumMap.get(code);
    }

    static {
        enumMap = (Map) EnumSet.allOf(ArchiveProjectStatusEnum.class).stream().collect(Collectors.toMap(ArchiveProjectStatusEnum::getCode, Function.identity(), (k1, k2) -> {
            return k2;
        }));
    }
}
