package com.ejianc.foundation.customer.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 客户档案
 *
 * @author generator
 *
 */
public class CustomerVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String billCode; // 客户编码
    private String name; // 客户名称
    private String shortname; // 客户简称
    private String ename; // 客户英文名称
    private Long custClassId; // 客户基本分类id
    private String custClassName; // 客户基本分类名称
    private Long custAreaId; // 地区分类id
    private String custAreaName; // 地区分类名称
    private String taxpayerid; // 统一社会信用代码
    private Long countryzoneId; // 国家地区
    private String countryzoneName; // 国家地区名称
    private Long timezoneId; // 时区id
    private String timezoneName; // 时区名称
    private Long formatdocId; // 数据格式id
    private String formatdocName; // 数据格式名称
    private Date establishDate; // 成立时间
    private String legalPerson; // 法人
    private Long parentId; // 上级客户单位id
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织名称
    private String orgCode; // 所属组织编码
    private Long parentOrgId; // 父级组织id
    private String parentOrgName; // 父级组织名称
    private String parentOrgCode; // 父级组织编码
    private Long currencyTypeId; // 币种id
    private String currencyTypeName; // 币种名称
    private String currencyTypeCode; // 币种编码
    private String changeCode; // 变更单号
    private Integer changeVersion; // 变更版本
    private Long changeId; // 变更主键
    private Integer changeStatus; // 变更状态(1-未变更 2-变更中 3-已变更)
    private Date changeDate; // 变更日期
    private String changeMemo; // 变更原因
    private Long changeEmployeeId; // 变更经办人
    private String changeEmployeeName; // 变更经办人名称
    private Date effectDate; // 生效时间
    private Integer billState; // 单据状态
    private String memo; // 客户描述


    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getShortname() {
        return shortname;
    }

    public void setShortname(String shortname) {
        this.shortname = shortname;
    }

    public String getEname() {
        return ename;
    }

    public void setEname(String ename) {
        this.ename = ename;
    }

    @ReferSerialTransfer(referCode = "cust-class")
    public Long getCustClassId() {
        return custClassId;
    }

    @ReferDeserialTransfer
    public void setCustClassId(Long custClassId) {
        this.custClassId = custClassId;
    }

    public String getCustClassName() {
        return custClassName;
    }

    public void setCustClassName(String custClassName) {
        this.custClassName = custClassName;
    }

    @ReferSerialTransfer(referCode = "area-class")
    public Long getCustAreaId() {
        return custAreaId;
    }

    @ReferDeserialTransfer
    public void setCustAreaId(Long custAreaId) {
        this.custAreaId = custAreaId;
    }

    public String getCustAreaName() {
        return custAreaName;
    }

    public void setCustAreaName(String custAreaName) {
        this.custAreaName = custAreaName;
    }

    public String getTaxpayerid() {
        return taxpayerid;
    }

    public void setTaxpayerid(String taxpayerid) {
        this.taxpayerid = taxpayerid;
    }

    @ReferSerialTransfer(referCode = "country-zone")
    public Long getCountryzoneId() {
        return countryzoneId;
    }

    @ReferDeserialTransfer
    public void setCountryzoneId(Long countryzoneId) {
        this.countryzoneId = countryzoneId;
    }

    public String getCountryzoneName() {
        return countryzoneName;
    }

    public void setCountryzoneName(String countryzoneName) {
        this.countryzoneName = countryzoneName;
    }

    @ReferSerialTransfer(referCode = "time-zone")
    public Long getTimezoneId() {
        return timezoneId;
    }

    @ReferDeserialTransfer
    public void setTimezoneId(Long timezoneId) {
        this.timezoneId = timezoneId;
    }

    public String getTimezoneName() {
        return timezoneName;
    }

    public void setTimezoneName(String timezoneName) {
        this.timezoneName = timezoneName;
    }

    @ReferSerialTransfer(referCode = "format-doc")
    public Long getFormatdocId() {
        return formatdocId;
    }

    @ReferDeserialTransfer
    public void setFormatdocId(Long formatdocId) {
        this.formatdocId = formatdocId;
    }

    public String getFormatdocName() {
        return formatdocName;
    }

    public void setFormatdocName(String formatdocName) {
        this.formatdocName = formatdocName;
    }

    public Date getEstablishDate() {
        return establishDate;
    }

    public void setEstablishDate(Date establishDate) {
        this.establishDate = establishDate;
    }

    public String getLegalPerson() {
        return legalPerson;
    }

    public void setLegalPerson(String legalPerson) {
        this.legalPerson = legalPerson;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }

    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    @ReferSerialTransfer(referCode = "currency-type")
    public Long getCurrencyTypeId() {
        return currencyTypeId;
    }

    @ReferDeserialTransfer
    public void setCurrencyTypeId(Long currencyTypeId) {
        this.currencyTypeId = currencyTypeId;
    }

    public String getCurrencyTypeName() {
        return currencyTypeName;
    }

    public void setCurrencyTypeName(String currencyTypeName) {
        this.currencyTypeName = currencyTypeName;
    }

    public String getCurrencyTypeCode() {
        return currencyTypeCode;
    }

    public void setCurrencyTypeCode(String currencyTypeCode) {
        this.currencyTypeCode = currencyTypeCode;
    }

    public String getChangeCode() {
        return changeCode;
    }

    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }

    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }

    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }

    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }

    public Date getChangeDate() {
        return changeDate;
    }

    public void setChangeDate(Date changeDate) {
        this.changeDate = changeDate;
    }

    public String getChangeMemo() {
        return changeMemo;
    }

    public void setChangeMemo(String changeMemo) {
        this.changeMemo = changeMemo;
    }

    public Long getChangeEmployeeId() {
        return changeEmployeeId;
    }

    public void setChangeEmployeeId(Long changeEmployeeId) {
        this.changeEmployeeId = changeEmployeeId;
    }

    public String getChangeEmployeeName() {
        return changeEmployeeName;
    }

    public void setChangeEmployeeName(String changeEmployeeName) {
        this.changeEmployeeName = changeEmployeeName;
    }

    public Date getEffectDate() {
        return effectDate;
    }

    public void setEffectDate(Date effectDate) {
        this.effectDate = effectDate;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
}
