package com.ejianc.foundation.share.controller.api;

import com.ejianc.foundation.share.bean.MaterialCategoryEntity;
import com.ejianc.foundation.share.bean.MaterialEntity;
import com.ejianc.foundation.share.service.IMaterialCategoryService;
import com.ejianc.foundation.share.service.IMaterialService;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.share.vo.MaterialInsertArchiveVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/api/shareMaterialApi/")
public class MaterialApi {

    @Autowired
    private IMaterialService materialService;
	@Autowired
	private IMaterialCategoryService materialCategoryService;

    @PostMapping("queryExitFlag")
    public CommonResponse<MaterialVO> queryExitFlag(@RequestBody MaterialVO materialVO) {
    	MaterialVO vo = materialService.queryExitFlag(materialVO.getName(), materialVO.getSpec(), materialVO.getUnitName(), materialVO.getCategoryId());
    	return CommonResponse.success("查询成功！", vo);
    }
    @PostMapping("queryExcelFlag")
    public CommonResponse<List<MaterialVO>> queryExcelFlag(@RequestBody MaterialVO materialVO) {
        List<MaterialVO> list = materialService.queryExcelFlag(materialVO.getName(), materialVO.getSpec(), materialVO.getUnitName(), materialVO.getCategoryName());
        return CommonResponse.success("查询成功！", list);
    }

    @GetMapping("queryCategoryByCode")
    public CommonResponse<MaterialCategoryVO> queryCategoryByCode(@RequestParam(value = "code") String code) {
        List<MaterialCategoryEntity> list = materialCategoryService.queryByCode(String.valueOf(code));
        MaterialCategoryVO vo = null;
        if(ListUtil.isNotEmpty(list)){
            vo = BeanMapper.map(list.get(0),MaterialCategoryVO.class);
        }
        if(vo == null){
            return CommonResponse.error("查询失败,没有查询到该编码所属分类！");
        }
    	return CommonResponse.success("查询成功！", vo);
    }

    @GetMapping("queryCategoryListByPid")
    public CommonResponse<List<MaterialCategoryVO>> queryCategoryListByPid(@RequestParam(value = "id") Long id) {
    	List<MaterialCategoryVO> list = materialCategoryService.queryListByPid(id);
    	return CommonResponse.success("查询成功！", list);
    }

    @GetMapping("queryCategoryAllListByPid")
    public CommonResponse<List<MaterialCategoryVO>> queryCategoryAllListByPid(@RequestParam(value = "id") Long id) {
        List<MaterialCategoryVO> list = materialCategoryService.queryListAllByPid(id);
        return CommonResponse.success("查询成功！", list);
    }

    @GetMapping("queryCategoryListByChildren")
    public CommonResponse<List<MaterialCategoryVO>> queryCategoryListByChildren(@RequestParam(value = "ids") List<Long> ids) {
        List<MaterialCategoryVO> list = materialCategoryService.queryCategoryListByChildren(ids);
        return CommonResponse.success("查询成功！", list);
    }

    /**
     * @Author mrsir_wxp
     * @Date 2020/10/19 根据sourceId查询物资
     * @Description queryMaterialBySourceId
     * @Param [sourceId]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.foundation.share.vo.MaterialVO>
     */
    @GetMapping("queryMaterialBySourceId")
    public CommonResponse<MaterialVO> queryMaterialBySourceId(String sourceId) {
        MaterialEntity entity = materialService.queryBySourceId(sourceId);
        if(entity!=null){
            return CommonResponse.success(BeanMapper.map(entity,MaterialVO.class));
        }
        return CommonResponse.error("查询失败,未查到相关物资。");
    }

	/**
	 * @Author liyj
	 * @Date 2020/10/29 根据ids查询物资列表（包括物资来源id，物资分类来源id）
	 * @Param [ids]
	 * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.foundation.share.vo.MaterialVO>
	 */
	@GetMapping(value = "queryMaterialByIds")
	CommonResponse<List<MaterialVO>> queryMaterialByIds(@RequestParam(value = "ids") List<Long> ids){
		List<MaterialEntity> entitys = materialService.queryMaterialByIds(ids);
        if(entitys!=null&&entitys.size()>0){
            return CommonResponse.success(BeanMapper.mapList(entitys,MaterialVO.class));
        }
        return CommonResponse.error("查询失败,未查到相关物资。");
	};

    /**
     * @Author xuannl
     * @Date 2022/04/18 根据id查询物资
     * @Param [id]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.foundation.share.vo.MaterialVO>
     */
    @GetMapping(value = "queryMaterialItemByIds")
    CommonResponse<List<MaterialVO>> queryMaterialItemByIds(@RequestParam(value = "ids") List<Long> ids){
        List<MaterialVO> materialVOS = materialService.queryItem(ids);
        if(null != materialVOS && materialVOS.size() > 0){
            return CommonResponse.success(materialVOS);
        }
        return CommonResponse.error("查询失败,未查到相关数据。");
    };

    /**
     * 根据主键查询物料分类详情
     * @Author zhangwx
     * @param id
     * @return
     */
    @GetMapping("queryCategoryById")
    public CommonResponse<MaterialCategoryVO> queryCategoryById(@RequestParam(value = "id") Long id) {
        return CommonResponse.success("查询成功！", materialCategoryService.queryDetail(id));
    }

    /**
     * 根据物资分类主键查询所有物料详情列表
     * @Author zhangwx
     * @param ids
     * @return
     */
    @PostMapping("queryMaterialByCategoryId")
    public CommonResponse<List<MaterialVO>> queryMaterialByCategoryId(@RequestBody List<Long> ids) {
        List<MaterialVO> res = new ArrayList<>();
        if(ListUtil.isNotEmpty(ids)){
            ids.forEach(id->{
                List<MaterialVO> materialVOS = materialService.queryListByCategoryId(id);
                if(ListUtil.isNotEmpty(materialVOS)){
                    res.addAll(materialVOS);
                }
            });
        }

        return CommonResponse.success("查询成功！", res);
    }

    /**
     * 根据编码查询物料详情
     * @Author liyongjia
     * @param code
     * @return
     */
    @GetMapping("queryMaterialByCode")
    public CommonResponse<MaterialVO> queryMaterialByCode(@RequestParam(value = "code") String code) {
        MaterialVO vo = materialService.queryByCode(String.valueOf(code));
        if(vo == null){
            return CommonResponse.error("查询失败,没有查询到该编码对应的物料！");
        }
    	return CommonResponse.success("查询成功！", vo);
    }

    /**
     * 根据材料主键查对应的所有上级分类
     * @return
     */
    @GetMapping("queryCategoryListByMaterialId")
    public CommonResponse<Map<Long,List<MaterialCategoryVO>>> queryCategoryListByMaterialId(@RequestParam(value = "ids") List<Long> ids) {
        Map<Long,List<MaterialCategoryVO>> map = materialCategoryService.queryCategoryListByMaterialId(ids);
        return CommonResponse.success("查询成功！", map);
    }

    @GetMapping("queryCategoryListByIds")
    public CommonResponse<List<MaterialCategoryVO>> queryCategoryListByIds(@RequestParam(value = "ids", required = false) List<Long> ids) {
        List<MaterialCategoryVO> list = materialCategoryService.queryCategoryListByIds(ids);
        return CommonResponse.success("查询成功！", list);
    }

    /**
     * 根据编码集合查询档案列表
     * @Author zhangwx
     * @param codeList
     * @return
     */
    @GetMapping("queryMaterialListByCodes")
    public CommonResponse<List<MaterialVO>> queryMaterialListByCodes(@RequestParam(value = "codeList") List<String> codeList) {
        List<MaterialVO> list = materialService.queryMaterialListByCodes(codeList);
        if(CollectionUtils.isNotEmpty(list)){
            return CommonResponse.success("查询成功！", list);
        }
        return CommonResponse.error("查询失败,没有查询到该编码对应的物料！");
    }

    @PostMapping(value = "/batchInsertArchiveBySourceBill")
    public CommonResponse<Map<String, MaterialVO>> batchInsertArchiveBySourceBill(@RequestBody MaterialInsertArchiveVO materialInsertArchiveVO) {
        return materialService.batchInsertArchive(materialInsertArchiveVO.getMaterialVOMap(), materialInsertArchiveVO.getSourceBillId(), materialInsertArchiveVO.getSourceBillCode(), materialInsertArchiveVO.getSourceBillType());
    }
}
