package com.ejianc.foundation.share.service.impl;

import com.ejianc.foundation.share.bean.AdministrativeAreaEntity;
import com.ejianc.foundation.share.mapper.AdministrativeAreaMapper;
import com.ejianc.foundation.share.service.IAdministrativeAreaService;
import com.ejianc.foundation.share.vo.AdministrativeAreaVO;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * 行政地区数据服务实现类
 *
 * @author CJ
 * @Description: 行政地区数据服实现务
 * @date 2021/10/12 10:48
 */
@Service(value = "administrativeAreaService")
public class AdministrativeAreaServiceImpl extends BaseServiceImpl<AdministrativeAreaMapper, AdministrativeAreaEntity> implements IAdministrativeAreaService {

    @Autowired
    private AdministrativeAreaMapper administrativeAreaMapper;

    @Override
    public void batchDelByIds(List<Long> ids) {
        if(CollectionUtils.isNotEmpty(ids)) {
            administrativeAreaMapper.batchDelByIds(ids);
        }
    }

    @Override
    public List<Map> queryAll(Long pid) {
        return administrativeAreaMapper.queryAll(pid);
    }

    @Override
    public List<AdministrativeAreaVO> queryList(Long pid, String billCode, String areaName, Integer status) {
        return administrativeAreaMapper.queryList(pid, billCode, areaName, status);
    }

}
