/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.controller.api;

import com.ejianc.foundation.share.bean.MaterialCategoryEntity;
import com.ejianc.foundation.share.bean.MaterialEntity;
import com.ejianc.foundation.share.service.IMaterialCategoryService;
import com.ejianc.foundation.share.service.IMaterialService;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.share.vo.MaterialInsertArchiveVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/shareMaterialApi/"})
public class MaterialApi {
    @Autowired
    private IMaterialService materialService;
    @Autowired
    private IMaterialCategoryService materialCategoryService;

    @PostMapping(value={"queryExitFlag"})
    public CommonResponse<MaterialVO> queryExitFlag(@RequestBody MaterialVO materialVO) {
        MaterialVO vo = this.materialService.queryExitFlag(materialVO.getName(), materialVO.getSpec(), materialVO.getUnitName(), materialVO.getCategoryId());
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)vo);
    }

    @PostMapping(value={"queryExcelFlag"})
    public CommonResponse<List<MaterialVO>> queryExcelFlag(@RequestBody MaterialVO materialVO) {
        List<MaterialVO> list = this.materialService.queryExcelFlag(materialVO.getName(), materialVO.getSpec(), materialVO.getUnitName(), materialVO.getCategoryName());
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", list);
    }

    @GetMapping(value={"queryCategoryByCode"})
    public CommonResponse<MaterialCategoryVO> queryCategoryByCode(@RequestParam(value="code") String code) {
        List<MaterialCategoryEntity> list = this.materialCategoryService.queryByCode(String.valueOf(code));
        MaterialCategoryVO vo = null;
        if (ListUtil.isNotEmpty(list)) {
            vo = (MaterialCategoryVO)BeanMapper.map((Object)list.get(0), MaterialCategoryVO.class);
        }
        if (vo == null) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25,\u6ca1\u6709\u67e5\u8be2\u5230\u8be5\u7f16\u7801\u6240\u5c5e\u5206\u7c7b\uff01");
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", vo);
    }

    @GetMapping(value={"queryCategoryListByPid"})
    public CommonResponse<List<MaterialCategoryVO>> queryCategoryListByPid(@RequestParam(value="id") Long id) {
        List<MaterialCategoryVO> list = this.materialCategoryService.queryListByPid(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", list);
    }

    @GetMapping(value={"queryCategoryAllListByPid"})
    public CommonResponse<List<MaterialCategoryVO>> queryCategoryAllListByPid(@RequestParam(value="id") Long id) {
        List<MaterialCategoryVO> list = this.materialCategoryService.queryListAllByPid(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", list);
    }

    @GetMapping(value={"queryCategoryListByChildren"})
    public CommonResponse<List<MaterialCategoryVO>> queryCategoryListByChildren(@RequestParam(value="ids") List<Long> ids) {
        List<MaterialCategoryVO> list = this.materialCategoryService.queryCategoryListByChildren(ids);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", list);
    }

    @GetMapping(value={"queryMaterialBySourceId"})
    public CommonResponse<MaterialVO> queryMaterialBySourceId(String sourceId) {
        MaterialEntity entity = this.materialService.queryBySourceId(sourceId);
        if (entity != null) {
            return CommonResponse.success((Object)BeanMapper.map((Object)entity, MaterialVO.class));
        }
        return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25,\u672a\u67e5\u5230\u76f8\u5173\u7269\u8d44\u3002");
    }

    @GetMapping(value={"queryMaterialByIds"})
    CommonResponse<List<MaterialVO>> queryMaterialByIds(@RequestParam(value="ids") List<Long> ids) {
        List<MaterialEntity> entitys = this.materialService.queryMaterialByIds(ids);
        if (entitys != null && entitys.size() > 0) {
            return CommonResponse.success((Object)BeanMapper.mapList(entitys, MaterialVO.class));
        }
        return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25,\u672a\u67e5\u5230\u76f8\u5173\u7269\u8d44\u3002");
    }

    @GetMapping(value={"queryMaterialItemByIds"})
    CommonResponse<List<MaterialVO>> queryMaterialItemByIds(@RequestParam(value="ids") List<Long> ids) {
        List<MaterialVO> materialVOS = this.materialService.queryItem(ids);
        if (null != materialVOS && materialVOS.size() > 0) {
            return CommonResponse.success(materialVOS);
        }
        return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25,\u672a\u67e5\u5230\u76f8\u5173\u6570\u636e\u3002");
    }

    @GetMapping(value={"queryCategoryById"})
    public CommonResponse<MaterialCategoryVO> queryCategoryById(@RequestParam(value="id") Long id) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)this.materialCategoryService.queryDetail(id));
    }

    @PostMapping(value={"queryMaterialByCategoryId"})
    public CommonResponse<List<MaterialVO>> queryMaterialByCategoryId(@RequestBody List<Long> ids) {
        ArrayList res = new ArrayList();
        if (ListUtil.isNotEmpty(ids)) {
            ids.forEach(id -> {
                List<MaterialVO> materialVOS = this.materialService.queryListByCategoryId((Long)id);
                if (ListUtil.isNotEmpty(materialVOS)) {
                    res.addAll(materialVOS);
                }
            });
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", res);
    }

    @GetMapping(value={"queryMaterialByCode"})
    public CommonResponse<MaterialVO> queryMaterialByCode(@RequestParam(value="code") String code) {
        MaterialVO vo = this.materialService.queryByCode(String.valueOf(code));
        if (vo == null) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25,\u6ca1\u6709\u67e5\u8be2\u5230\u8be5\u7f16\u7801\u5bf9\u5e94\u7684\u7269\u6599\uff01");
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)vo);
    }

    @GetMapping(value={"queryCategoryListByMaterialId"})
    public CommonResponse<Map<Long, List<MaterialCategoryVO>>> queryCategoryListByMaterialId(@RequestParam(value="ids") List<Long> ids) {
        Map<Long, List<MaterialCategoryVO>> map = this.materialCategoryService.queryCategoryListByMaterialId(ids);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", map);
    }

    @GetMapping(value={"queryCategoryListByIds"})
    public CommonResponse<List<MaterialCategoryVO>> queryCategoryListByIds(@RequestParam(value="ids", required=false) List<Long> ids) {
        List<MaterialCategoryVO> list = this.materialCategoryService.queryCategoryListByIds(ids);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", list);
    }

    @GetMapping(value={"queryMaterialListByCodes"})
    public CommonResponse<List<MaterialVO>> queryMaterialListByCodes(@RequestParam(value="codeList") List<String> codeList) {
        List<MaterialVO> list = this.materialService.queryMaterialListByCodes(codeList);
        if (CollectionUtils.isNotEmpty(list)) {
            return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", list);
        }
        return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25,\u6ca1\u6709\u67e5\u8be2\u5230\u8be5\u7f16\u7801\u5bf9\u5e94\u7684\u7269\u6599\uff01");
    }

    @PostMapping(value={"/batchInsertArchive"})
    public CommonResponse<Map<String, MaterialVO>> batchInsertArchive(@RequestBody Map<String, MaterialVO> materialVOMap) {
        return this.materialService.batchInsertArchive(materialVOMap, null, null, null);
    }

    @PostMapping(value={"/batchInsertArchiveBySourceBill"})
    public CommonResponse<Map<String, MaterialVO>> batchInsertArchiveBySourceBill(@RequestBody MaterialInsertArchiveVO materialInsertArchiveVO) {
        return this.materialService.batchInsertArchive(materialInsertArchiveVO.getMaterialVOMap(), materialInsertArchiveVO.getSourceBillId(), materialInsertArchiveVO.getSourceBillCode(), materialInsertArchiveVO.getSourceBillType());
    }
}

