package com.ejianc.foundation.share.controller.resp;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class YnsbjResponse implements Serializable {

	private static final long serialVersionUID = 1L;

	private String code;

	private String desc;

	private YnsbjDataInfos data;

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getDesc() {
		return desc;
	}

	public void setDesc(String desc) {
		this.desc = desc;
	}

	public YnsbjDataInfos getData() {
		return data;
	}

	public void setData(YnsbjDataInfos data) {
		this.data = data;
	}
	
	public static Map<String, Object> packageResp(YnsbjResponse resp) {
		Map<String, Object> response = new HashMap<>();
		
		Map<String, Object> esbMap = new HashMap<>();
		esbMap.put("CODE", resp.getCode());
		esbMap.put("DESC", resp.getDesc());
		YnsbjDataInfos ynsbjDataInfos = resp.getData();
		if(ynsbjDataInfos != null) {
			Map<String, Object> dataMap = new HashMap<>();
			Map<String, Object> dataInfosMap = new HashMap<>();
			dataInfosMap.put("UUID", ynsbjDataInfos.getUuid());
			List<YnsbjDataInfo> datainfoList = ynsbjDataInfos.getDataInfos();
			if(datainfoList != null && datainfoList.size() > 0) {
				dataInfosMap.put("DATAINFO", datainfoList);
			}
			dataMap.put("DATAINFOS", dataInfosMap);
			
			esbMap.put("DATA", dataMap);
		}
		response.put("ESB", esbMap);
		
		return response;
		
	}

}
