package com.ejianc.foundation.supplierChange.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.bean.SupplierEntity;
import com.ejianc.foundation.share.service.ISupplierService;
import com.ejianc.foundation.share.vo.SupplierExcelVO;
import com.ejianc.foundation.supplierChange.bean.SupplierChangeEntity;
import com.ejianc.foundation.supplierChange.service.ISupplierChangeService;
import com.ejianc.foundation.supplierChange.vo.CertsChangeVO;
import com.ejianc.foundation.supplierChange.vo.SubleadersChangeVO;
import com.ejianc.foundation.supplierChange.vo.SupplierChangeVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.*;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 供应商变更主实体
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("/supplierChange")
public class SupplierChangeController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private ISupplierChangeService service;

    @Autowired
    private ISupplierService supplierService;

    @Autowired
    private IAttachmentApi attachmentApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    public CommonResponse<SupplierChangeVO> saveOrUpdate(@RequestBody SupplierChangeVO saveOrUpdateVO) {
    	SupplierChangeEntity entity = BeanMapper.map(saveOrUpdateVO, SupplierChangeEntity.class);
    	service.saveOrUpdate(entity, false);
    	SupplierChangeVO vo = BeanMapper.map(entity, SupplierChangeVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    public CommonResponse<SupplierChangeVO> queryDetail(Long id) {
    	SupplierChangeEntity entity = service.selectById(id);
    	SupplierChangeVO vo = BeanMapper.map(entity, SupplierChangeVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    public CommonResponse<String> delete(@RequestBody List<SupplierChangeVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (SupplierChangeVO vo : vos) {
            }
        }
        service.removeByIds(vos.stream().map(SupplierChangeVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    public CommonResponse<IPage<SupplierChangeVO>> queryList(@RequestBody QueryParam param) {

        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("code");
        fuzzyFields.add("material_content");
        fuzzyFields.add("equipment_content");
        fuzzyFields.add("equipment_content");
        fuzzyFields.add("major_content");
        fuzzyFields.add("laborContent");
        fuzzyFields.add("subContent");
        fuzzyFields.add("otherContent");
        fuzzyFields.add("revolvMaterialContent");
        fuzzyFields.add("consultContent");
        fuzzyFields.add("apply_org_name");
        fuzzyFields.add("tax_payer_identifier");
        fuzzyFields.add("supplyTypeName");
        fuzzyFields.add("areaName");

        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));

        if(param.getParams().get("insideOrg") != null){
            if("true".equals(param.getParams().get("insideOrg").getValue())){
                param.getParams().put("insideOrg",new Parameter(QueryParam.EQ,true));
            }else {
                param.getParams().put("insideOrg",new Parameter(QueryParam.EQ,false));
            }
        }

        //supplierFlag 客商属性，1、供应商，2、客户，3、客商
        param.getParams().put("supplierFlag", new Parameter(QueryParam.IN, "1,3"));

        if(null != param.getParams().get("supplyType")) {
            String[] supplyTypes = param.getParams().get("supplyType").getValue().toString().split(",");
            ComplexParam c1 = new ComplexParam();
            c1.setLogic(ComplexParam.AND);
            for(String supplyType : supplyTypes) {
                ComplexParam c = new ComplexParam();
                c.setLogic(ComplexParam.OR);
                c.getParams().put("supplyType", new Parameter(QueryParam.LIKE, supplyType));
                c1.getComplexParams().add(c);
            }
            param.getComplexParams().add(c1);
            param.getParams().remove("supplyType");
        }

        IPage<SupplierChangeEntity> page = service.queryPage(param,false);
        IPage<SupplierChangeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SupplierChangeVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 查询企业供应商详情
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryDetails", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SupplierChangeVO> queryDetails(@RequestParam Long id) {
        SupplierChangeEntity supplierChange = service.selectById(id);
        if(supplierChange == null){
            return CommonResponse.error("查询失败");
        }

        SupplierChangeVO resp = BeanMapper.map(supplierChange,SupplierChangeVO.class);
        return CommonResponse.success(resp);
    }

    /**
     * 获取供应商变更数据
     *
     * @param supplierId
     * @return
     */
    @GetMapping(value = "/addSupplierChange")
    public CommonResponse<SupplierChangeVO> addSupplierChange(@RequestParam Long supplierId, @RequestParam(required = false) String saveType) {
        SupplierChangeEntity saveEntity = null;
        QueryWrapper<SupplierChangeEntity> query = new QueryWrapper<>();
        query.eq("source_supplier_id", supplierId);
        query.notIn("bill_state", BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode());
        saveEntity = service.getOne(query);

        if(null != saveEntity) {
            return CommonResponse.error("该供应商已有未生效的变更单！");
        }

        SupplierEntity supplier = supplierService.selectById(supplierId);
        SupplierChangeVO resp = BeanMapper.map(supplier, SupplierChangeVO.class);

        resp.setSourceSupplierId(resp.getId());
        resp.setId(IdWorker.getId());
        resp.setSaveType(saveType);
        //供应商证件
        if(CollectionUtils.isNotEmpty(resp.getCerts())) {
            for(CertsChangeVO cert : resp.getCerts()) {
                cert.setPid(resp.getId());
                cert.setSourceSupplierCertId(cert.getId());
                cert.setId(IdWorker.getId());
                cert.setSourceSupplierId(supplierId);
                cert.setRowState("edit");

                //文件拷贝
                CommonResponse<List<AttachmentVO>> subFileCopyResp = attachmentApi.copyFiles(cert.getSourceSupplierCertId().toString(), null, null, cert.getId().toString(), null, null, false);
                if(!subFileCopyResp.isSuccess()) {
                    throw new BusinessException("加载供应商信息失败，分包负责人附件复制失败！");
                }
            }
        }
        //分包负责人
        if(CollectionUtils.isNotEmpty(resp.getSubLeaders())) {
            for(SubleadersChangeVO subLeader : resp.getSubLeaders()) {
                subLeader.setSourceSupplierId(supplierId);
                subLeader.setSourceSupplierSubLeaderId(subLeader.getId());
                subLeader.setId(IdWorker.getId());
                subLeader.setRowState("edit");

                //文件拷贝
                CommonResponse<List<AttachmentVO>> subFileCopyResp = attachmentApi.copyFiles(subLeader.getSourceSupplierSubLeaderId().toString(), null, null, subLeader.getId().toString(), null, null, false);
                if(!subFileCopyResp.isSuccess()) {
                    throw new BusinessException("加载供应商信息失败，分包负责人附件复制失败！");
                }
            }
        }

        CommonResponse<List<AttachmentVO>> fileCopyResp = attachmentApi.copyFiles(resp.getSourceSupplierId().toString(), null, null, resp.getId().toString(), null, null, false);
        if(!fileCopyResp.isSuccess()) {
            throw new BusinessException("加载供应商信息失败，供应商附件复制失败！");
        }


        resp.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        resp.setCreateTime(null);
        resp.setCreateUserCode(null);
        resp.setUpdateTime(null);
        resp.setUpdateUserCode(null);

        saveEntity = BeanMapper.map(resp, SupplierChangeEntity.class);
        service.saveOrUpdate(saveEntity, false);



        return CommonResponse.success(BeanMapper.map(saveEntity, SupplierChangeVO.class));
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("code");
        fuzzyFields.add("material_content");
        fuzzyFields.add("equipment_content");
        fuzzyFields.add("equipment_content");
        fuzzyFields.add("major_content");
        fuzzyFields.add("laborContent");
        fuzzyFields.add("subContent");
        fuzzyFields.add("otherContent");
        fuzzyFields.add("revolvMaterialContent");
        fuzzyFields.add("consultContent");
        fuzzyFields.add("apply_org_name");
        fuzzyFields.add("tax_payer_identifier");
        fuzzyFields.add("supplyTypeName");
        fuzzyFields.add("areaName");

        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        if(param.getParams().get("insideOrg") != null){
            if("true".equals(param.getParams().get("insideOrg").getValue())){
                param.getParams().put("insideOrg",new Parameter(QueryParam.EQ,true));
            }else {
                param.getParams().put("insideOrg",new Parameter(QueryParam.EQ,false));
            }
        }

        //supplierFlag 客商属性，1、供应商，2、客户，3、客商
        param.getParams().put("supplierFlag", new Parameter(QueryParam.IN, "1,3"));

        if(null != param.getParams().get("supplyType")) {
            String[] supplyTypes = param.getParams().get("supplyType").getValue().toString().split(",");
            ComplexParam c1 = new ComplexParam();
            c1.setLogic(ComplexParam.AND);
            for(String supplyType : supplyTypes) {
                ComplexParam c = new ComplexParam();
                c.setLogic(ComplexParam.OR);
                c.getParams().put("supplyType", new Parameter(QueryParam.LIKE, supplyType));
                c1.getComplexParams().add(c);
            }
            param.getComplexParams().add(c1);
            param.getParams().remove("supplyType");
        }

        List<SupplierChangeEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        List<SupplierExcelVO> suppliers = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(list)) {
            list.forEach(supplierVo -> {
                SupplierExcelVO excelVO = BeanMapper.map(supplierVo,SupplierExcelVO.class);
                excelVO.setPersonal("p".equals(supplierVo.getPersonal())?"个人":"企业");
                excelVO.setGroupInOrOut("in".equals(supplierVo.getGroupInOrOut())?"集团内":"集团外");
                excelVO.setInsideOrg(supplierVo.getInsideOrg() != null && Integer.valueOf("1").equals(supplierVo.getInsideOrg()) ? "内部单位":"外部单位");
                excelVO.setCoordination(supplierVo.getCoordination()!=null&& Integer.valueOf("1").equals(supplierVo.getCoordination())?"已协同":"未协同");
                if(supplierVo.getPunishType()!=null){
                    try {
                        JSONArray array = ReferObjectUtil.getReferEntityValue(supplierVo.getPunishType().toString(),"abnormal_grade");
                        if(array!=null && array.size()>0){
                            excelVO.setPunishType(array.getJSONObject(0).getString("name"));
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                String content="";
                if(StringUtils.isNotEmpty(supplierVo.getMaterialContent())){
                    content+=supplierVo.getMaterialContent();
                }
                if(StringUtils.isNotEmpty(supplierVo.getEquipmentContent())){
                    content+=supplierVo.getEquipmentContent();
                }
                if(StringUtils.isNotEmpty(supplierVo.getLaborContent())){
                    content+=supplierVo.getLaborContent();
                }
                if(StringUtils.isNotEmpty(supplierVo.getMajorContent())){
                    content+=supplierVo.getMajorContent();
                }
                if(StringUtils.isNotEmpty(supplierVo.getConsultContent())){
                    content+=supplierVo.getConsultContent();
                }
                if(StringUtils.isNotEmpty(supplierVo.getRevolvMaterialContent())){
                    content+=supplierVo.getRevolvMaterialContent();
                }
                if(StringUtils.isNotEmpty(supplierVo.getRevolvMaterialContent())){
                    content+=supplierVo.getRevolvMaterialContent();
                }
                if(StringUtils.isNotEmpty(supplierVo.getSubContent())){
                    content+=supplierVo.getSubContent();
                }
                excelVO.setMaterialContent(content);
                excelVO.setBillStateName(BillStateEnum.getEnumByStateCode(supplierVo.getBillState()).getDescription());

                suppliers.add(excelVO);

            });
        }

        beans.put("records", suppliers);
        ExcelExport.getInstance().export("supplier-change-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refSupplierChangeData", method = RequestMethod.GET)
    public CommonResponse<IPage<SupplierChangeVO>> refSupplierChangeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SupplierChangeEntity> page = service.queryPage(param,false);
        IPage<SupplierChangeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SupplierChangeVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
