/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.controller.api;

import com.ejianc.foundation.share.service.IEquipmentCategoryService;
import com.ejianc.foundation.share.service.IEquipmentService;
import com.ejianc.foundation.share.vo.EquipmentCategoryVO;
import com.ejianc.foundation.share.vo.EquipmentVO;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/shareEquipmentApi/"})
public class EquipmentApi {
    @Autowired
    private IEquipmentService equipmentService;
    @Autowired
    private IEquipmentCategoryService equipmentCategoryService;

    @GetMapping(value={"queryEquipmentByCode"})
    public CommonResponse<EquipmentVO> queryMaterialByCode(@RequestParam(value="code") String code) {
        EquipmentVO vo = this.equipmentService.queryByCode(String.valueOf(code));
        if (vo == null) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25,\u6ca1\u6709\u67e5\u8be2\u5230\u8be5\u7f16\u7801\u5bf9\u5e94\u7684\u8bbe\u5907\uff01");
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)vo);
    }

    @GetMapping(value={"queryEquipmentItemByIds"})
    CommonResponse<List<EquipmentVO>> queryEquipmentItemByIds(@RequestParam(value="ids") List<Long> ids) {
        List<EquipmentVO> equipmentVOS = this.equipmentService.queryItem(ids);
        if (null != equipmentVOS && equipmentVOS.size() > 0) {
            return CommonResponse.success(equipmentVOS);
        }
        return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25,\u672a\u67e5\u5230\u76f8\u5173\u6570\u636e\u3002");
    }

    @PostMapping(value={"queryEquipmentItemByIdList"})
    public CommonResponse<List<EquipmentVO>> queryEquipmentItemByIdList(@RequestBody List<Long> idList) {
        List<EquipmentVO> equipmentVOS = this.equipmentService.queryItem(idList);
        if (null != equipmentVOS && equipmentVOS.size() > 0) {
            return CommonResponse.success(equipmentVOS);
        }
        return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25,\u672a\u67e5\u5230\u76f8\u5173\u6570\u636e\u3002");
    }

    @PostMapping(value={"queryCategoryListByIds"})
    public CommonResponse<List<EquipmentCategoryVO>> queryCategoryListByIds(@RequestBody List<Long> ids) {
        List<EquipmentCategoryVO> list = this.equipmentCategoryService.queryCategoryListByIds(ids);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", list);
    }

    @PostMapping(value={"queryEquipmentListByCodes"})
    public CommonResponse<List<EquipmentVO>> queryEquipmentListByCodes(@RequestBody List<String> codeList) {
        List<EquipmentVO> list = this.equipmentService.queryEquipmentListByCodes(codeList);
        if (CollectionUtils.isNotEmpty(list)) {
            return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", list);
        }
        return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25,\u6ca1\u6709\u67e5\u8be2\u5230\u8be5\u7f16\u7801\u5bf9\u5e94\u7684\u6863\u6848\uff01");
    }
}

