package com.ejianc.foundation.share.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.consts.PrinceDepotEnum;
import com.ejianc.foundation.share.utils.ITreeNodeB;
import com.ejianc.foundation.share.utils.TreeNodeBUtil;
import com.ejianc.foundation.share.vo.dto.PriceDepotParamSetDTO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.foundation.share.bean.PriceDepotParamSetEntity;
import com.ejianc.foundation.share.service.IpriceDepotParamSetService;
import com.ejianc.foundation.share.vo.PriceDepotParamSetVO;

/**
 * 价格库参数设置
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("priceDepotParamSet")
public class PriceDepotParamSetController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IpriceDepotParamSetService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PriceDepotParamSetVO> saveOrUpdate(@RequestBody PriceDepotParamSetVO saveOrUpdateVO) {
    	PriceDepotParamSetEntity entity = BeanMapper.map(saveOrUpdateVO, PriceDepotParamSetEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	PriceDepotParamSetVO vo = BeanMapper.map(entity, PriceDepotParamSetVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PriceDepotParamSetVO> queryDetail(Long id) {
    	PriceDepotParamSetEntity entity = service.selectById(id);
    	PriceDepotParamSetVO vo = BeanMapper.map(entity, PriceDepotParamSetVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PriceDepotParamSetVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (PriceDepotParamSetVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(PriceDepotParamSetVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PriceDepotParamSetVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("leafFlag", new Parameter(QueryParam.EQ, 0));
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        IPage<PriceDepotParamSetEntity> page = service.queryPage(param,false);
        IPage<PriceDepotParamSetVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<PriceDepotParamSetEntity> records = page.getRecords();
        List<Long> parentIds = records.stream().map(PriceDepotParamSetEntity::getId).collect(Collectors.toList());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("leafFlag", new Parameter(QueryParam.EQ, 1));
        queryParam.getParams().put("parentId",new Parameter(QueryParam.IN, parentIds));
        List<PriceDepotParamSetEntity> priceDepotParamSetEntities = service.queryList(queryParam);
        records.addAll(priceDepotParamSetEntities);
        List<PriceDepotParamSetVO> priceDepotParamSetVOS = BeanMapper.mapList(records, PriceDepotParamSetVO.class);
        for (PriceDepotParamSetVO record : priceDepotParamSetVOS) {
            record.setTid(record.getId().toString());
            record.setTpid(record.getParentId()!=null && record.getParentId() > 0 ? record.getParentId().toString() : "");
            if (record.getSource()==1){
                record.setSourceName("合同");
            }if (record.getSource()==2){
                record.setSourceName("结算");
            }
            if (record.getSource()==3){
                record.setSourceName("验收");
            }
            if (null == record.getPriorityFlag()){
                record.setPriorityFlagName("");
            }else if(2==record.getPriorityFlag()){
                record.setPriorityFlagName("指导价");
            }else{
                record.setPriorityFlagName("历史价格库");
            }
            //1:材料价格库 2:周转材价格库 3:设备采购价格库  4:设备租赁价格库 5: 劳务分包价格库 6:专业分包价格库
            if (PrinceDepotEnum.getByCode(record.getPriceDepotType())!=null){
                String priceDepotTypeName = PrinceDepotEnum.getByCode(record.getPriceDepotType()).getName();
                record.setPriceDepotTypeName(priceDepotTypeName);
            }
        }
        priceDepotParamSetVOS = TreeNodeBUtil.buildTree(priceDepotParamSetVOS);
        pageData.setRecords(priceDepotParamSetVOS);

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<PriceDepotParamSetEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("priceDepotParamSet-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refpriceDepotParamSetData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PriceDepotParamSetVO>> refpriceDepotParamSetData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                                 String condition,
                                                                                 String searchObject,
                                                                                 String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<PriceDepotParamSetEntity> page = service.queryPage(param,false);
        IPage<PriceDepotParamSetVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PriceDepotParamSetVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
    /**
     * @Description modifyParentContent 修改父级同时更新子级的内容
     */
    @RequestMapping(value = "/modifyParentContent", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PriceDepotParamSetVO> modifyParentContent(@RequestBody PriceDepotParamSetVO priceDepotParamSetVo) {
        LambdaUpdateWrapper<PriceDepotParamSetEntity> updateParentWrapper = new LambdaUpdateWrapper<>();
        updateParentWrapper.set(PriceDepotParamSetEntity::getCycle,priceDepotParamSetVo.getCycle());
        updateParentWrapper.set(PriceDepotParamSetEntity::getSource,priceDepotParamSetVo.getSource());
        updateParentWrapper.set(PriceDepotParamSetEntity::getPriorityFlag,priceDepotParamSetVo.getPriorityFlag());
        updateParentWrapper.eq(PriceDepotParamSetEntity::getId,priceDepotParamSetVo.getId());
        updateParentWrapper.or();
        updateParentWrapper.eq(PriceDepotParamSetEntity::getParentId,priceDepotParamSetVo.getId());
        service.update(updateParentWrapper);
        PriceDepotParamSetEntity entity = BeanMapper.map(priceDepotParamSetVo, PriceDepotParamSetEntity.class);
        PriceDepotParamSetVO vo = BeanMapper.map(entity, PriceDepotParamSetVO.class);
        return CommonResponse.success("修改成功！",vo);
    }

    /**
     * @Description saveOrUpdateChildrenContent
     */
    @RequestMapping(value = "/saveOrUpdateChildrenContent", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PriceDepotParamSetVO> saveOrUpdateChildrenContent(@RequestBody PriceDepotParamSetVO priceDepotParamSetVo) {
        PriceDepotParamSetEntity entity = BeanMapper.map(priceDepotParamSetVo, PriceDepotParamSetEntity.class);
        if (entity.getId()==null){
            service.saveOrUpdate(entity);
        }else {
            LambdaUpdateWrapper<PriceDepotParamSetEntity> updateParentWrapper = new LambdaUpdateWrapper<>();
            updateParentWrapper.eq(PriceDepotParamSetEntity::getId,priceDepotParamSetVo.getId());
            updateParentWrapper.set(PriceDepotParamSetEntity::getSource,priceDepotParamSetVo.getSource());
            updateParentWrapper.set(PriceDepotParamSetEntity::getCategoryId,priceDepotParamSetVo.getCategoryId());
            updateParentWrapper.set(PriceDepotParamSetEntity::getCategoryName,priceDepotParamSetVo.getCategoryName());
            updateParentWrapper.set(PriceDepotParamSetEntity::getPriorityFlag,priceDepotParamSetVo.getPriorityFlag());
            service.update(updateParentWrapper);
        }
        PriceDepotParamSetVO vo = BeanMapper.map(entity, PriceDepotParamSetVO.class);
        return CommonResponse.success("保存修改成功！",vo);
    }

    /**
     * @Description queryPriceDepotParamSetList 查询列表
     * @param priceDepotParamSetVO
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryPriceDepotParamSetList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<PriceDepotParamSetDTO>> queryPriceDepotParamSetList(@RequestBody PriceDepotParamSetVO priceDepotParamSetVO) {
        List<PriceDepotParamSetDTO> priceDepotParamSetList = new ArrayList<>();
        /** 模糊搜索配置字段示例 */
        QueryWrapper<PriceDepotParamSetEntity> queryWrapper = new QueryWrapper<>();
        /** 租户隔离 */
        queryWrapper.eq("tenant_id",InvocationInfoProxy.getTenantid());
        queryWrapper.eq("price_depot_type",priceDepotParamSetVO.getPriceDepotType());
        queryWrapper.eq("leaf_flag", new Parameter(QueryParam.EQ, 0));
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        PriceDepotParamSetEntity priceDepotParamSetEntity = service.getOne(queryWrapper);
        if (priceDepotParamSetEntity!=null && CollectionUtils.isNotEmpty(priceDepotParamSetVO.getMaterialTypeIdList())){
            Long id = priceDepotParamSetEntity.getId();
            QueryWrapper<PriceDepotParamSetEntity> paramSetEntityQueryWrapper = new QueryWrapper<>();
            /** 租户隔离 */
            paramSetEntityQueryWrapper.eq("tenant_id",InvocationInfoProxy.getTenantid());
            paramSetEntityQueryWrapper.eq("price_depot_type",priceDepotParamSetVO.getPriceDepotType());
            paramSetEntityQueryWrapper.eq("parent_id",priceDepotParamSetEntity.getId());
            List<PriceDepotParamSetEntity> list = service.list(paramSetEntityQueryWrapper);
            Map<Long, Integer> sourceMap = new HashMap<>();
            if (CollectionUtils.isNotEmpty(list)){
                for (PriceDepotParamSetEntity depotParamSetEntity : list) {
                    if (StringUtils.isNotBlank(depotParamSetEntity.getCategoryId())){
                        String[] categoryIdArray = depotParamSetEntity.getCategoryId().split(",");
                        for (String categoryId : categoryIdArray) {
                            sourceMap.put(Long.parseLong(categoryId),depotParamSetEntity.getSource());
                        }
                    }
                }
            }
            for (Long materialTypeId : priceDepotParamSetVO.getMaterialTypeIdList()) {
                 if (sourceMap.containsKey(materialTypeId)){
                     PriceDepotParamSetDTO vo = new PriceDepotParamSetDTO();
                     vo.setCategoryId(materialTypeId.toString());
                     vo.setSource(sourceMap.get(materialTypeId));
                     priceDepotParamSetList.add(vo);
                 }else {
                     PriceDepotParamSetDTO vo = new PriceDepotParamSetDTO();
                     vo.setCategoryId(materialTypeId.toString());
                     vo.setSource(priceDepotParamSetEntity.getSource());
                     priceDepotParamSetList.add(vo);
                 }
            }
        }


        return CommonResponse.success("查询列表数据成功！",priceDepotParamSetList);
    }

}
