package com.ejianc.foundation.share.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.bean.ProjectSetExPoolEntity;
import com.ejianc.foundation.share.service.IProjectSetExPoolService;
import com.ejianc.foundation.share.vo.ProjectSetExPoolVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * 仅用于郑州一建项目数据处理
 */
@RestController
@RequestMapping("/api/projectExApi/")
public class ProjectSetExApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IProjectSetExPoolService projectSetExPoolService;
    @Autowired
    private IOrgApi iOrgApi;

    /**
     * 推送生成项目
     *
     * @return
     */
    @PostMapping(value = "pushProject")
    public CommonResponse<String> pushProject(@RequestBody List<ProjectSetExPoolVO> projects) {
        if(ListUtil.isEmpty(projects)){
            return CommonResponse.success("推送数据为空！");
        }
        logger.info("郑州一建项目 pushProject---{}", JSONObject.toJSONString(projects));
        QueryParam param = new QueryParam();
        for (ProjectSetExPoolVO project : projects) {
            if(StringUtils.isNotEmpty(project.getCode())){
                param.getParams().put("code",new Parameter(QueryParam.EQ,project.getCode()));
                List<ProjectSetExPoolEntity> exPoolEntities = projectSetExPoolService.queryList(param);
                if(ListUtil.isNotEmpty(exPoolEntities)){
                    ProjectSetExPoolEntity entity = exPoolEntities.get(0);
                    Long id = entity.getId();
                    Integer version = entity.getVersion();
                    entity = BeanMapper.map(project,ProjectSetExPoolEntity.class);
                    entity.setId(id);
                    entity.setVersion(version);
                    projectSetExPoolService.saveOrUpdateNoES(entity);
                }else {
                    ProjectSetExPoolEntity entity = BeanMapper.map(project,ProjectSetExPoolEntity.class);
                    projectSetExPoolService.saveOrUpdateNoES(entity);
                }
            }
        }

        return CommonResponse.success("保存成功！");
    }



    /**
     * @Description 参照
     *
     * @Return void
     */
    @RequestMapping(value = "/refProjectData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ProjectSetExPoolVO>> refProjectSetData(@RequestParam(defaultValue = "1") int pageNumber,
                                                                     @RequestParam(defaultValue = "10") int pageSize,
                                                                     String condition,
                                                                     String searchObject,
                                                                     String searchText) {
        /** 模糊搜索配置字段示例 */
        QueryParam param = new QueryParam();
        param.setSearchText(searchText);
        param.setPageIndex(pageNumber);
        param.setPageSize(pageSize);
        param.setSearchObject(searchObject);
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("code");
        param.getFuzzyFields().add("buildUnitName");
        param.getFuzzyFields().add("projectDepartmentName");
        param.getOrderMap().put("createTime", "desc");

        Long orgId = InvocationInfoProxy.getOrgId();
        if(StringUtils.isNotBlank(condition)){
            JSONObject _con = JSONObject.parseObject(condition);
            if(StringUtils.isNotBlank(_con.getString("orgId"))){
                orgId = _con.getLong("orgId");
            }
        }
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        List<OrgVO> orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        /** 要求主表有orgId字段，保存单据所属组织 */
        if(commonOrgIds.size() != 0) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }else if(departmentIds.size() != 0){
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }else {
            return CommonResponse.success("查询列表数据成功！",new Page<>(1, param.getPageSize(), 0));
        }

        IPage<ProjectSetExPoolEntity> page = projectSetExPoolService.queryPage(param, false);
        IPage<ProjectSetExPoolVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProjectSetExPoolVO.class));
        return CommonResponse.success("查询参照数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

}
