package com.ejianc.foundation.share.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.share.bean.UnitEntity;
import com.ejianc.foundation.share.service.IUnitService;
import com.ejianc.foundation.share.vo.UnitShareVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

/**
 * @author CJ
 * @Description:
 * @date 2023/11/28 15:45
 */
@RestController
@RequestMapping("/api/unitApi/")
public class UnitApi {
    @Autowired
    private IUnitService unitService;

    @PostMapping(value = "getAllEnabledList")
    public CommonResponse<List<UnitShareVO>> findAllEnabledList(@RequestBody List<String> unitNames) {
        List<UnitShareVO> resp = new ArrayList<>();
        QueryWrapper<UnitEntity> query = new QueryWrapper<>();
        query.eq("enabled", 1);
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        if(CollectionUtils.isNotEmpty(unitNames)) {
            query.and(iq -> {
                iq.in("unit_name", unitNames);
                for(String unitName : unitNames) {
                    iq.or(iiqi -> iiqi.like("alias_name",","+unitName.toLowerCase()+","));
                }
                return iq;
            });
        }
        List<UnitEntity> list = unitService.list(query);

        if(CollectionUtils.isNotEmpty(list)) {
            resp = BeanMapper.mapList(list, UnitShareVO.class);
        }

        return CommonResponse.success(resp);
    }
}
