package com.ejianc.foundation.supplier.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.share.bean.EjcCloudSystemEntity;
import com.ejianc.foundation.share.service.IEjcCloudSystemService;
import com.ejianc.foundation.supplier.bean.ShareSupplierEntity;
import com.ejianc.foundation.supplier.mapper.ShareSupplierMapper;
import com.ejianc.foundation.supplier.service.IShareSupplierService;
import com.ejianc.foundation.tenant.vo.TenantVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 供应商实体
 * 
 * @author generator
 * 
 */
@Service("shareSupplierService")
public class ShareSupplierServiceImpl extends BaseServiceImpl<ShareSupplierMapper, ShareSupplierEntity> implements IShareSupplierService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private final String REQ_URL = "/ejc-oms-web/openapi/enterprise/createOrUpdateTenant";


    @Value("${eachLink.host}")
    private String host;

    @Value("${eachLink.appId}")
    private String appId;

    @Value("${eachLink.secret}")
    private String secret;

    @Autowired
    private ISystemDataPushService systemDataPushService;

    @Autowired
    private IEjcCloudSystemService ejcCloudSystemService;

    @Override
    public TenantVO createSupTenant(ShareSupplierEntity supplier) {
        Map<String, String> reqParam = new HashMap<>();

        //设置单据当前系统信息
        QueryParam param = new QueryParam();
        List<EjcCloudSystemEntity> list = ejcCloudSystemService.queryList(param, false);

        reqParam.put("socialCreditCode", supplier.getSocialCreditCode());
        reqParam.put("supplierType", getSupplierType(supplier));
        reqParam.put("systemId", list.get(0).getCode());
        reqParam.put("supplierName", supplier.getName());
        reqParam.put("supplierId", supplier.getId().toString());

        CommonResponse<String> syncReqResp = systemDataPushService.exchangeDataWithUniversal(REQ_URL,
                RequestMethod.POST,
                JSONObject.toJSONString(reqParam),
                appId, secret, host);
        if(!syncReqResp.isSuccess()) {
            logger.error("供应商id-{}生成协同租户失败，参数：{}, 结果：{}", supplier.getId(), JSONObject.toJSONString(reqParam), JSONObject.toJSONString(syncReqResp));
        }
        CommonResponse<JSONObject> resp = JSONObject.parseObject(syncReqResp.getData(), CommonResponse.class);
        if (!resp.isSuccess()) {
            logger.error("供应商id-{}生成协同租户失败，参数：{}, 结果：{}", supplier.getId(), JSONObject.toJSONString(reqParam), JSONObject.toJSONString(resp));
            throw new BusinessException("生成供方租户信息失败！");
        }
        TenantVO t = JSONObject.parseObject(JSON.toJSONString(resp.getData()), TenantVO.class);
        supplier.setCoordination(1);
        supplier.setTenant(t.getId());
        supplier.setTenantName(t.getName());
        supplier.setSystemId(t.getEnterpriseId().toString());
        super.saveOrUpdate(supplier, false);

        return t;
    }

    private String getSupplierType(ShareSupplierEntity supplier) {
        StringBuilder sp = new StringBuilder();
        if(StringUtils.isNotBlank(supplier.getLaborSourceId())) {
            sp.append("sub,");
        }
        if(StringUtils.isNotBlank(supplier.getMaterialSourceId())) {
            sp.append("material,");
        }

        return sp.substring(0, sp.length()-1);
    }
}
