package com.ejianc.foundation.share.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.share.bean.EjcCloudSystemEntity;
import com.ejianc.foundation.share.bean.ProjectSetPoolEntity;
import com.ejianc.foundation.share.bean.SubleadersEntity;
import com.ejianc.foundation.share.bean.SupplierEntity;
import com.ejianc.foundation.share.service.IEjcCloudSystemService;
import com.ejianc.foundation.share.service.IProjectSetService;
import com.ejianc.foundation.share.service.ISubleadersService;
import com.ejianc.foundation.share.service.ISupplierService;
import com.ejianc.foundation.share.utils.SupplierQueryType;
import com.ejianc.foundation.share.vo.*;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

/**
 * @author CJ
 * @Description:
 * @date 2020/6/30 15:03
 */
@RestController
@RequestMapping("/api/projectPoolSetApi/")
public class ProjectSetApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IProjectSetService projectSetService;
    @Autowired
    private IEjcCloudSystemService ejcCloudSystemService;
    @Autowired
    private ISubleadersService subleadersService;


    /**
     * 推送，生成项目池
     *
     * @return
     */
    @PostMapping(value = "pushProjectPoolSet")
    public CommonResponse<String> pushSupplierToShare(@RequestBody byte[] supplyByte){
        String supplyStr = new String(supplyByte, StandardCharsets.UTF_8);
        logger.info("推送，生成项目池pushProjectPoolSet---{}", supplyStr);
        ProjectPoolSetVO projectPoolSetVO = JSONObject.parseObject(supplyStr, ProjectPoolSetVO.class);
//        QueryParam param = new QueryParam();
//        SupplierEntity se = BeanMapper.map(supplierVO,SupplierEntity.class);
//        Boolean coordination = se.getCoordination();
//        if(coordination == null){
//            se.setCoordination(false);
//        }
//        supplierService.saveOrUpdate(se,false);
//        se = supplierService.generateSupplierTenant(se);
//        supplierService.saveOrUpdate(se,false);
//        if(SupplierQueryType.laborSub.equals(se.getSupplyQueryType())){
//            //分包供应商 分包负责人
//            if(ListUtil.isNotEmpty(se.getSubLeaders()) ){
//                for (SubleadersEntity subLeader : se.getSubLeaders()) {
//                    supplierService.generateSubSupplierTenant(subLeader,se);
//                    subleadersService.saveOrUpdate(subLeader);
//                }
//            }
//        }
        ProjectSetPoolEntity entity = BeanMapper.map(projectPoolSetVO, ProjectSetPoolEntity.class);
        projectSetService.saveOrUpdate(entity, false);
        return CommonResponse.success("保存成功！");
    }

}
