package com.ejianc.foundation.share.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.share.bean.CooperateEntity;
import com.ejianc.foundation.share.bean.MaterialCategoryEntity;
import com.ejianc.foundation.share.bean.MaterialEntity;
import com.ejianc.foundation.share.mapper.CooperateMapper;
import com.ejianc.foundation.share.service.ICooperateService;
import com.ejianc.foundation.share.service.IMaterialCategoryService;
import com.ejianc.foundation.share.service.IMaterialService;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/api/shareCooperateApi/")
public class CooperateApi {

    @Autowired
    private ICooperateService service;
    @Autowired
    private CooperateMapper cooperateMapper;




    /**
     * 根据模块id 查询 协同设置列表
     *
     * @param moduleId
     * @return List<CooperateVO>
     */
    @GetMapping("queryCooperateListByModuleId")
    public CommonResponse<List<CooperateVO>> queryCooperateListByModuleId(@RequestParam(value = "moduleId") Long moduleId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("moduleId",new Parameter(QueryParam.EQ, moduleId));
        List<CooperateEntity> cooperateEntities = service.queryList(queryParam);
        List<CooperateVO> cooperateVos = BeanMapper.mapList(cooperateEntities, CooperateVO.class);
        return CommonResponse.success("查询成功！", cooperateVos);
    }
    /**
     * 根据模块单据编号 查询 协同设置
     *
     * @param billTypeCode
     * @return CooperateVO
     */

    @GetMapping("queryCooperateBybillTypeCode")
    public CommonResponse<CooperateVO> queryCooperateBybillTypeCode(@RequestParam(value = "billTypeCode") String billTypeCode){
        QueryWrapper<CooperateEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("bill_type_code",billTypeCode);
        CooperateEntity cooperateEntity = cooperateMapper.selectOne(queryWrapper);
        CooperateVO vo = new CooperateVO();
        if (cooperateEntity!=null){
            vo = BeanMapper.map(cooperateEntity, CooperateVO.class);
        }
        return CommonResponse.success("查询成功！", vo);
    }
}
