/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.bean.LabsubCategoryEntity;
import com.ejianc.foundation.share.bean.LabsubItemEntity;
import com.ejianc.foundation.share.mapper.LabsubItemMapper;
import com.ejianc.foundation.share.service.ILabsubCategoryService;
import com.ejianc.foundation.share.service.ILabsubItemService;
import com.ejianc.foundation.share.vo.LabsubItemImportVO;
import com.ejianc.foundation.share.vo.LabsubItemVO;
import com.ejianc.foundation.share.vo.ProsubItemVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="labsubItemService")
public class LabsubItemServiceImpl
extends BaseServiceImpl<LabsubItemMapper, LabsubItemEntity>
implements ILabsubItemService {
    @Autowired
    private ILabsubItemService service;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private LabsubItemMapper labsubItemMapper;
    private static final String BILL_CODE = "LSI_CODE";
    @Autowired
    private ILabsubCategoryService labsubCategoryService;

    @Override
    public CommonResponse<JSONObject> excelProsubImport(HttpServletRequest request) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        ArrayList<LabsubItemImportVO> successList = new ArrayList<LabsubItemImportVO>();
        ArrayList<LabsubItemImportVO> errorList = new ArrayList<LabsubItemImportVO>();
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            if (result.size() > 10000) {
                return CommonResponse.error((String)"\u52b3\u52a1\u5206\u5305\u6863\u6848\u8d85\u8fc710000\u6761\uff0c\u8bf7\u5206\u6279\u4e0a\u4f20\uff01");
            }
            HashMap caListMap = new HashMap();
            HashMap materialMap = new HashMap();
            HashMap<String, ProsubItemVO> materialBeanMap = new HashMap<String, ProsubItemVO>();
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                LabsubItemImportVO prosubItemImport = new LabsubItemImportVO();
                prosubItemImport.setId(IdWorker.getId());
                prosubItemImport.setCategoryCode((String)datas.get(0));
                prosubItemImport.setTrawlingCode((String)datas.get(1));
                prosubItemImport.setTrawlingName((String)datas.get(2));
                prosubItemImport.setPriceType((String)datas.get(3));
                prosubItemImport.setUnitName((String)datas.get(4));
                prosubItemImport.setJobContent((String)datas.get(5));
                prosubItemImport.setRemarks((String)datas.get(6));
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(0)))) {
                    prosubItemImport.setRemarks("\u6863\u6848\u7f16\u7801\u4e3a\u7a7a\uff01");
                    errorList.add(prosubItemImport);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(1)))) {
                    prosubItemImport.setRemarks("\u6863\u6848\u540d\u79f0\u4e3a\u7a7a\uff01");
                    errorList.add(prosubItemImport);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(2)))) {
                    prosubItemImport.setRemarks("\u4ef7\u683c\u7c7b\u578b\u4e3a\u7a7a\uff01");
                    errorList.add(prosubItemImport);
                    continue;
                }
                List materialCategoryVo = (List)caListMap.get(datas.get(0));
                if (ListUtil.isEmpty((List)materialCategoryVo)) {
                    QueryParam queryParam = new QueryParam();
                    queryParam.getParams().put("categoryCode", new Parameter("eq", (Object)String.valueOf(datas.get(0))));
                    materialCategoryVo = this.labsubCategoryService.queryList(queryParam, false);
                    if (ListUtil.isNotEmpty((List)materialCategoryVo)) {
                        caListMap.put(datas.get(0), materialCategoryVo);
                    }
                }
                if (ListUtil.isNotEmpty((List)materialCategoryVo)) {
                    LabsubItemEntity one;
                    QueryWrapper queryWrapper;
                    prosubItemImport.setCategoryId(((LabsubCategoryEntity)((Object)materialCategoryVo.get(0))).getId());
                    if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(1)))) {
                        CommonResponse codeBatchByRuleCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, tenantId);
                        if (codeBatchByRuleCode.isSuccess()) {
                            prosubItemImport.setTrawlingCode((String)codeBatchByRuleCode.getData());
                        } else {
                            prosubItemImport.setTrawlingCode(System.currentTimeMillis() + "");
                        }
                    } else {
                        ProsubItemVO vo = (ProsubItemVO)materialMap.get(datas.get(1));
                        if (vo == null) {
                            queryWrapper = new QueryWrapper();
                            queryWrapper.eq((Object)"trawling_code", (Object)String.valueOf(datas.get(1)));
                            one = (LabsubItemEntity)((Object)this.service.getOne((Wrapper)queryWrapper));
                            if (one != null) {
                                vo = (ProsubItemVO)BeanMapper.map((Object)((Object)one), ProsubItemVO.class);
                            }
                            if (vo != null) {
                                materialMap.put(datas.get(1), vo);
                            }
                        }
                        if (vo != null) {
                            prosubItemImport.setRemarks("\u6863\u6848\u7f16\u53f7\u91cd\u590d\uff01");
                            errorList.add(prosubItemImport);
                            continue;
                        }
                    }
                    ProsubItemVO materialBean = (ProsubItemVO)materialBeanMap.get(prosubItemImport.getTrawlingName() + prosubItemImport.getPriceType() + prosubItemImport.getUnitName() + ((LabsubCategoryEntity)((Object)materialCategoryVo.get(0))).getId());
                    if (materialBean == null) {
                        queryWrapper = new QueryWrapper();
                        queryWrapper.eq((Object)"trawling_name", (Object)prosubItemImport.getTrawlingName());
                        queryWrapper.eq((Object)"price_type", (Object)prosubItemImport.getPriceType());
                        queryWrapper.eq((Object)"unit_name", (Object)prosubItemImport.getUnitName());
                        queryWrapper.eq((Object)"category_id", (Object)((LabsubCategoryEntity)((Object)materialCategoryVo.get(0))).getId());
                        one = (LabsubItemEntity)((Object)this.service.getOne((Wrapper)queryWrapper));
                        if (one != null) {
                            materialBean = (ProsubItemVO)BeanMapper.map((Object)((Object)one), ProsubItemVO.class);
                            materialBeanMap.put(prosubItemImport.getTrawlingName() + prosubItemImport.getPriceType() + prosubItemImport.getUnitName() + ((LabsubCategoryEntity)((Object)materialCategoryVo.get(0))).getId(), materialBean);
                        }
                    }
                    if (materialBean != null) {
                        prosubItemImport.setRemarks("\u91cd\u590d\u6863\u6848\uff01");
                        errorList.add(prosubItemImport);
                        continue;
                    }
                    prosubItemImport.setCreateUserCode(InvocationInfoProxy.getUsercode());
                    prosubItemImport.setCreateTime(new Date());
                    prosubItemImport.setTenantId(InvocationInfoProxy.getTenantid());
                    prosubItemImport.setEnabled(1);
                    successList.add(prosubItemImport);
                    continue;
                }
                prosubItemImport.setRemarks("\u6863\u6848\u5206\u7c7b\u7f16\u53f7\u4e0d\u5b58\u5728\uff01");
                errorList.add(prosubItemImport);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }

    @Override
    public CommonResponse<LabsubItemVO> saveOrUpdateLabsubItem(LabsubItemVO saveorUpdateVO) {
        LabsubItemEntity entity = (LabsubItemEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, LabsubItemEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setTrawlingCode((String)billCode.getData());
                entity.setEnabled(0);
                entity.setOrgId(this.sessionManager.getUserContext().getOrgId());
                entity.setOrgName(this.sessionManager.getUserContext().getOrgName());
            }
        } else {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)saveorUpdateVO.getId());
            updateWrapper.set(LabsubItemEntity::getTrawlingName, (Object)saveorUpdateVO.getTrawlingName());
            updateWrapper.set(LabsubItemEntity::getPriceType, (Object)saveorUpdateVO.getPriceType());
            updateWrapper.set(LabsubItemEntity::getUnitName, (Object)saveorUpdateVO.getUnitName());
            updateWrapper.set(LabsubItemEntity::getJobContent, (Object)saveorUpdateVO.getJobContent());
            updateWrapper.set(LabsubItemEntity::getOrgId, (Object)this.sessionManager.getUserContext().getOrgId());
            updateWrapper.set(LabsubItemEntity::getOrgName, (Object)this.sessionManager.getUserContext().getOrgName());
            updateWrapper.set(LabsubItemEntity::getRemarks, (Object)saveorUpdateVO.getRemarks());
            this.service.update((Wrapper)updateWrapper);
            return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01");
        }
        this.service.saveOrUpdate((Object)entity, false);
        LabsubItemVO vo = (LabsubItemVO)BeanMapper.map((Object)((Object)entity), LabsubItemVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @Override
    public List<LabsubItemVO> queryLabsubItemList(Page<LabsubItemVO> page, QueryWrapper wrapper) {
        return ((LabsubItemMapper)this.baseMapper).queryProsubItemList(page, wrapper);
    }

    @Override
    public void updateSubject(Long subjectId, String subjectName, List<Long> ids) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, ids);
        updateWrapper.set(LabsubItemEntity::getSubjectId, (Object)subjectId);
        updateWrapper.set(LabsubItemEntity::getSubjectName, (Object)subjectName);
        this.service.update((Wrapper)updateWrapper);
    }
}

