package com.ejianc.foundation.share.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.bean.*;
import com.ejianc.foundation.share.mapper.SupplierCategoryMapper;
import com.ejianc.foundation.share.mapper.SupplierMapper;
import com.ejianc.foundation.share.service.*;
import com.ejianc.foundation.share.utils.SupplierQueryType;
import com.ejianc.foundation.share.vo.*;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.foundation.tenant.api.IEnterpriseApi;
import com.ejianc.foundation.tenant.vo.EnterpriseVO;
import com.ejianc.foundation.tenant.vo.TenantVO;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.conn.ConnectTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;

import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Service
@Transactional
public class SupplierServiceImpl extends BaseServiceImpl<SupplierMapper, SupplierEntity> implements ISupplierService {

	private static final String SUPPLIER_BILL_CODE = "SUPPORT_SUPPLIER";

    private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private SupplierMapper supplierMapper;
	@Autowired
	private SupplierCategoryMapper supplierCategoryMapper;
	@Autowired
	private ISupplierLinkerService supplierLinkerService;
	@Autowired
	private IDefdocApi defdocApi;
	@Autowired
	private IBillCodeApi billCodeApi;
	@Autowired
	private ISupplierCategoryService categoryService;
	@Autowired
	private IEnterpriseApi enterpriseApi;
	@Autowired
	private IOrgApi orgApi;

    @Value("${sendMessageTemplateCode}")
    private String sendMessageTemplateCode;

    @Value("${common.env.base-host}")
    private String baseHost;

    @Value("${insideSupplierCategoryCode:SPC-inside}")
    private String insideSupplierCategoryCode;//内部供应商分类编码

    @Value("${insideCustomerCategoryCode:CC-inside}")
    private String insideCustomerCategoryCode;//内部客户分类编码

	@Value("${eachLink.host}")
	private String eachLinkHost;

	@Value("${eachLink.appId}")
	private String appId;

	@Value("${eachLink.secret}")
	private String secret;

	@Autowired
	private ICustomerCategoryService customerCategoryService;
	@Autowired
	private ICustomerService customerService;
	@Autowired
	private SessionManager sessionManager;
	@Autowired
	private ISupplierCategoryService supplierCategoryService;
	@Autowired
	private ISystemDataPushService systemDataPushService;
	@Autowired
	private IEjcCloudSystemService ejcCloudSystemService;
	@Autowired
	private ISubleadersService subleadersService;
	@Autowired
	private IOrgApi iOrgApi;

	@Override
	public List<SupplierVO> queryListByCategoryId(Long categoryId) {
		QueryWrapper<SupplierEntity> wrapper = new QueryWrapper<>();
		wrapper.eq("category_id", categoryId);
		//获取组织，若是集团，则查询本下级，若是分子公司，则向上查询一直到根节点下的分子公司为止
//		List<Long> orgIds = this.getOrgIds();
//		wrapper.in("org_id", orgIds);
		List<SupplierEntity> entities = supplierMapper.selectList(wrapper);
		if(entities != null) {
			return BeanMapper.mapList(entities, SupplierVO.class);
		}
		return null;
	}


	//获取组织，若是集团，则查询本下级，若是分子公司，则向上查询一直到根节点下的分子公司为止
	private List<Long> getOrgIds() {
		List<Long> orgIds = new ArrayList<>();
		CommonResponse<OrgVO> nowOrg = orgApi.getOneById(InvocationInfoProxy.getOrgId());
		if(nowOrg.isSuccess()&&nowOrg.getData()!=null){
			if(nowOrg.getData().getOrgType()==1){
				//为集团，查询本下级
				CommonResponse<List<OrgVO>> list = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
				if(list.isSuccess()&&list.getData()!=null&&list.getData().size()>0){
					for(OrgVO vo : list.getData()){
						orgIds.add(vo.getId());
					}
					return orgIds;
				}
			}else{
				//是分子公司，则向上查询一直到根节点下的分子公司为止
				CommonResponse<List<OrgVO>> parentlist = orgApi.findParentsByOrgId(InvocationInfoProxy.getOrgId());
				if(parentlist.isSuccess()&&parentlist.getData()!=null&&parentlist.getData().size()>0){
					Long parentId = InvocationInfoProxy.getOrgId();
					for(int i = parentlist.getData().size()-1; i>=0 ; i--){
						OrgVO vo = parentlist.getData().get(i);
						if(vo.getOrgType()==2){
							parentId = vo.getId();
							break;
						}
					}
					//查询本下数据
					CommonResponse<List<OrgVO>> list = orgApi.findChildrenByParentId(parentId);
					if(list.isSuccess()&&list.getData()!=null&&list.getData().size()>0){
						for(OrgVO vo : list.getData()){
							orgIds.add(vo.getId());
						}
						return orgIds;
					}
				}
			}
		}
		return null;
	}

	@Override
	public CommonResponse<SupplierVO> saveOrUpdate(SupplierVO supplierVo) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		SupplierEntity entity = null;
		String operateType = null;
		//根据统一信用代码验重
		this.check(supplierVo);
		if(supplierVo.getId() != null && supplierVo.getId() > 0) { //修改
			entity = supplierMapper.selectById(supplierVo.getId());
			entity.setCode(supplierVo.getCode());
			entity.setName(supplierVo.getName());
			entity.setCategoryId(supplierVo.getCategoryId());
			entity.setCategoryName(supplierVo.getCategoryName());
			entity.setSocialCreditCode(supplierVo.getSocialCreditCode());
			entity.setLegal(supplierVo.getLegal());
			entity.setTaxPayerType(supplierVo.getTaxPayerType());
			entity.setBusinessScope(supplierVo.getBusinessScope());
			entity.setArea(supplierVo.getArea());
			entity.setAddress(supplierVo.getAddress());
			entity.setTelephone(supplierVo.getTelephone());
			entity.setBankName(supplierVo.getBankName());
			entity.setBankAccount(supplierVo.getBankAccount());
			entity.setBankCode(supplierVo.getBankCode());
			entity.setDescription(supplierVo.getDescription());
			entity.setEnabled(supplierVo.getEnabled());
			entity.setEnterpriseNature(supplierVo.getEnterpriseNature());
			entity.setEnterpriseNatureName(supplierVo.getEnterpriseNatureName());
			
			operateType = "edit";
		}else{ //新增
			CommonResponse<String> codeBatchByRuleCode = billCodeApi.getCodeBatchByRuleCode(SUPPLIER_BILL_CODE, tenantId);
			if(codeBatchByRuleCode.isSuccess()){
				supplierVo.setCode(codeBatchByRuleCode.getData());
			}

			entity = BeanMapper.map(supplierVo, SupplierEntity.class);
			entity.setOrgId(InvocationInfoProxy.getOrgId());
			entity.setOrgName(sessionManager.getUserContext().getOrgName());
			operateType = "add";
		}

		//处理项目地区，转为省市区
		if(StringUtils.isNotBlank(entity.getArea())){
			String regex = "((?<provinceAndCity>[^市]+市|.*?自治州|.*?区|.*县)(?<town>[^区]+区|.*?市|.*?县|.*?路|.*?街|.*?道|.*?镇|.*?旗)(?<detailAddress>.*))";
			Matcher matcher = Pattern.compile(regex).matcher(entity.getArea());
			while(matcher.find()){
				try {
					entity.setRegion(matcher.group("town"));
				}catch (IllegalArgumentException e){
				}
				String regex2 = "((?<province>[^省]+省|.+自治区|上海市|北京市|天津市|重庆市|上海|北京|天津|重庆|香港特别行政区|澳门特别行政区)(?<city>.*))";
				String provinceAndCity = "";
				try {
					provinceAndCity = matcher.group("provinceAndCity");
				}catch (IllegalArgumentException e){
				}
				Matcher matcher2 = Pattern.compile(regex2).matcher(provinceAndCity);
				while (matcher2.find()){
					try {
						entity.setProvince(matcher.group("province"));
					}catch (IllegalArgumentException e){
					}
					try {
						String city = matcher2.group("city");
						if(StringUtils.isBlank(city)){
							entity.setCity(entity.getProvince());
						}else{
							entity.setCity(matcher.group("city"));
						}
					}catch (IllegalArgumentException e){
					}

				}
			}
		}

		super.saveOrUpdate(entity);

		//子表
		List<SupplierLinkerVO> supplierLinkerVos = supplierVo.getGridheaders();
		List<SupplierLinkerEntity> saveOrUpldates = new ArrayList<>();
		List<Long> deleteIds = new ArrayList<>();
		for(SupplierLinkerVO supplierLinkerVo:supplierLinkerVos) {
			if("add".equals(supplierLinkerVo.getRowState())) {
				SupplierLinkerEntity supplierLinkerEntity = BeanMapper.map(supplierLinkerVo, SupplierLinkerEntity.class);
				supplierLinkerEntity.setSupplierId(entity.getId());
				saveOrUpldates.add(supplierLinkerEntity);
			}else if("edit".equals(supplierLinkerVo.getRowState())) {
				SupplierLinkerEntity supplierLinkerEntity = BeanMapper.map(supplierLinkerVo, SupplierLinkerEntity.class);
				saveOrUpldates.add(supplierLinkerEntity);
			} else if("del".equals(supplierLinkerVo.getRowState())) {
				deleteIds.add(supplierLinkerVo.getId());
			}
		}
		if(saveOrUpldates.size() > 0) {
			supplierLinkerService.saveOrUpdateBatch(saveOrUpldates, saveOrUpldates.size(), false);
		}
		if(deleteIds.size() > 0) {
			supplierLinkerService.removeByIds(deleteIds, false);
		}

//		if("add".equals(operateType)) {
//			return CommonResponse.success("保存成功");
//		}else{
//			return CommonResponse.success("修改成功");
//		}
		SupplierVO vo = this.queryDetail(entity.getId());
		JSONObject parent = new JSONObject();
		SupplierCategoryEntity e = supplierCategoryService.selectById(vo.getCategoryId());
		parent.put("id",e.getId());
		parent.put("code",e.getCode());
		parent.put("name",e.getName());
		vo.setParent(parent);
		return CommonResponse.success("保存成功",vo);
	}

	private void check(SupplierVO supplierVo) {
		QueryWrapper<SupplierEntity> queryWrapper = new QueryWrapper<>();
		if(supplierVo.getId()!=null){
			queryWrapper.ne("id", supplierVo.getId());
		}
		queryWrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
		queryWrapper.eq("dr", 0);
		queryWrapper.eq("social_credit_code", supplierVo.getSocialCreditCode());
		List<SupplierEntity> list = this.list(queryWrapper );
		if(list!=null&&list.size()>0){
			throw new BusinessException("统一社会信用代码已存在！！！");
		}
	}


	@Override
	public SupplierVO queryDetail(Long id) {
		SupplierEntity entity = supplierMapper.selectById(id);
		if(entity != null) {
			SupplierVO supplierVo = BeanMapper.map(entity, SupplierVO.class);

			QueryParam queryParam = new QueryParam();
			queryParam.getParams().put("supplierId", new Parameter(QueryParam.EQ, supplierVo.getId()));
			queryParam.getOrderMap().put("createTime", "desc");
			List<SupplierLinkerEntity> supplierLinkers = supplierLinkerService.queryList(queryParam, false);
			if(supplierLinkers != null && supplierLinkers.size() > 0) {
				List<SupplierLinkerVO> supplierLinkerVos = BeanMapper.mapList(supplierLinkers, SupplierLinkerVO.class);
				supplierVo.setGridheaders(supplierLinkerVos);
			}
			return supplierVo;
		}
		return null;
	}

	@Override
	public void deleteSupplier(List<Long> ids) {
		for(Long id:ids) {
			//先删除供方联系人
			supplierLinkerService.deleteBySupplierId(id);
			supplierMapper.deleteById(id);
		}
	}

	/**
	 * 处理供方合租不合作状态
	 *
	 * @param data
	 */
	@Override
	public void enableSupplierOrNot(Map<String, Object> data) {
		supplierMapper.enableSupplierOrNot(data);
	}


	@Override
	public IPage<SupplierVO> queryPageList(QueryParam queryParam) {
		Map<String, Parameter> paramMap = queryParam.getParams();
		Map<String, Object> condition = new HashMap<String, Object>();
		for(Map.Entry<String, Parameter> entry:paramMap.entrySet()) {
			if("categoryId".equals(entry.getKey())) {
				if(StringUtils.isNotBlank(entry.getValue().getValue().toString())){
					SupplierCategoryEntity categoryEntity = categoryService.queryDetail(Long.parseLong(entry.getValue().getValue().toString()));
					if(categoryEntity != null) {
						condition.put("innerCode", categoryEntity.getInnerCode());
					}
				}
			}else{
				condition.put(entry.getKey(), entry.getValue().getValue());
			}
		}
		condition.put("pageIndex", (queryParam.getPageIndex()-1)*queryParam.getPageSize());
		condition.put("pageSize", queryParam.getPageSize());
		condition.put("tenantId", InvocationInfoProxy.getTenantid());
		//获取组织，若是集团，则查询本下级，若是分子公司，则向上查询一直到根节点下的分子公司为止
//		List<Long> orgIds = this.getOrgIds();
//		condition.put("orgIds", orgIds);

		List<SupplierEntity> supplierEntities = supplierMapper.queryList(condition);
		Long count = supplierMapper.queryCount(condition);

		List<SupplierVO> supplierVos = new ArrayList<SupplierVO>();
		SupplierVO supplierVo = null;
		for(SupplierEntity entity:supplierEntities) {
			supplierVo = BeanMapper.map(entity, SupplierVO.class);
			CommonResponse<DefdocDetailVO> defDocById = defdocApi.getDefDocById(supplierVo.getTaxPayerType());
			if(defDocById.isSuccess() && defDocById.getData() != null){
				supplierVo.setTaxPayerTypeName(defDocById.getData().getName());
			}

			supplierVos.add(supplierVo);
		}

		IPage<SupplierVO> resultPage = new Page<>();
		resultPage.setCurrent(queryParam.getPageIndex());
		resultPage.setRecords(supplierVos);
		resultPage.setTotal(count);
		return resultPage;
	}


	@Override
	public List<SupplierVO> queryExportList(QueryParam queryParam) {
		Map<String, Parameter> paramMap = queryParam.getParams();
		Map<String, Object> condition = new HashMap<String, Object>();
		for(Map.Entry<String, Parameter> entry:paramMap.entrySet()) {
			condition.put(entry.getKey(), entry.getValue().getValue());
		}
		//获取组织，若是集团，则查询本下级，若是分子公司，则向上查询一直到根节点下的分子公司为止
//		List<Long> orgIds = this.getOrgIds();
//		condition.put("orgIds", orgIds);
		List<SupplierEntity> supplierEntities = supplierMapper.queryExportList(condition);

		List<SupplierVO> supplierVos = new ArrayList<SupplierVO>();
		SupplierVO supplierVo = null;
		for(SupplierEntity entity:supplierEntities) {
			supplierVo = BeanMapper.map(entity, SupplierVO.class);
			CommonResponse<DefdocDetailVO> defDocById = defdocApi.getDefDocById(supplierVo.getTaxPayerType());
			if(defDocById.isSuccess() && defDocById.getData() != null){
				supplierVo.setTaxPayerTypeName(defDocById.getData().getName());
			}

			QueryParam linkerQueryParam = new QueryParam();
			linkerQueryParam.getParams().put("supplierId", new Parameter(QueryParam.EQ, supplierVo.getId()));
			List<SupplierLinkerEntity> linkerEntities = supplierLinkerService.queryList(linkerQueryParam, false);
			if(linkerEntities != null && linkerEntities.size() > 0) {
				SupplierLinkerEntity linkerEntity = linkerEntities.get(0);
				supplierVo.setLinkman(linkerEntity.getLinkman());
				supplierVo.setCellphone(linkerEntity.getCellphone());
			}
			supplierVos.add(supplierVo);
		}

		return supplierVos;
	}


	@Override
	public SupplierVO queryDetailBySocialCode(String socialCode) {
		QueryWrapper<SupplierEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("social_credit_code", socialCode);
		queryWrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
		List<SupplierEntity> entities = supplierMapper.selectList(queryWrapper);
		if(entities != null && entities.size() > 0) {
			return BeanMapper.map(entities.get(0), SupplierVO.class);
		}
		return null;
	}


	@Override
	public IPage<SupplierVO> queryRefMaterialPage(Map<String, Object> params) {
		//获取组织，若是集团，则查询本下级，若是分子公司，则向上查询一直到根节点下的分子公司为止
//		List<Long> orgIds = this.getOrgIds();
//		params.put("orgIds", orgIds);
		List<SupplierEntity> supplierEntities = supplierMapper.queryList(params);
		Long count = supplierMapper.queryCount(params);

		List<SupplierVO> supplierVos = new ArrayList<SupplierVO>();
		SupplierVO supplierVo = null;
		for(SupplierEntity entity:supplierEntities) {
			supplierVo = BeanMapper.map(entity, SupplierVO.class);

			CommonResponse<DefdocDetailVO> defDocById = defdocApi.getDefDocById(supplierVo.getTaxPayerType());
			if(defDocById.isSuccess() && defDocById != null){
				supplierVo.setTaxPayerTypeName(defDocById.getData().getName());
			}

			supplierVos.add(supplierVo);
		}

		IPage<SupplierVO> resultPage = new Page<>();
		resultPage.setRecords(supplierVos);
		resultPage.setTotal(count);
		return resultPage;
	}

	/**
	 * 供方协同（生成企业信息、租户、超级管理员等信息）
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> supplierCollaboration(SupplierVO supplierVO) {
		EnterpriseVO enterpriseVO = new EnterpriseVO();
		enterpriseVO.setName(supplierVO.getName());
		enterpriseVO.setId(IdWorker.getId());
		enterpriseVO.setCode(String.valueOf(enterpriseVO.getId()+1));
		enterpriseVO.setTelephone(supplierVO.getTelephone());
		enterpriseVO.setSocialCreditCode(supplierVO.getSocialCreditCode());
		enterpriseVO.setExamineState("1");
		enterpriseVO.setAuditName(supplierVO.getLegal());
		enterpriseVO.setRegisterPhoneNum(supplierVO.getTelephone());
		CommonResponse<EnterpriseVO> back = enterpriseApi.supplierCollaboration(enterpriseVO );
		if(back.isSuccess()){
			if(StringUtils.isNotBlank(sendMessageTemplateCode)){
				JSONObject messageParam = new JSONObject();
				messageParam.put("phone", supplierVO.getTelephone());
				if(StringUtils.isBlank(sendMessageTemplateCode)) {
					messageParam.put("templateCode", "SMS_195335074"); //登录验证模板
				}else{
					messageParam.put("templateCode", sendMessageTemplateCode);
				}
				Map<String, String> params = new HashMap<>();
				params.put("account", supplierVO.getTelephone());
				params.put("password", "a123456");
				messageParam.put("params", params);
				String messageUrl = baseHost + "/ejc-message-web/no_auth/sms/sendMessage";
				try {
					String responseStr = HttpTookit.postByJson(messageUrl, JSON.toJSONString(messageParam));
					logger.info("向手机号[{}]发送消息结果：[{}]", supplierVO.getTelephone(), responseStr);

					@SuppressWarnings("unchecked")
					CommonResponse<String> response = JSON.parseObject(responseStr, CommonResponse.class);
					if(response.isSuccess()) {
						logger.info("短信发送成功");
					}
				} catch (ConnectTimeoutException e) {
					logger.info(e.toString());
					e.printStackTrace();
				} catch (SocketTimeoutException e) {
					logger.info(e.toString());
					e.printStackTrace();
				} catch (Exception e) {
					logger.info(e.toString());
					e.printStackTrace();
				}
			}
			logger.info("回写供方租户信息开始----------->");
			EnterpriseVO enterprise = back.getData();
			SupplierEntity entity = this.getById(supplierVO.getId());
			entity.setTelephone(supplierVO.getTelephone());
			entity.setTenant(enterprise.getTenantId());
			entity.setTenantName(supplierVO.getName());
			entity.setTenantPhone(supplierVO.getTelephone());
			entity.setTenantUserName(supplierVO.getLegal());
			this.saveOrUpdate(entity, false);
			logger.info("----------->回写供方租户信息结束");
			return CommonResponse.success("生成企业账号成功！");
		}else{
			return CommonResponse.error(back.getMsg());
		}
	}


	@Override
	public SupplierVO querySupplierByTenantId(Long tenant) {
		QueryWrapper<SupplierEntity> wrapper = new QueryWrapper<>();
		wrapper.eq("tenant", tenant);
		List<SupplierEntity> entities = supplierMapper.selectList(wrapper);
		if(entities != null&&entities.size()>0) {
			return BeanMapper.map(entities.get(0), SupplierVO.class);
		}
		return null;
	}

	/**
	 *
	 * 组织调用----生成内部客商（客户供应商）
	 * */
	@Override
	public CommonResponse<String> generateInsideSupplierAndCustomer(List<OrgVO> orgList) {
		if(orgList!=null&&orgList.size()>0){
			//获取内部供方分类id
			QueryWrapper<SupplierCategoryEntity> querySupplierCategoryWrapper = new QueryWrapper<>();
			querySupplierCategoryWrapper.eq("code", insideSupplierCategoryCode);
			querySupplierCategoryWrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
			List<SupplierCategoryEntity> supplierCategoryList = categoryService.list(querySupplierCategoryWrapper);
			SupplierCategoryEntity supplierCategory = null;
			if(supplierCategoryList!=null&&supplierCategoryList.size()>0){
				supplierCategory = supplierCategoryList.get(0);
			}else{
				supplierCategory = new SupplierCategoryEntity();
				Long id = IdWorker.getId();
				supplierCategory.setCode(insideSupplierCategoryCode);
				supplierCategory.setName("内部供应商");
				supplierCategory.setId(id);
				supplierCategory.setInnerCode(id.toString());
				categoryService.saveOrUpdate(supplierCategory, false);
			}

			QueryWrapper<CustomerCategoryEntity> queryCustomerCategoryWrapper = new QueryWrapper<>();
			queryCustomerCategoryWrapper.eq("code", insideCustomerCategoryCode);
			queryCustomerCategoryWrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
			List<CustomerCategoryEntity> customerCategoryList = customerCategoryService.list(queryCustomerCategoryWrapper);
			CustomerCategoryEntity customerCategory = null;
			if(customerCategoryList!=null&&customerCategoryList.size()>0){
				customerCategory = customerCategoryList.get(0);
			}else{
				customerCategory = new CustomerCategoryEntity();
				Long id = IdWorker.getId();
				customerCategory.setCode(insideCustomerCategoryCode);
				customerCategory.setName("内部客户");
				customerCategory.setId(id);
				customerCategory.setInnerCode(id.toString());
				customerCategoryService.saveOrUpdate(customerCategory, false);
			}
			//判断当前组织是否已生成客商（由于内部客户/供应商档案是同步生成的，所以在此只判断供应商就可以）
			List<Long> orgIds = new ArrayList<>();
			for(OrgVO orgVO : orgList){
				orgIds.add(orgVO.getId());
			}
			QueryWrapper<SupplierEntity> queryWrapper = new QueryWrapper<>();
			queryWrapper.in("inside_org_id", orgIds);
			queryWrapper.eq("dr", 0);
			List<SupplierEntity> exitList = this.list(queryWrapper);
			String exitmsg = "";
			List<OrgVO> addVO = new ArrayList<>();
			if(exitList!=null&&exitList.size()>0){
				//说明存在已生成的客商
				List<Long> exitOrgIds = new ArrayList<>();
				for(SupplierEntity supplierEntity : exitList){
					exitOrgIds.add(supplierEntity.getInsideOrgId());
					if(exitmsg.length()>0){
						exitmsg += (","+supplierEntity.getName());
					}else{
						exitmsg += supplierEntity.getName();
					}
				}
				if(exitList.size()==orgList.size()){
					return CommonResponse.success("组织："+exitmsg+"已生成客商档案");
				}
				for(OrgVO orgVO : orgList){
					if(!exitOrgIds.contains(orgVO.getId())){
						addVO.add(orgVO);
					}
				}
			}else{
				//说明全部需哟啊生成供商
				addVO = orgList;
			}
			List<SupplierEntity> addSupplierEntity = new ArrayList<>();
			List<CustomerEntity> addCustomerEntity = new ArrayList<>();
			for(OrgVO orgVO : addVO){
				//生成供方
				SupplierEntity supplierEntity = new SupplierEntity();
				supplierEntity.setCode(orgVO.getCode());
				supplierEntity.setName(orgVO.getName());
				supplierEntity.setLegal(orgVO.getManager());
				supplierEntity.setTelephone(orgVO.getPhone());
				supplierEntity.setCategoryId(supplierCategory.getId());
				supplierEntity.setCategoryName(supplierCategory.getName());
				supplierEntity.setId(orgVO.getId());
				supplierEntity.setInsideOrgId(orgVO.getId());
				supplierEntity.setInsideOrg(true);//内部单位
				supplierEntity.setPersonal("p");//企业
				supplierEntity.setGroupInOrOut("in");//集团内
				supplierEntity.setApplyOrgId(InvocationInfoProxy.getOrgId());//申请单位
				supplierEntity.setApplyOrgName(iOrgApi.getOneById(InvocationInfoProxy.getOrgId()).getData().getName());//申请单位

				supplierEntity.setEnabled(1);
				supplierEntity.setOrgId(orgVO.getId());
				supplierEntity.setSupplierFlag(1);
				supplierEntity.setSubFlag(1);
				supplierEntity.setBlacklistFlag(0);
				supplierEntity.setRedlistFlag(0);
				addSupplierEntity.add(supplierEntity);
				//生成客户
				CustomerEntity customerEntity = new CustomerEntity();
				customerEntity.setCode(orgVO.getCode());
				customerEntity.setName(orgVO.getName());
				customerEntity.setLegal(orgVO.getManager());
				customerEntity.setTelephone(orgVO.getPhone());
				customerEntity.setCategoryId(customerCategory.getId());
				customerEntity.setCategoryName(customerCategory.getName());
				customerEntity.setId(orgVO.getId());
				customerEntity.setInsideOrg(true);//内部单位
				customerEntity.setEnabled(1);
				customerEntity.setInsideOrgId(orgVO.getId());
				customerEntity.setOrgId(orgVO.getId());
				customerEntity.setOrgName(orgVO.getName());
				addCustomerEntity.add(customerEntity);
			}
			if(addSupplierEntity!=null&&addSupplierEntity.size()>0){
				this.saveOrUpdateBatch(addSupplierEntity, addSupplierEntity.size(), false);
				customerService.saveOrUpdateBatch(addCustomerEntity, addCustomerEntity.size(), false);
			}
			if(exitmsg.length()>0){
				return CommonResponse.success("生成内部客商成功，其中以下组织："+exitmsg+"已生成客商档案");
			}
		}else{
			return CommonResponse.error("请选择生成客商的组织！！！");
		}
		
		return CommonResponse.success("生成内部客商成功！");
	}

	/**
	 * 组织调用----更新内部客商（客户供应商）
	 *
	 * @param orgVO
	 */
	@Override
	public CommonResponse<OrgVO> updateInsideSupplierAndCustomer(OrgVO orgVO) {
		QueryParam param = new QueryParam();
		param.getParams().put("insideOrgId",new Parameter(QueryParam.EQ,orgVO.getId()));
		List<SupplierEntity> exitList = this.queryList(param,false);
		if(ListUtil.isNotEmpty(exitList)){
			SupplierEntity supplierEntity = exitList.get(0);
			supplierEntity.setCode(orgVO.getCode());
			supplierEntity.setName(orgVO.getName());
			supplierEntity.setLegal(orgVO.getManager());
			supplierEntity.setTelephone(orgVO.getPhone());
			supplierEntity.setInsideOrg(true);//内部单位
			supplierEntity.setEnabled(orgVO.getState());
			saveOrUpdate(supplierEntity,false);
		}
		List<CustomerEntity> addCustomerEntity = customerService.queryList(param,false);
		if(ListUtil.isNotEmpty(addCustomerEntity)){
			CustomerEntity customerEntity = addCustomerEntity.get(0);
			customerEntity.setCode(orgVO.getCode());
			customerEntity.setName(orgVO.getName());
			customerEntity.setLegal(orgVO.getManager());
			customerEntity.setTelephone(orgVO.getPhone());
			customerEntity.setInsideOrg(true);//内部单位
			customerEntity.setEnabled(orgVO.getState());
			customerEntity.setOrgName(orgVO.getName());
			customerService.saveOrUpdate(customerEntity,false);
		}

		return CommonResponse.success(orgVO);
	}

	/**
	 * 将供应商生成公有云租户
	 *
	 * @param se
	 */
	@Override
	public SupplierEntity generateSupplierTenant(SupplierEntity se) {

		PushToPublicSupplierInfoVO pushVo = getPushVo(se);

		CommonResponse<String> res = systemDataPushService.exchangeDataWithUniversal(
				"/ejc-oms-web/openapi/enterprise/createGfmhTenant",//调用生成供方接口，一步到位，返回租户信息
				RequestMethod.POST,
				JSONObject.toJSONString(pushVo),
				appId,
				secret,
				eachLinkHost
		);
		if(res.isSuccess()){
			JSONObject object = JSONObject.parseObject(res.getData());
			if(object.getInteger("code") == 0){
				TenantVO tenantVO= JSONObject.parseObject(object.getString("data"),TenantVO.class);
				se.setSystemId(tenantVO.getEnterpriseId().toString());
				se.setTenant(tenantVO.getId());
				se.setTenantName(tenantVO.getName());
				se.setTenantUserId(tenantVO.getManagerId());
				se.setCoordination(true);
				se.setTenantPhone(tenantVO.getManagerPhone());
				se.setTenantUserName(tenantVO.getManagerName());
			}else {
				/** 借用TenantName返回错误信息 */
				se.setTenantName(object.getString("msg"));
				se.setCoordination(false);
			}
		}else {
			/** 借用TenantName返回错误信息 */
			se.setTenantName(res.getMsg());
			se.setCoordination(false);
		}
		return se;
	}

	/**
	 * 将分包负责人生成公有云租户
	 *
	 * @param subLeader
	 * @param se
	 */
	@Override
	public SupplierEntity generateSubSupplierTenant(SubleadersEntity subLeader, SupplierEntity se) {
		SupplierEntity sub = BeanMapper.map(se,SupplierEntity.class);
		sub.setId(subLeader.getId());//供应商id
		sub.setTenant(null);//清空租户
		sub.setTenantUserName(subLeader.getName());//租户超管名称
		sub.setTenantPhone(subLeader.getPhone());//租户超管手机
		sub.setPersonal("s");//班组
		sub.setTaxPayerIdentifier(subLeader.getIdNum());//租户超管纳税人识别号身份证号
		sub.setName(subLeader.getName());//租户企业名称
		sub.setLegal(subLeader.getName());//租户企业名称
		sub.setCategoryId(null);
		sub.setLoadTenantId(se.getTenant());//挂载的租户id
		sub = generateSupplierTenant(sub);
		subLeader.setEjcTenantId(sub.getTenant());
		subLeader.setEjcUserId(sub.getCategoryId());
		subLeader.setSystemId(sub.getSystemId());
		subLeader.setCoordination(sub.getCoordination());
		if(sub.getCoordination()){
			subLeader.setName(sub.getTenantUserName());
			subLeader.setPhone(sub.getTenantPhone());
		}
		return sub;
	}

	/**
	 * 将供应商生成公有云租户
	 *
	 * @param supplierId
	 * @param name
	 * @param telephone
	 */
	@Override
	public CommonResponse<String> generateSupplierTenant(Long supplierId, String name, String telephone) {
		SupplierEntity se = selectById(supplierId);
		if(se == null){
			return CommonResponse.error("没有查询到此供应商！");
		}
		if(se.getCoordination()!=null && se.getCoordination()){
			/** 已协同的，修改？*/
			return CommonResponse.success("已协同，无需再协同，修改吗？");
		}
		se.setTenantPhone(telephone);
		se.setTenantUserName(name);
		se.setCoordination(true);
		se = generateSupplierTenant(se);
		CommonResponse<String> res = CommonResponse.success("操作成功！");
		if(se.getCoordination()){
			saveOrUpdate(se,false);
			//分包供应商 分包负责人
			if(SupplierQueryType.laborSub.equals(se.getSupplyQueryType())){
				if(ListUtil.isNotEmpty(se.getSubLeaders()) ){
					for (SubleadersEntity subLeader : se.getSubLeaders()) {
						generateSubSupplierTenant(subLeader,se);
						subleadersService.saveOrUpdate(subLeader);
					}
				}
			}
		}else {
			res = CommonResponse.error(se.getTenantName());
		}
		return res;
	}

	@Override
	public void syncYzwSupplierList(List<SupplierVO> list) {
		List<String> codes = new ArrayList<>();
		for (SupplierVO supplierVO : list) {
			codes.add(supplierVO.getSocialCreditCode());
		}
		QueryWrapper<SupplierEntity> wrapper = new QueryWrapper<>();
		wrapper.in("social_credit_code", codes);
		List<SupplierEntity> data = this.list(wrapper);
		Map<String, SupplierEntity> map = new HashMap<>();
		if(data!=null && data.size()>0){
			for (SupplierEntity datum : data) {
				map.put(datum.getSocialCreditCode(), datum);
			}
		}
		QueryWrapper<SupplierCategoryEntity> categoryWrapper = new QueryWrapper<>();
		categoryWrapper.isNull("parent_id");
		List<SupplierCategoryEntity> entities = categoryService.list(categoryWrapper);
		Long categoryId = null;
		String categoryName = null;
		if(entities!=null && entities.size()>0){
			categoryId = entities.get(0).getId();
			categoryName = entities.get(0).getName();
		}
		List<SupplierEntity> saveData = new ArrayList<>();
		for (SupplierVO supplierVO : list) {
			SupplierEntity entity = null;
			if(map.get(supplierVO.getSocialCreditCode())!=null){
				entity = map.get(supplierVO.getSocialCreditCode());
				if(StringUtils.isBlank(entity.getYzwSupplierCode())){
					entity.setYzwSupplierCode(supplierVO.getYzwSupplierCode());
					saveData.add(entity);
				}else if(!entity.getYzwSupplierCode().equals(supplierVO.getYzwSupplierCode())){
					//社会统一信用代码一致，但是云筑编码不一致，修改（理论上来说不该有这样的数据）
					entity.setYzwSupplierCode(supplierVO.getYzwSupplierCode());
					saveData.add(entity);
				}
				if(entity.getCategoryId()==null){
					entity.setCategoryId(categoryId);
					entity.setCategoryName(categoryName);
				}
				entity.setEnabled(1);
				saveData.add(entity);
			}else{
				entity = BeanMapper.map(supplierVO, SupplierEntity.class);
				//获取根节点分类
				entity.setCategoryId(categoryId);
				entity.setCategoryName(categoryName);
				entity.setEnabled(1);
				saveData.add(entity);
			}
		}
		if(saveData!=null && saveData.size()>0){
			this.saveOrUpdateBatch(saveData, saveData.size(), false);
		}
	}

	@Override
	public List<SupplierVO> getYzwSupplierList(List<String> codes) {
		QueryWrapper<SupplierEntity> wrapper = new QueryWrapper<>();
		wrapper.in("yzw_supplier_code", codes);
		List<SupplierEntity> data = this.list(wrapper);
		List<SupplierVO> vos = new ArrayList<>();
		if(data!=null && data.size()>0){
			vos = BeanMapper.mapList(data, SupplierVO.class);
		}
		return vos;
	}

	private PushToPublicSupplierInfoVO getPushVo(SupplierEntity se){
		PushToPublicSupplierInfoVO pushVo = new PushToPublicSupplierInfoVO();
		pushVo.setArea(se.getAreaName());
//		 1：企业， 2：个人，3：班组长
		pushVo.setEnterpriseType("1");
		pushVo.setBusinessType("2");//供应商
		pushVo.setRegisterPhoneNum(se.getTenantPhone());
		pushVo.setName(se.getName());
		pushVo.setFullName(se.getName());
		pushVo.setTaxCode(se.getSocialCreditCode());
		pushVo.setLegalName(se.getLegal());
		pushVo.setTelephone(se.getTenantPhone());
		pushVo.setAuditName(se.getTenantUserName());//借用审核人
		pushVo.setCommitTime(se.getRegisterTime());
		pushVo.setSocialCreditCode(se.getSocialCreditCode());
		pushVo.setRegistCapital(se.getRegisteredCapital()==null?"0.00":se.getRegisteredCapital().toPlainString());
		pushVo.setDescription(se.getBusinessScope());
		pushVo.setSupplierId(se.getId());
		QueryParam param = new QueryParam();
		List<EjcCloudSystemEntity> list =  ejcCloudSystemService.queryList(param,false);
		pushVo.setSystemId(list.get(0).getCode());
		pushVo.setUserId(se.getTenantUserId());
		return pushVo;
	}

}
