package com.ejianc.foundation.share.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.bean.LabsubItemEntity;
import com.ejianc.foundation.share.bean.MaterialCategoryEntity;
import com.ejianc.foundation.share.service.ILabsubItemService;
import com.ejianc.foundation.share.vo.LabsubCategoryImportVO;
import com.ejianc.foundation.share.vo.LabsubCategoryVO;
import com.ejianc.foundation.share.vo.ProsubCategoryVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.foundation.share.mapper.LabsubCategoryMapper;
import com.ejianc.foundation.share.bean.LabsubCategoryEntity;
import com.ejianc.foundation.share.service.ILabsubCategoryService;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 劳务分包分类
 * 
 * @author generator
 * 
 */
@Service("labsubCategoryService")
public class LabsubCategoryServiceImpl extends BaseServiceImpl<LabsubCategoryMapper, LabsubCategoryEntity> implements ILabsubCategoryService{
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "LSC_CODE";
    @Autowired
    private ILabsubCategoryService service;
    @Autowired
    private ILabsubItemService labsubItemService;
    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private LabsubCategoryMapper labsubCategoryMapper;

    @Override
    public CommonResponse<LabsubCategoryVO> saveOrUpdateLabsubCategory(LabsubCategoryVO saveorUpdateVO) {
        LabsubCategoryEntity entity = BeanMapper.map(saveorUpdateVO, LabsubCategoryEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setCategoryCode(billCode.getData());
                entity.setOrgId(sessionManager.getUserContext().getOrgId());
                entity.setOrgName(sessionManager.getUserContext().getOrgName());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }else {
            LambdaUpdateWrapper<LabsubCategoryEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(LabsubCategoryEntity::getId,saveorUpdateVO.getId());
            updateWrapper.set(LabsubCategoryEntity::getCategoryName,saveorUpdateVO.getCategoryName());
            updateWrapper.set(LabsubCategoryEntity::getOrgId,sessionManager.getUserContext().getOrgId());
            updateWrapper.set(LabsubCategoryEntity::getOrgName,sessionManager.getUserContext().getOrgName());
            updateWrapper.set(LabsubCategoryEntity::getRemarks,saveorUpdateVO.getRemarks());
            service.update(updateWrapper);
            return CommonResponse.success("保存或修改单据成功！");
        }
        entity.setId(IdWorker.getId());
        if(entity.getParentId() != null && entity.getParentId() > 0) {
            LabsubCategoryEntity labsubCategoryEntity = service.selectById(entity.getParentId());
            entity.setInnerCode(labsubCategoryEntity.getInnerCode()+"|"+entity.getId());
        }else{
            entity.setInnerCode(entity.getId().toString());
        }
        service.save(entity);
        LabsubCategoryVO vo = BeanMapper.map(entity, LabsubCategoryVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @Override
    public List<LabsubCategoryVO> queryLabsubCategoryList(QueryParam queryParam) {
        Map<String, Parameter> paramMap = queryParam.getParams();

        Map<String,Object> condition = new HashMap<>();
        for(Map.Entry<String, Parameter> entry:paramMap.entrySet()) {
            condition.put(entry.getKey(), entry.getValue().getValue());
        }
        //放入租户ID进map
        condition.put("tenantId", InvocationInfoProxy.getTenantid());
        List<LabsubCategoryVO> resultList = baseMapper.queryLabsubCategoryList(condition);
        return resultList;
    }

    @Override
    public CommonResponse<String> deleteById(List<LabsubCategoryVO> vos) {
        List<Long> collect = vos.stream().map(LabsubCategoryVO::getId).collect(Collectors.toList());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("category_id",new Parameter(QueryParam.IN, collect));
        List<LabsubItemEntity> prosubItemEntities = labsubItemService.queryList(queryParam);
        /**是否关联档案**/
        if(CollectionUtils.isNotEmpty(prosubItemEntities)){
            return CommonResponse.error("分类下关联专业分包档案！");
        }
        /****/
        QueryParam queryClassifyParam = new QueryParam();
        queryClassifyParam.getParams().put("parent_id",new Parameter(QueryParam.IN, collect));
        List<LabsubCategoryEntity> prosubItems = service.queryList(queryClassifyParam);
        if (CollectionUtils.isNotEmpty(prosubItems)){
            return CommonResponse.error("分类下关联子分类不允许删除！");
        }
        service.removeByIds(vos.stream().map(LabsubCategoryVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        List<LabsubCategoryImportVO> successList = new ArrayList<>();
        List<LabsubCategoryImportVO> processList = new ArrayList<>();
        List<LabsubCategoryImportVO> errorList = new ArrayList<>();
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if(isFailed) {
            return CommonResponse.error("文件格式不合法");
        }else{
            List<List<String>> result = ExcelReader.readExcel(mf);
            if(result != null && result.size() > 0) {
                if(result.size() > 10000) {
                    return CommonResponse.error("分类数据超过10000条，请分批上传！");
                }
                Map<String,List<LabsubCategoryImportVO>> mapChildren = new HashMap<>();
                Map<String,LabsubCategoryImportVO> codeToData = new HashMap<>();
                Map<String,String> codeNotExistData = new HashMap<>();
                for(int i = 0;i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    LabsubCategoryImportVO LabsubsubCategoryImportVO = new LabsubCategoryImportVO();
                    LabsubsubCategoryImportVO.setId(IdWorker.getId());
                    LabsubsubCategoryImportVO.setCategoryCode(datas.get(0));
                    LabsubsubCategoryImportVO.setParentCode(datas.get(1));
                    LabsubsubCategoryImportVO.setCategoryName(datas.get(2));
                    LabsubsubCategoryImportVO.setRemarks(datas.get(3));
                    if(StringUtils.isBlank(datas.get(0))){
                        LabsubsubCategoryImportVO.setRemarks("分类编码为空！");
                        errorList.add(LabsubsubCategoryImportVO);
                        continue;
                    }
                    if(StringUtils.isBlank(datas.get(2))){
                        LabsubsubCategoryImportVO.setRemarks("分类名称为空！");
                        errorList.add(LabsubsubCategoryImportVO);
                        continue;
                    }
                    //通过物料分类Code获取物料分类
                    QueryParam queryParam = new QueryParam();
                    queryParam.getParams().put("categoryCode",new Parameter(QueryParam.EQ,String.valueOf(datas.get(0))));
                    List<LabsubCategoryEntity> list = service.queryList(queryParam, false);
                    if(ListUtil.isEmpty(list)) {
                        //通过分类name获取物料分类
                        queryParam = new QueryParam();
                        queryParam.getParams().put("categoryName",new Parameter(QueryParam.EQ,String.valueOf(datas.get(2))));
                        list = service.queryList(queryParam, false);
                        if(ListUtil.isNotEmpty(list)) {
                            LabsubsubCategoryImportVO.setRemarks("分类名称重复！");
                            errorList.add(LabsubsubCategoryImportVO);
                            continue;
                        }
                        if(StringUtils.isBlank(datas.get(1))){
                            LabsubsubCategoryImportVO.setInnerCode(LabsubsubCategoryImportVO.getId().toString());
                        }
                        LabsubsubCategoryImportVO.setCreateUserCode(InvocationInfoProxy.getUsercode());
                        LabsubsubCategoryImportVO.setCreateTime(new Date());
                        LabsubsubCategoryImportVO.setTenantId(InvocationInfoProxy.getTenantid());
                        processList.add(LabsubsubCategoryImportVO);
                        codeToData.put(LabsubsubCategoryImportVO.getCategoryCode(),LabsubsubCategoryImportVO);
                        if(StringUtils.isBlank(LabsubsubCategoryImportVO.getParentCode())){
                            List<LabsubCategoryImportVO> list1 = mapChildren.get("null");
                            if(ListUtil.isEmpty(list1)){
                                list1=new ArrayList<>();
                                mapChildren.put("null",list1);
                            }
                            list1.add(LabsubsubCategoryImportVO);
                        }else {
                            List<LabsubCategoryImportVO> list1 = mapChildren.get(LabsubsubCategoryImportVO.getParentCode());
                            if(ListUtil.isEmpty(list1)){
                                list1=new ArrayList<>();
                                mapChildren.put(LabsubsubCategoryImportVO.getParentCode(),list1);
                            }
                            list1.add(LabsubsubCategoryImportVO);
                        }
                    }else{
                        LabsubsubCategoryImportVO.setRemarks("分类编码重复！");
                        errorList.add(LabsubsubCategoryImportVO);
                    }
                }
                if(ListUtil.isNotEmpty(processList)){
                    processList.forEach(p->{
                        if(StringUtils.isNotEmpty(p.getParentCode())){
                            LabsubCategoryImportVO parentVo = codeToData.get(p.getParentCode());
                            if(parentVo == null){
                                if(StringUtils.isNotEmpty(codeNotExistData.get(p.getParentCode()))){
                                    p.setRemarks("父分类编码不存在");
                                    errorList.add(p);
                                }else {
                                    QueryParam queryParam = new QueryParam();
                                    queryParam.getParams().put("categoryCode",new Parameter(QueryParam.EQ,p.getParentCode()));
                                    List<LabsubCategoryEntity> list = service.queryList(queryParam,false);
                                    if(ListUtil.isEmpty(list)){
                                        codeNotExistData.put(p.getParentCode(),p.getParentCode());
                                        p.setRemarks("父分类编码不存在");
                                        errorList.add(p);
                                    }else {
                                        p.setInnerCode(list.get(0).getInnerCode()+"|"+p.getId());
                                        p.setParentId(list.get(0).getId());
                                        successList.add(p);
                                    }
                                }
                            }else {
                                if(StringUtils.isEmpty(parentVo.getInnerCode())){
                                    setInnerCodeAndParentId(parentVo,codeToData,codeNotExistData);
                                    if(StringUtils.isEmpty(parentVo.getInnerCode())){
                                        p.setRemarks("父分类编码不存在");
                                        errorList.add(p);
                                    }else {
                                        p.setInnerCode(parentVo.getInnerCode()+"|"+p.getId());
                                        p.setParentId(parentVo.getId());
                                        successList.add(p);
                                    }
                                }else {
                                    p.setInnerCode(parentVo.getInnerCode()+"|"+p.getId());
                                    p.setParentId(parentVo.getId());
                                    successList.add(p);
                                }
                            }
                        }else {
                            successList.add(p);
                        }
                    });
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success(json);
    }

    @Override
    public void updateSubject(Long subjectId, String subjectName, List<Long> ids) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<LabsubCategoryEntity> labsubCategoryEntities = labsubCategoryMapper.queryByInnerCodes(tenantId, ids);
        ids.clear();
        labsubCategoryEntities.forEach(item->{
            ids.add(item.getId());
        });
        labsubCategoryMapper.updateSubject(tenantId,subjectId,subjectName,ids);
    }

    private void setInnerCodeAndParentId(LabsubCategoryImportVO vo, Map<String,LabsubCategoryImportVO> codeToData, Map<String,String> codeNotExistData){
        LabsubCategoryImportVO parentVo = codeToData.get(vo.getParentCode());
        if(parentVo == null ){
            if(StringUtils.isNotEmpty(codeNotExistData.get(vo.getParentCode()))){
                vo.setRemarks("父分类编码不存在");
            }else {
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("categoryCode",new Parameter(QueryParam.EQ,vo.getParentCode()));
                List<LabsubCategoryEntity> list = service.queryList(queryParam,false);
                if(ListUtil.isEmpty(list)){
                    codeNotExistData.put(vo.getParentCode(),vo.getParentCode());
                    vo.setRemarks("父分类编码不存在");
                }else {
                    vo.setInnerCode(list.get(0).getInnerCode()+"|"+vo.getId());
                    vo.setParentId(list.get(0).getId());
                }
            }
        }else {
            if(StringUtils.isEmpty(parentVo.getInnerCode())){
                setInnerCodeAndParentId(parentVo,codeToData,codeNotExistData);
                if(StringUtils.isEmpty(parentVo.getInnerCode())){
                    vo.setRemarks("父分类编码不存在");
                }else {
                    vo.setInnerCode(parentVo.getInnerCode()+"|"+vo.getId());
                    vo.setParentId(parentVo.getId());
                }
            }else {
                vo.setInnerCode(parentVo.getInnerCode()+"|"+vo.getId());
                vo.setParentId(parentVo.getId());
            }

        }
    }
}
