package com.ejianc.foundation.share.controller.api;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.ejianc.foundation.share.service.IEquipmentCategoryService;
import com.ejianc.foundation.share.service.IEquipmentService;
import com.ejianc.foundation.share.vo.EquipmentVO;
import com.ejianc.framework.core.response.CommonResponse;

@RestController
@RequestMapping("/api/shareEquipmentApi/")
public class EquipmentApi {

    @Autowired
    private IEquipmentService equipmentService;
	@Autowired
	private IEquipmentCategoryService equipmentCategoryService;

    /**
     * 根据编码查询设备详情
     * @Author liyongjia
     * @param code
     * @return
     */
    @GetMapping("queryEquipmentByCode")
    public CommonResponse<EquipmentVO> queryMaterialByCode(@RequestParam(value = "code") String code) {
        EquipmentVO vo = equipmentService.queryByCode(String.valueOf(code));
        if(vo == null){
            return CommonResponse.error("查询失败,没有查询到该编码对应的设备！");
        }
    	return CommonResponse.success("查询成功！", vo);
    }
}
