package com.ejianc.foundation.share.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.foundation.share.bean.ProjectWbsEntity;
import com.ejianc.foundation.share.bean.SubjectOrgEntity;
import com.ejianc.foundation.share.mapper.ProjectWbsMapper;
import com.ejianc.foundation.share.service.IProjectWbsService;
import com.ejianc.foundation.share.vo.ProjectWbsVO;
import com.ejianc.foundation.util.ExcelImportUtil;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * 项目WBS
 * 
 * @author generator
 * 
 */
@Service("projectWbsService")
public class ProjectWbsServiceImpl extends BaseServiceImpl<ProjectWbsMapper, ProjectWbsEntity> implements IProjectWbsService{

    @Autowired
    private IProjectWbsService service;

    @Override
    public CommonResponse<ProjectWbsVO> saveOrUpdate(ProjectWbsVO projectWbsVO) {
        ProjectWbsEntity entity = new ProjectWbsEntity();
        QueryParam param = new QueryParam();
        //新增修改校验名称是否重复
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("code", new Parameter(QueryParam.EQ, projectWbsVO.getCode()));
        param.getParams().put("orgId", new Parameter(QueryParam.EQ, projectWbsVO.getOrgId()));
        List<ProjectWbsEntity> projectWbsEntities = service.queryList(param);
        if(null!=projectWbsVO.getId()){
            //修改重新查询
            entity = service.getById(projectWbsVO.getId());
            if((!entity.getCode().equals(projectWbsVO.getCode()))&& CollectionUtils.isNotEmpty(projectWbsEntities)){
                return CommonResponse.error("单据编码不能重复！");
            }
            //查询是否存在子节点，存在则更新
            param.getParams().remove("code");
            param.getParams().put("parentId",new Parameter(QueryParam.EQ,entity.getId()));
            List<ProjectWbsEntity> projectWbsEntityList = getChildrenByPid(entity.getId());
            for(ProjectWbsEntity projectWbsEntity : projectWbsEntityList){
                projectWbsEntity.setEnabled(projectWbsVO.getEnabled());
            }
            for(ProjectWbsEntity projectWbsEntity : projectWbsEntityList){
                if(projectWbsEntity.getId().equals(entity.getId())){
                    projectWbsEntityList.remove(projectWbsEntity);
                    break;
                }
            }
            if(CollectionUtils.isNotEmpty(projectWbsEntityList)){
                saveOrUpdateBatch(projectWbsEntityList);
            }
        }else {
            if(CollectionUtils.isNotEmpty(projectWbsEntities)){
                return CommonResponse.error("单据编码不能重复！");
            }
        }
        entity.setParentId(projectWbsVO.getParentId());
        entity.setOrgId(projectWbsVO.getOrgId());
        entity.setName(projectWbsVO.getName());
        entity.setCode(projectWbsVO.getCode());
        entity.setMemo(projectWbsVO.getMemo());
        entity.setEnabled(projectWbsVO.getEnabled());
        service.saveOrUpdate(entity, false);
        if (entity.getParentId() != null && entity.getParentId() > 0) {
            ProjectWbsEntity uniqueBean = baseMapper.selectById(entity.getParentId());
            entity.setInnerCode(uniqueBean.getInnerCode() + "," + entity.getId());
        } else {
            entity.setInnerCode(entity.getId().toString());
        }
        service.saveOrUpdate(entity, false);
        ProjectWbsVO vo = BeanMapper.map(entity, ProjectWbsVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        JSONObject resp = new JSONObject();

        if (isFailed) {
            return CommonResponse.error("文件格式不合法！");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if(result != null && result.size() > 0) {
                //父子关系重复校验
                Map<String, Integer> indexMap = new HashMap<>();
                //父子关系虚拟主键映射
                List<ProjectWbsVO> projectWbsVOList = new ArrayList<>();
                Map<String,String> tidMap = new HashMap<>();
                //编码重复校验
                List<String> excelCodeList = new ArrayList<>();
                //查询所有成本科目-集团
                QueryParam queryParam = new QueryParam();
                List<String> codeList = new ArrayList<>();
                List<ProjectWbsEntity> oldList = service.queryList(queryParam);
                for(ProjectWbsEntity projectWbsEntity : oldList){
                    codeList.add(projectWbsEntity.getCode());
                }
                //结果集遍历
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    ProjectWbsVO vo = new ProjectWbsVO();
                    boolean flag = false;
                    boolean parentWarn = false;
                    String warnType = "";

                    //编号
                    String code = datas.get(0);
                    vo.setCode(code);
                    //父编号
                    String parentCode = datas.get(1);
                    //维护父子关系(虚拟id)
                    String id = UUID.randomUUID().toString().replaceAll("-", "");
                    //设置虚拟id
                    vo.setTid(id);
                    //虚拟id映射
                    tidMap.put(code,id);
                    //设置虚拟父id
                    vo.setTpid(parentCode);

                    //导入数据校验
                    //编码非空
                    if(StringUtils.isEmpty(code)){
                        vo.setCode(null);
                        warnType = warnType+"编码为空,";
                        flag = true;
                        parentWarn = true;
                    }else{
                        //编码重复
                        if(codeList.contains(code)){
                            vo.setCode(code);
                            warnType = warnType+"编码重复,";
                            flag = true;
                            parentWarn = true;
                        }
                        if(excelCodeList.contains(code)){
                            vo.setCode(code);
                            warnType = warnType+"文件编码重复,";
                            flag = true;
                            parentWarn = true;
                        }else{
                            excelCodeList.add(code);
                        }
                        vo.setCode(code);
                    }
                    String name = datas.get(2);
                    if(StringUtils.isEmpty(name)){
                        vo.setName(null);
                        warnType = warnType+"名称为空,";
                        flag = true;
                        parentWarn = true;
                    }else{
                        vo.setName(name);
                    }
                    vo.setMemo(datas.get(3));
                    vo.setEnabled(1);
                    // true=可以导入，false=不可导入
                    vo.setImportFlag(!flag);
                    vo.setParentWarn(parentWarn);
                    if(flag){
                        warnType = warnType.substring(0,warnType.length()-1);
                    }
                    vo.setWarnType(warnType);
                    vo.setRowState("add");
                    vo.setShadowId(vo.getTid());
//                    vo.setChangeType(3);//增补项

                    projectWbsVOList.add(vo);
                }

                //此处将之前存储的code转换为虚拟id
                for(ProjectWbsVO tVo:projectWbsVOList){
                    if(StringUtils.isNotEmpty(tidMap.get(tVo.getTpid()))){
                        tVo.setTpid(tidMap.get(tVo.getTpid()));
                    }
                }
                List<Map<String, Object>> deailTreeData =ExcelImportUtil.treeData(BeanMapper.mapList(projectWbsVOList, Map.class));
                List<Map<String, Object>> mapList = ExcelImportUtil.importFlag(deailTreeData);
                List<Map<String, Object>> falseList = new ArrayList<>();
                List<List<Map<String, Object>>> allList = ExcelImportUtil.separate(mapList, falseList);
                List<Map<String, Object>> errorList=ExcelImportUtil.treeToList(allList.get(1),true);
                List<Map<String, Object>> successList=ExcelImportUtil.treeToList(allList.get(0),false);
                resp.put("successList",successList);
                resp.put("errorList",errorList);
                resp.put("successNum",result.size() - errorList.size());
                resp.put("errorNum",errorList.size());
                return CommonResponse.success(resp);
            }
            return CommonResponse.error("Excel为空");
        }
    }

    @Override
    public String saveImportExcel(HttpServletRequest request, List<ProjectWbsVO> importVOS) {
        if (ListUtil.isEmpty(importVOS)) {
            throw new BusinessException("导入的数据为空！");
        }
        List<ProjectWbsEntity> saveOrUpldates = BeanMapper.mapList(importVOS, ProjectWbsEntity.class);
        service.saveOrUpdateBatch(saveOrUpldates, saveOrUpldates.size(), false);
        if (saveOrUpldates.size() > 0) {
            //维护父子级关系
            Map<String, Long> idMap = new HashMap<>();
            for (ProjectWbsEntity cdEntity : saveOrUpldates) {
                //存储虚拟id和真实id
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (ProjectWbsEntity cdEntity : saveOrUpldates) {
                if (StringUtils.isNotEmpty(cdEntity.getTpid())) {
                    //通过虚拟id父子关系存储真实导入id
                    if(idMap.get(cdEntity.getTpid())==null){
                        //tpid不为空且导入中不存在父子关系，查询已存在父id
                        LambdaQueryWrapper<ProjectWbsEntity> lambda = Wrappers.<ProjectWbsEntity>lambdaQuery();
                        lambda.eq(ProjectWbsEntity::getCode, cdEntity.getTpid());
                        ProjectWbsEntity projectWbsEntity = service.getOne(lambda);
                        if(projectWbsEntity!=null){
                            cdEntity.setParentId(projectWbsEntity.getId());
                        }
                    }else{
                        //导入父子关系替换父id
                        cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
                    }
                }
                cdEntity.setOrgId(InvocationInfoProxy.getOrgId());
            }
            //innercode
            for(ProjectWbsEntity projectWbsEntity : saveOrUpldates){
                if (projectWbsEntity.getParentId() != null && projectWbsEntity.getParentId() > 0) {
                    ProjectWbsEntity uniqueBean = baseMapper.selectById(projectWbsEntity.getParentId());
                    projectWbsEntity.setInnerCode(uniqueBean.getInnerCode() + "," + projectWbsEntity.getId());
                } else {
                    projectWbsEntity.setInnerCode(projectWbsEntity.getId().toString());
                }
                service.saveOrUpdate(projectWbsEntity);
            }
            service.saveOrUpdateBatch(saveOrUpldates, saveOrUpldates.size(), false);
        }
        return "保存成功！";
    }

    @Override
    public List<ProjectWbsEntity> getChildrenByPid(Long id) {
        ProjectWbsEntity parent = this.selectById(id);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("innerCode", new Parameter(QueryParam.LIKE_RIGHT, parent.getInnerCode()));
        List<ProjectWbsEntity> list = super.queryList(queryParam, false);
        return BeanMapper.mapList(list, ProjectWbsEntity.class);
    }
}
