package com.ejianc.foundation.share.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.foundation.share.bean.*;
import com.ejianc.foundation.share.service.IProsubCategoryService;
import com.ejianc.foundation.share.vo.ProsubItemImportVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.foundation.share.service.IProsubItemService;
import com.ejianc.foundation.share.vo.ProsubItemVO;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 专业分包档案
 *
 * @author generator
 */
@Controller
@RequestMapping("/prosubItem")
public class ProsubItemController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "PSI_CODE";
    @Autowired
    private IProsubItemService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IProsubCategoryService prosubCategoryService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ProsubItemVO> saveOrUpdate(@RequestBody ProsubItemVO saveorUpdateVO) {
        CommonResponse<ProsubItemVO> response = service.saveOrUpdateProsubItem(saveorUpdateVO);
        return response;
    }
    /**
     * 绑定科目
     *
     * @param map
     * @return
     */
    @RequestMapping(value = "/bandSubject", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> bandSubject(@RequestBody Map map) {
        List<Long> ids = (List<Long>) map.get("ids");
        Long subjectId = Long.valueOf(map.get("subjectId").toString());
        String subjectName = (String) map.get("subjectName");
        service.updateSubject(subjectId,subjectName,ids);
        return CommonResponse.success("绑定成功!");
    }
    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProsubItemVO> queryDetail(Long id) {
        ProsubItemEntity entity = service.selectById(id);
        ProsubItemVO vo = BeanMapper.map(entity, ProsubItemVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProsubItemVO> vos) {
        service.removeByIds(vos.stream().map(ProsubItemVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/pageList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ProsubItemVO>> pageList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();

        Map<String, Parameter> paramMap = param.getParams();
        paramMap.put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        if (paramMap.get("categoryId") != null) {
            Object categoryId = paramMap.get("categoryId").getValue();
            ProsubCategoryEntity categoryEntity = prosubCategoryService.selectById(categoryId.toString());
            if (categoryEntity != null) {
                paramMap.put("innerCode", new Parameter(QueryParam.LIKE_RIGHT, categoryEntity.getInnerCode()));
                paramMap.remove("categoryId");
            }
        }

        Page<ProsubItemVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(param);

        List<ProsubItemVO> list = service.queryProsubItemList(page, wrapper);
        IPage<ProsubItemVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(list, ProsubItemVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ProsubItemEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>(list.size());
        beans.put("records", list);
        ExcelExport.getInstance().export("prosub-import.xlsx", beans, response);
    }

    /**
     * @param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refProsubItemData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ProsubItemVO>> refProsubItemData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                 String condition,
                                                                 String searchObject,
                                                                 String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject con = JSONObject.parseObject(condition);
        }
        IPage<ProsubItemEntity> page = service.queryPage(param, false);
        IPage<ProsubItemVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProsubItemVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }


    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "prosub-import.xlsx", "专业分包导入模板");
    }


    /**
     * @Author mrsir_wxp
     * @Date 2020/6/29 专业分包详情导入excel校验
     * @Description excelProsubImport
     * @Param [request, response]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.alibaba.fastjson.JSONObject>
     */
    @RequestMapping(value = "/excelProsubImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelProsubImport(HttpServletRequest request) {
        CommonResponse<JSONObject> response = service.excelProsubImport(request);
        return response;
    }

    @RequestMapping(value = "/saveImportExcelProsubItem", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> saveImportExcelProsubItem(@RequestBody List<ProsubItemImportVO> importVos) {
        if (ListUtil.isEmpty(importVos)) {
            return CommonResponse.error("导入的数据为空！");
        }
        List<ProsubItemEntity> list = new ArrayList<>();
        importVos.forEach(importVO -> {
            ProsubItemEntity entity = BeanMapper.map(importVO, ProsubItemEntity.class);
            entity.setOrgId(sessionManager.getUserContext().getOrgId());
            entity.setOrgName(sessionManager.getUserContext().getOrgName());
            entity.setEnabled(0);
            list.add(entity);
        });
        service.saveBatch(list, list.size());
        return CommonResponse.success("保存成功！");
    }

    /**
     * @param saveorUpdateVO
     * @Description 修改专业分包档案状态
     * @Return void
     */
    @RequestMapping(value = "/changeState", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> changeState(@RequestBody ProsubItemVO saveorUpdateVO) {
        ProsubItemEntity entity = BeanMapper.map(saveorUpdateVO, ProsubItemEntity.class);
        LambdaUpdateWrapper<ProsubItemEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(ProsubItemEntity::getId, entity.getId());
        updateWrapper.set(ProsubItemEntity::getEnabled, entity.getEnabled());
        service.update(updateWrapper);
        return CommonResponse.success("更新成功！");
    }

    /**
     * 专业分包档案列表
     *
     * @param pageNumber
     * @param pageSize
     * @param relyCondition
     * @param searchText
     * @param condition
     * @return
     */
    @RequestMapping(value = "refProSubItemPage", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ProsubItemVO>> refProSubItemPage(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                 @RequestParam(required = false) String relyCondition,
                                                                 @RequestParam(required = false) String searchText,
                                                                 @RequestParam(required = false) String condition,
                                                                 @RequestParam(required = false) String searchObject) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.setFuzzyFields(Arrays.asList("trawlingCode", "trawlingName", "priceType", "unitName", "jobContent", "remarks"));
        /** 租户隔离 */
        if (StringUtils.isNotBlank(relyCondition)) {
            Long categoryId = Long.parseLong(relyCondition.split("=")[1]);
            ProsubCategoryEntity prosubCategoryEntity = prosubCategoryService.selectById(categoryId);
            if (prosubCategoryEntity != null) {
                String innerCode = prosubCategoryEntity.getInnerCode();
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("inner_code", new Parameter(QueryParam.LIKE, innerCode));
                List<ProsubCategoryEntity> prosubCategoryEntities = prosubCategoryService.queryList(queryParam);
                if (CollectionUtils.isNotEmpty(prosubCategoryEntities)) {
                    List<Long> ids = prosubCategoryEntities.stream().filter(s -> s.getId() != null).map(ProsubCategoryEntity::getId).collect(Collectors.toList());
                    param.getParams().put("category_id", new Parameter(QueryParam.IN, ids));
                }
            }
        }
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject con = JSONObject.parseObject(condition);
             if (con.containsKey("enabled")){
                 Integer enable = (Integer)con.get("enabled");
                 param.getParams().put("enabled", new Parameter(QueryParam.EQ, enable));
            }
        }

        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        IPage<ProsubItemEntity> page = service.queryPage(param, false);
        IPage<ProsubItemVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProsubItemVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }
}
