/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.share.bean.MaterialCategoryEntity;
import com.ejianc.foundation.share.mapper.MaterialCategoryMapper;
import com.ejianc.foundation.share.service.IMaterialCategoryService;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MaterialCategoryServiceImpl
implements IMaterialCategoryService {
    @Autowired
    private MaterialCategoryMapper materialCategoryMapper;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public List<MaterialCategoryEntity> queryList(QueryParam queryParam) {
        Map paramMap = queryParam.getParams();
        HashMap<String, Object> condition = new HashMap<String, Object>();
        for (Map.Entry entry : paramMap.entrySet()) {
            condition.put((String)entry.getKey(), ((Parameter)entry.getValue()).getValue());
        }
        condition.put("tenantId", InvocationInfoProxy.getTenantid());
        this.logger.info("tenantId:{}", (Object)InvocationInfoProxy.getTenantid());
        this.logger.info("condition:{}", JSONObject.toJSON(condition));
        List<MaterialCategoryEntity> resultList = this.materialCategoryMapper.queryList(condition);
        return resultList;
    }

    @Override
    public List<MaterialCategoryEntity> queryListYz() {
        List<MaterialCategoryEntity> resultList = this.materialCategoryMapper.queryListYz();
        return resultList;
    }

    @Override
    public MaterialCategoryVO queryDetail(Long id) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MaterialCategoryEntity entity = this.materialCategoryMapper.queryDetail(tenantId, id);
        if (entity != null) {
            return (MaterialCategoryVO)BeanMapper.map((Object)entity, MaterialCategoryVO.class);
        }
        return null;
    }

    @Override
    public void update(MaterialCategoryEntity entity) {
        this.materialCategoryMapper.update(entity);
    }

    @Override
    public void updateSubject(Long subjectId, String subjectName, List<Long> ids) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<MaterialCategoryEntity> materialCategoryEntities = this.materialCategoryMapper.queryByInnerCodes(tenantId, ids);
        ids.clear();
        materialCategoryEntities.forEach(item -> ids.add(item.getId()));
        this.materialCategoryMapper.updateSubject(tenantId, subjectId, subjectName, ids);
    }

    @Override
    public void save(MaterialCategoryEntity entity) {
        this.materialCategoryMapper.insert(entity);
    }

    @Override
    public void insertBatch(List<MaterialCategoryEntity> categoryEntityList) {
        if (ListUtil.isNotEmpty(categoryEntityList)) {
            ArrayList<MaterialCategoryEntity> toInsert = new ArrayList<MaterialCategoryEntity>();
            for (MaterialCategoryEntity entity : categoryEntityList) {
                if (toInsert.size() > 0 && toInsert.size() % 1000 == 0) {
                    this.materialCategoryMapper.insertBatch(InvocationInfoProxy.getTenantid(), toInsert);
                    toInsert = new ArrayList();
                }
                toInsert.add(entity);
            }
            if (toInsert.size() > 0) {
                this.materialCategoryMapper.insertBatch(InvocationInfoProxy.getTenantid(), toInsert);
            }
        }
    }

    @Override
    public List<MaterialCategoryVO> queryListByPid(Long id, String code) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<MaterialCategoryEntity> materialCategoryList = this.materialCategoryMapper.queryListByPid(tenantId, id, code);
        if (materialCategoryList != null && materialCategoryList.size() > 0) {
            return BeanMapper.mapList(materialCategoryList, MaterialCategoryVO.class);
        }
        return null;
    }

    @Override
    public void delete(Long id) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        this.materialCategoryMapper.delete(tenantId, id);
    }

    @Override
    public void updateEnabled(Integer enabled, Long tenantId, String innerCode) {
        this.materialCategoryMapper.updateEnabled(enabled, tenantId, innerCode);
    }

    @Override
    public List<MaterialCategoryEntity> queryByCode(String code) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        return this.materialCategoryMapper.queryByCode(tenantId, code);
    }

    @Override
    public List<MaterialCategoryEntity> queryByName(String name) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        return this.materialCategoryMapper.queryByName(tenantId, name);
    }

    @Override
    public void insertCategoryListFromPlatform() {
        Long tenantId = InvocationInfoProxy.getTenantid();
        this.materialCategoryMapper.insertCategoryListFromPlatform(tenantId);
    }

    @Override
    public List<MaterialCategoryVO> queryListTree(Map<String, Object> params) {
        List<MaterialCategoryEntity> materialCategoryList = this.materialCategoryMapper.queryListTree(params);
        if (materialCategoryList != null && materialCategoryList.size() > 0) {
            return BeanMapper.mapList(materialCategoryList, MaterialCategoryVO.class);
        }
        return null;
    }

    @Override
    public MaterialCategoryVO queryBySourceId(String sourceId) {
        MaterialCategoryEntity entity = this.materialCategoryMapper.queryBySourceId(sourceId, InvocationInfoProxy.getTenantid());
        if (entity != null && entity.getId() != null) {
            return (MaterialCategoryVO)BeanMapper.map((Object)entity, MaterialCategoryVO.class);
        }
        return null;
    }

    @Override
    public List<MaterialCategoryVO> queryListByInnerCode(Map<String, Object> params) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        params.put("tenantId", tenantId);
        List<MaterialCategoryEntity> materialCategoryList = this.materialCategoryMapper.queryListByInnerCode(params);
        if (materialCategoryList != null && materialCategoryList.size() > 0) {
            return BeanMapper.mapList(materialCategoryList, MaterialCategoryVO.class);
        }
        return null;
    }

    @Override
    public List<MaterialCategoryVO> queryCategoryListByChildren(List<Long> ids) {
        ArrayList<MaterialCategoryVO> result = new ArrayList<MaterialCategoryVO>();
        HashMap<String, Object> params = new HashMap<String, Object>();
        Long tenantId = InvocationInfoProxy.getTenantid();
        params.put("tenantId", tenantId);
        List<MaterialCategoryEntity> materialCategoryList = this.materialCategoryMapper.queryListTree(params);
        if (materialCategoryList != null && materialCategoryList.size() > 0) {
            HashSet<Long> keySet = new HashSet<Long>();
            List materialCategoryVOS = BeanMapper.mapList(materialCategoryList, MaterialCategoryVO.class);
            Map categoryVOMap = materialCategoryVOS.stream().collect(Collectors.toMap(MaterialCategoryVO::getId, Function.identity(), (key1, key2) -> key2));
            for (Long id : ids) {
                String[] keyArray;
                if (!categoryVOMap.containsKey(id)) continue;
                MaterialCategoryVO categoryVO = (MaterialCategoryVO)categoryVOMap.get(id);
                String innerCode = categoryVO.getInnerCode();
                for (String keyStr : keyArray = innerCode.split("\\|")) {
                    Long key = Long.valueOf(keyStr);
                    if (keySet.contains(key)) continue;
                    keySet.add(key);
                    result.add((MaterialCategoryVO)categoryVOMap.get(key));
                }
            }
        }
        return result;
    }
}

