/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.bean.LabsubCategoryEntity;
import com.ejianc.foundation.share.mapper.LabsubCategoryMapper;
import com.ejianc.foundation.share.service.ILabsubCategoryService;
import com.ejianc.foundation.share.service.ILabsubItemService;
import com.ejianc.foundation.share.vo.LabsubCategoryImportVO;
import com.ejianc.foundation.share.vo.LabsubCategoryVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="labsubCategoryService")
public class LabsubCategoryServiceImpl
extends BaseServiceImpl<LabsubCategoryMapper, LabsubCategoryEntity>
implements ILabsubCategoryService {
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "LSC_CODE";
    @Autowired
    private ILabsubCategoryService service;
    @Autowired
    private ILabsubItemService labsubItemService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private LabsubCategoryMapper labsubCategoryMapper;

    @Override
    public CommonResponse<LabsubCategoryVO> saveOrUpdateLabsubCategory(LabsubCategoryVO saveorUpdateVO) {
        CommonResponse billCode;
        LabsubCategoryEntity entity = (LabsubCategoryEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, LabsubCategoryEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        } else {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)saveorUpdateVO.getId());
            updateWrapper.set(LabsubCategoryEntity::getCategoryName, (Object)saveorUpdateVO.getCategoryName());
            updateWrapper.set(LabsubCategoryEntity::getOrgId, (Object)this.sessionManager.getUserContext().getOrgId());
            updateWrapper.set(LabsubCategoryEntity::getOrgName, (Object)this.sessionManager.getUserContext().getOrgName());
            updateWrapper.set(LabsubCategoryEntity::getRemarks, (Object)saveorUpdateVO.getRemarks());
            this.service.update((Wrapper)updateWrapper);
            return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01");
        }
        entity.setCategoryCode((String)billCode.getData());
        entity.setOrgId(this.sessionManager.getUserContext().getOrgId());
        entity.setOrgName(this.sessionManager.getUserContext().getOrgName());
        entity.setId(IdWorker.getId());
        if (entity.getParentId() != null && entity.getParentId() > 0L) {
            LabsubCategoryEntity labsubCategoryEntity = (LabsubCategoryEntity)((Object)this.service.selectById(entity.getParentId()));
            entity.setInnerCode(labsubCategoryEntity.getInnerCode() + "|" + entity.getId());
        } else {
            entity.setInnerCode(entity.getId().toString());
        }
        this.service.save((Object)entity);
        LabsubCategoryVO vo = (LabsubCategoryVO)BeanMapper.map((Object)((Object)entity), LabsubCategoryVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @Override
    public List<LabsubCategoryVO> queryLabsubCategoryList(QueryParam queryParam) {
        Map paramMap = queryParam.getParams();
        HashMap<String, Object> condition = new HashMap<String, Object>();
        for (Map.Entry entry : paramMap.entrySet()) {
            condition.put((String)entry.getKey(), ((Parameter)entry.getValue()).getValue());
        }
        condition.put("tenantId", InvocationInfoProxy.getTenantid());
        List<LabsubCategoryVO> resultList = ((LabsubCategoryMapper)this.baseMapper).queryLabsubCategoryList(condition);
        return resultList;
    }

    @Override
    public CommonResponse<String> deleteById(List<LabsubCategoryVO> vos) {
        List collect = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("category_id", new Parameter("in", collect));
        List prosubItemEntities = this.labsubItemService.queryList(queryParam);
        if (CollectionUtils.isNotEmpty((Collection)prosubItemEntities)) {
            return CommonResponse.error((String)"\u5206\u7c7b\u4e0b\u5173\u8054\u4e13\u4e1a\u5206\u5305\u6863\u6848\uff01");
        }
        QueryParam queryClassifyParam = new QueryParam();
        queryClassifyParam.getParams().put("parent_id", new Parameter("in", collect));
        List prosubItems = this.service.queryList(queryClassifyParam);
        if (CollectionUtils.isNotEmpty((Collection)prosubItems)) {
            return CommonResponse.error((String)"\u5206\u7c7b\u4e0b\u5173\u8054\u5b50\u5206\u7c7b\u4e0d\u5141\u8bb8\u5220\u9664\uff01");
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        ArrayList successList = new ArrayList();
        ArrayList<LabsubCategoryImportVO> processList = new ArrayList<LabsubCategoryImportVO>();
        ArrayList<LabsubCategoryImportVO> errorList = new ArrayList<LabsubCategoryImportVO>();
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            if (result.size() > 10000) {
                return CommonResponse.error((String)"\u5206\u7c7b\u6570\u636e\u8d85\u8fc710000\u6761\uff0c\u8bf7\u5206\u6279\u4e0a\u4f20\uff01");
            }
            HashMap<String, ArrayList<LabsubCategoryImportVO>> mapChildren = new HashMap<String, ArrayList<LabsubCategoryImportVO>>();
            HashMap<String, LabsubCategoryImportVO> codeToData = new HashMap<String, LabsubCategoryImportVO>();
            HashMap codeNotExistData = new HashMap();
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                LabsubCategoryImportVO LabsubsubCategoryImportVO = new LabsubCategoryImportVO();
                LabsubsubCategoryImportVO.setId(IdWorker.getId());
                LabsubsubCategoryImportVO.setCategoryCode((String)datas.get(0));
                LabsubsubCategoryImportVO.setParentCode((String)datas.get(1));
                LabsubsubCategoryImportVO.setCategoryName((String)datas.get(2));
                LabsubsubCategoryImportVO.setRemarks((String)datas.get(3));
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(0)))) {
                    LabsubsubCategoryImportVO.setRemarks("\u5206\u7c7b\u7f16\u7801\u4e3a\u7a7a\uff01");
                    errorList.add(LabsubsubCategoryImportVO);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(2)))) {
                    LabsubsubCategoryImportVO.setRemarks("\u5206\u7c7b\u540d\u79f0\u4e3a\u7a7a\uff01");
                    errorList.add(LabsubsubCategoryImportVO);
                    continue;
                }
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("categoryCode", new Parameter("eq", (Object)String.valueOf(datas.get(0))));
                List list = this.service.queryList(queryParam, false);
                if (ListUtil.isEmpty((List)list)) {
                    List<LabsubCategoryImportVO> list1;
                    queryParam = new QueryParam();
                    queryParam.getParams().put("categoryName", new Parameter("eq", (Object)String.valueOf(datas.get(2))));
                    list = this.service.queryList(queryParam, false);
                    if (ListUtil.isNotEmpty((List)list)) {
                        LabsubsubCategoryImportVO.setRemarks("\u5206\u7c7b\u540d\u79f0\u91cd\u590d\uff01");
                        errorList.add(LabsubsubCategoryImportVO);
                        continue;
                    }
                    if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(1)))) {
                        LabsubsubCategoryImportVO.setInnerCode(LabsubsubCategoryImportVO.getId().toString());
                    }
                    LabsubsubCategoryImportVO.setCreateUserCode(InvocationInfoProxy.getUsercode());
                    LabsubsubCategoryImportVO.setCreateTime(new Date());
                    LabsubsubCategoryImportVO.setTenantId(InvocationInfoProxy.getTenantid());
                    processList.add(LabsubsubCategoryImportVO);
                    codeToData.put(LabsubsubCategoryImportVO.getCategoryCode(), LabsubsubCategoryImportVO);
                    if (StringUtils.isBlank((CharSequence)LabsubsubCategoryImportVO.getParentCode())) {
                        list1 = (ArrayList<LabsubCategoryImportVO>)mapChildren.get("null");
                        if (ListUtil.isEmpty((List)list1)) {
                            list1 = new ArrayList<LabsubCategoryImportVO>();
                            mapChildren.put("null", (ArrayList<LabsubCategoryImportVO>)list1);
                        }
                        list1.add(LabsubsubCategoryImportVO);
                        continue;
                    }
                    list1 = (List)mapChildren.get(LabsubsubCategoryImportVO.getParentCode());
                    if (ListUtil.isEmpty((List)list1)) {
                        list1 = new ArrayList();
                        mapChildren.put(LabsubsubCategoryImportVO.getParentCode(), (ArrayList<LabsubCategoryImportVO>)list1);
                    }
                    list1.add(LabsubsubCategoryImportVO);
                    continue;
                }
                LabsubsubCategoryImportVO.setRemarks("\u5206\u7c7b\u7f16\u7801\u91cd\u590d\uff01");
                errorList.add(LabsubsubCategoryImportVO);
            }
            if (ListUtil.isNotEmpty(processList)) {
                processList.forEach(p -> {
                    if (StringUtils.isNotEmpty((CharSequence)p.getParentCode())) {
                        LabsubCategoryImportVO parentVo = (LabsubCategoryImportVO)codeToData.get(p.getParentCode());
                        if (parentVo == null) {
                            if (StringUtils.isNotEmpty((CharSequence)((CharSequence)codeNotExistData.get(p.getParentCode())))) {
                                p.setRemarks("\u7236\u5206\u7c7b\u7f16\u7801\u4e0d\u5b58\u5728");
                                errorList.add((LabsubCategoryImportVO)p);
                            } else {
                                QueryParam queryParam = new QueryParam();
                                queryParam.getParams().put("categoryCode", new Parameter("eq", (Object)p.getParentCode()));
                                List list = this.service.queryList(queryParam, false);
                                if (ListUtil.isEmpty((List)list)) {
                                    codeNotExistData.put(p.getParentCode(), p.getParentCode());
                                    p.setRemarks("\u7236\u5206\u7c7b\u7f16\u7801\u4e0d\u5b58\u5728");
                                    errorList.add((LabsubCategoryImportVO)p);
                                } else {
                                    p.setInnerCode(((LabsubCategoryEntity)((Object)((Object)list.get(0)))).getInnerCode() + "|" + p.getId());
                                    p.setParentId(((LabsubCategoryEntity)((Object)((Object)list.get(0)))).getId());
                                    successList.add(p);
                                }
                            }
                        } else if (StringUtils.isEmpty((CharSequence)parentVo.getInnerCode())) {
                            this.setInnerCodeAndParentId(parentVo, codeToData, codeNotExistData);
                            if (StringUtils.isEmpty((CharSequence)parentVo.getInnerCode())) {
                                p.setRemarks("\u7236\u5206\u7c7b\u7f16\u7801\u4e0d\u5b58\u5728");
                                errorList.add((LabsubCategoryImportVO)p);
                            } else {
                                p.setInnerCode(parentVo.getInnerCode() + "|" + p.getId());
                                p.setParentId(parentVo.getId());
                                successList.add(p);
                            }
                        } else {
                            p.setInnerCode(parentVo.getInnerCode() + "|" + p.getId());
                            p.setParentId(parentVo.getId());
                            successList.add(p);
                        }
                    } else {
                        successList.add(p);
                    }
                });
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }

    @Override
    public void updateSubject(Long subjectId, String subjectName, List<Long> ids) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<LabsubCategoryEntity> labsubCategoryEntities = this.labsubCategoryMapper.queryByInnerCodes(tenantId, ids);
        ids.clear();
        labsubCategoryEntities.forEach(item -> ids.add(item.getId()));
        this.labsubCategoryMapper.updateSubject(tenantId, subjectId, subjectName, ids);
    }

    private void setInnerCodeAndParentId(LabsubCategoryImportVO vo, Map<String, LabsubCategoryImportVO> codeToData, Map<String, String> codeNotExistData) {
        LabsubCategoryImportVO parentVo = codeToData.get(vo.getParentCode());
        if (parentVo == null) {
            if (StringUtils.isNotEmpty((CharSequence)codeNotExistData.get(vo.getParentCode()))) {
                vo.setRemarks("\u7236\u5206\u7c7b\u7f16\u7801\u4e0d\u5b58\u5728");
            } else {
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("categoryCode", new Parameter("eq", (Object)vo.getParentCode()));
                List list = this.service.queryList(queryParam, false);
                if (ListUtil.isEmpty((List)list)) {
                    codeNotExistData.put(vo.getParentCode(), vo.getParentCode());
                    vo.setRemarks("\u7236\u5206\u7c7b\u7f16\u7801\u4e0d\u5b58\u5728");
                } else {
                    vo.setInnerCode(((LabsubCategoryEntity)((Object)list.get(0))).getInnerCode() + "|" + vo.getId());
                    vo.setParentId(((LabsubCategoryEntity)((Object)list.get(0))).getId());
                }
            }
        } else if (StringUtils.isEmpty((CharSequence)parentVo.getInnerCode())) {
            this.setInnerCodeAndParentId(parentVo, codeToData, codeNotExistData);
            if (StringUtils.isEmpty((CharSequence)parentVo.getInnerCode())) {
                vo.setRemarks("\u7236\u5206\u7c7b\u7f16\u7801\u4e0d\u5b58\u5728");
            } else {
                vo.setInnerCode(parentVo.getInnerCode() + "|" + vo.getId());
                vo.setParentId(parentVo.getId());
            }
        } else {
            vo.setInnerCode(parentVo.getInnerCode() + "|" + vo.getId());
            vo.setParentId(parentVo.getId());
        }
    }
}

