package com.ejianc.foundation.share.service.impl;

import java.util.*;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.kit.collection.ListUtil;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.foundation.share.bean.MaterialCategoryEntity;
import com.ejianc.foundation.share.bean.MaterialEntity;
import com.ejianc.foundation.share.mapper.MaterialCategoryMapper;
import com.ejianc.foundation.share.service.IMaterialCategoryService;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

@Service
public class MaterialCategoryServiceImpl implements IMaterialCategoryService {

	@Autowired
	private MaterialCategoryMapper materialCategoryMapper;
	private org.slf4j.Logger logger = LoggerFactory.getLogger(this.getClass());


	@Override
	public List<MaterialCategoryEntity> queryList(QueryParam queryParam) {
		Map<String, Parameter> paramMap = queryParam.getParams();

		Map<String,Object> condition = new HashMap<String, Object>();
		for(Map.Entry<String, Parameter> entry:paramMap.entrySet()) {
			condition.put(entry.getKey(), entry.getValue().getValue());
		}
		//放入租户ID进map
		condition.put("tenantId", InvocationInfoProxy.getTenantid());
		logger.info("tenantId:{}",InvocationInfoProxy.getTenantid());
		logger.info("condition:{}",JSONObject.toJSON(condition));

		List<MaterialCategoryEntity> resultList = materialCategoryMapper.queryList(condition);
		return resultList;
	}
	@Override
	public List<MaterialCategoryEntity> queryListYz() {


		List<MaterialCategoryEntity> resultList = materialCategoryMapper.queryListYz();
		return resultList;
	}
	@Override
	public List<MaterialCategoryEntity> syncRemoveCategoryData() {


		List<MaterialCategoryEntity> resultList = materialCategoryMapper.syncRemoveCategoryData();
		return resultList;
	}

	@Override
	public MaterialCategoryVO queryDetail(Long id) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		MaterialCategoryEntity entity = materialCategoryMapper.queryDetail(tenantId, id);
		if(entity != null) {
			return BeanMapper.map(entity, MaterialCategoryVO.class);
		}
		return null;
	}

	@Override
	public void update(MaterialCategoryEntity entity) {
		materialCategoryMapper.update(entity);
	}

	@Override
	public void updateSubject(Long subjectId, String subjectName, List<Long> ids) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		List<MaterialCategoryEntity> materialCategoryEntities = materialCategoryMapper.queryByInnerCodes(tenantId, ids);
		ids.clear();
		materialCategoryEntities.forEach(item->{
			ids.add(item.getId());
		});
		materialCategoryMapper.updateSubject(tenantId,subjectId,subjectName,ids);
	}

	@Override
	public void save(MaterialCategoryEntity entity) {
		materialCategoryMapper.insert(entity);
	}

	/**
	 * 批量新增
	 *
	 * @param categoryEntityList
	 */
	@Override
	public void insertBatch(List<MaterialCategoryEntity> categoryEntityList) {
		if(ListUtil.isNotEmpty(categoryEntityList)){
			List<MaterialCategoryEntity> toInsert = new ArrayList<>();
			for (MaterialCategoryEntity entity : categoryEntityList){
				if (toInsert.size()>0 && toInsert.size() % 1000 == 0) {
					materialCategoryMapper.insertBatch(InvocationInfoProxy.getTenantid(),toInsert);
					toInsert = new ArrayList<>();
				}
				toInsert.add(entity);
			}
			if(toInsert.size()>0){
				materialCategoryMapper.insertBatch(InvocationInfoProxy.getTenantid(),toInsert);
			}
		}
	}

	@Override
	public List<MaterialCategoryVO> queryListByPid(Long id, String code) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		List<MaterialCategoryEntity> materialCategoryList = materialCategoryMapper.queryListByPid(tenantId, id, code);
		if(materialCategoryList != null && materialCategoryList.size() > 0) {
			return BeanMapper.mapList(materialCategoryList, MaterialCategoryVO.class);
		}
		return null;
	}

	@Override
	public void delete(Long id) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		materialCategoryMapper.delete(tenantId,id);
	}

	@Override
	public void updateEnabled(Integer enabled, Long tenantId, String innerCode) {
		materialCategoryMapper.updateEnabled(enabled,tenantId,innerCode);
	}

	@Override
	public List<MaterialCategoryEntity> queryByCode(String code) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		return materialCategoryMapper.queryByCode(tenantId, code);
	}

	@Override
	public List<MaterialCategoryEntity> queryByName(String name) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		return materialCategoryMapper.queryByName(tenantId, name);
	}

	@Override
	public void insertCategoryListFromPlatform() {
		Long tenantId = InvocationInfoProxy.getTenantid();
		materialCategoryMapper.insertCategoryListFromPlatform(tenantId);
	}

	@Override
	public List<MaterialCategoryVO> queryListTree(Map<String, Object> params) {
		List<MaterialCategoryEntity> materialCategoryList = materialCategoryMapper.queryListTree(params);
		if(materialCategoryList != null && materialCategoryList.size() > 0) {
			return BeanMapper.mapList(materialCategoryList, MaterialCategoryVO.class);
		}
		return null;
	}

	@Override
	public MaterialCategoryVO queryBySourceId(String sourceId) {
		MaterialCategoryEntity entity = materialCategoryMapper.queryBySourceId(sourceId,InvocationInfoProxy.getTenantid());
		if(entity!=null&&entity.getId()!=null){
			return BeanMapper.map(entity, MaterialCategoryVO.class);
		}
		return null;
	}

	@Override
	public List<MaterialCategoryVO> queryListByInnerCode(Map<String, Object> params) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		params.put("tenantId", tenantId);
		List<MaterialCategoryEntity> materialCategoryList = materialCategoryMapper.queryListByInnerCode(params);
		if(materialCategoryList != null && materialCategoryList.size() > 0) {
			return BeanMapper.mapList(materialCategoryList, MaterialCategoryVO.class);
		}
		return null;
	}

	@Override
	public List<MaterialCategoryVO> queryCategoryListByChildren(List<Long> ids) {
		List<MaterialCategoryVO> result = new ArrayList<>();
		Map<String, Object> params = new HashMap<>();
		Long tenantId = InvocationInfoProxy.getTenantid();
		params.put("tenantId", tenantId);
		List<MaterialCategoryEntity> materialCategoryList = materialCategoryMapper.queryListTree(params);
		if(materialCategoryList != null && materialCategoryList.size() > 0) {
			Set<Long> keySet = new HashSet<>();
			List<MaterialCategoryVO> materialCategoryVOS =  BeanMapper.mapList(materialCategoryList, MaterialCategoryVO.class);
			Map<Long, MaterialCategoryVO> categoryVOMap = materialCategoryVOS.stream().collect(Collectors.toMap(MaterialCategoryVO::getId, Function.identity(), (key1, key2) -> key2));
			for(Long id : ids){
				if(categoryVOMap.containsKey(id)){
					MaterialCategoryVO categoryVO = categoryVOMap.get(id);
					String innerCode = categoryVO.getInnerCode();
					String[] keyArray = innerCode.split("\\|");
					for(String keyStr : keyArray){
						Long key = Long.valueOf(keyStr);
						if(!keySet.contains(key)){
							keySet.add(key);
							result.add(categoryVOMap.get(key));
						}
					}
				}
			}
		}
		return result;
	}

}
