/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.share.bean.EquipmentCategoryEntity;
import com.ejianc.foundation.share.service.IEquipmentCategoryService;
import com.ejianc.foundation.share.service.IEquipmentService;
import com.ejianc.foundation.share.vo.EquipmentCategoryVO;
import com.ejianc.foundation.share.vo.EquipmentVO;
import com.ejianc.foundation.share.vo.MaterialCategoryImportVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.util.DataToYzwUtil;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/equipment/category/"})
public class EquipmentCategoryController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String EQUIPMENT_CATEGORY_BILL_CODE = "SUPPORT_EQUIPMENT_CATEGORY";
    @Value(value="${oms.tenantid}")
    private String OMS_TENANT;
    @Autowired
    private IEquipmentCategoryService equipmentCategoryService;
    @Autowired
    private IEquipmentService equipmentService;
    @Autowired
    private IBillCodeApi billCodeApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${yzwSignUrl}")
    private String yzwSignUrl;
    @Value(value="${yzwUrl1}")
    private String yzwUrl1;
    @Value(value="${yzwVersion}")
    private String yzwVersion;
    @Value(value="${yzwAppKey1}")
    private String yzwAppKey1;
    @Value(value="${yzwAppSecret1}")
    private String yzwAppSecret1;
    @Value(value="${yzwUrl2}")
    private String yzwUrl2;
    @Value(value="${yzwAppKey2}")
    private String yzwAppKey2;
    @Value(value="${yzwAppSecret2}")
    private String yzwAppSecret2;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveOrUpdate(@RequestBody EquipmentCategoryVO equipmentCategoryVo) throws Exception {
        Long tenantId = InvocationInfoProxy.getTenantid();
        CommonResponse codeBatchByRuleCode = this.billCodeApi.getCodeBatchByRuleCode(EQUIPMENT_CATEGORY_BILL_CODE, tenantId);
        if (codeBatchByRuleCode.isSuccess()) {
            equipmentCategoryVo.setCode((String)codeBatchByRuleCode.getData());
        }
        JSONObject param = new JSONObject();
        param.put("categoryCode", (Object)equipmentCategoryVo.getCode());
        param.put("categoryName", (Object)equipmentCategoryVo.getName());
        if (equipmentCategoryVo.getParentId() != null) {
            EquipmentCategoryVO equipmentCategoryVO = this.equipmentCategoryService.queryDetail(equipmentCategoryVo.getParentId());
            param.put("parentCategoryCode", (Object)equipmentCategoryVO.getCode());
        }
        param.put("sourceSystem", (Object)1800);
        param.put("status", (Object)1);
        JSONObject result = new JSONObject();
        String method = null;
        method = equipmentCategoryVo.getId() != null ? "ymc.co.material.category.update" : "ymc.co.material.category.push";
        this.logger.info("\u53c2\u6570\uff1a{}", (Object)param.toJSONString());
        String response = DataToYzwUtil.queryByYzw(param, this.yzwUrl2, method, this.yzwVersion, this.yzwAppKey2, this.yzwAppSecret2);
        this.logger.info("\u8bbe\u5907\u5206\u7c7b\u65b0\u589eor\u4fee\u6539\u63a8\u9001\u8fd4\u56de\u63a5\u53e3:{}", (Object)response);
        JSONObject respone = JSONObject.parseObject((String)response);
        boolean success = respone.getBoolean("success");
        if (!success) {
            equipmentCategoryVo.setPushStatus(Integer.valueOf(0));
            this.logger.info(respone.toJSONString());
            throw new BusinessException(respone.toJSONString());
        }
        equipmentCategoryVo.setPushStatus(Integer.valueOf(1));
        if (equipmentCategoryVo.getId() != null && equipmentCategoryVo.getId() > 0L) {
            EquipmentCategoryVO uniqueBean = this.equipmentCategoryService.queryDetail(equipmentCategoryVo.getId());
            uniqueBean.setName(equipmentCategoryVo.getName());
            uniqueBean.setDescription(equipmentCategoryVo.getDescription());
            uniqueBean.setSequence(equipmentCategoryVo.getSequence());
            uniqueBean.setUpdateUserCode(InvocationInfoProxy.getUsercode());
            uniqueBean.setUpdateTime(equipmentCategoryVo.getUpdateTime());
            uniqueBean.setPushStatus(equipmentCategoryVo.getPushStatus());
            EquipmentCategoryEntity entity = (EquipmentCategoryEntity)BeanMapper.map((Object)uniqueBean, EquipmentCategoryEntity.class);
            this.equipmentCategoryService.update(entity);
        } else {
            EquipmentCategoryEntity entity = (EquipmentCategoryEntity)BeanMapper.map((Object)equipmentCategoryVo, EquipmentCategoryEntity.class);
            entity.setId(IdWorker.getId());
            if (entity.getParentId() != null && entity.getParentId() > 0L) {
                EquipmentCategoryVO uniqueBean = this.equipmentCategoryService.queryDetail(entity.getParentId());
                entity.setInnerCode(uniqueBean.getInnerCode() + "|" + entity.getId());
            } else {
                entity.setInnerCode(entity.getId().toString());
            }
            entity.setEnabled(1);
            entity.setCreateUserCode(InvocationInfoProxy.getUsercode());
            entity.setCreateTime(new Date());
            entity.setTenantId(InvocationInfoProxy.getTenantid());
            this.equipmentCategoryService.save(entity);
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u6210\u529f");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam queryParam) {
        List<EquipmentCategoryEntity> dataList = this.equipmentCategoryService.queryList(queryParam);
        List resultMapList = BeanMapper.mapList(dataList, Map.class);
        resultMapList.forEach(l -> {
            if (l.get("leaf").equals(false)) {
                l.put("children", new ArrayList());
            }
        });
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", (Object)ResultAsTree.createTreeData((List)resultMapList));
        return CommonResponse.success((Object)jsonObject);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<EquipmentCategoryVO> queryDetail(@RequestParam Long id) {
        EquipmentCategoryVO equipmentCategoryVo = this.equipmentCategoryService.queryDetail(id);
        return CommonResponse.success((Object)equipmentCategoryVo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> delete(@RequestParam Long id) {
        List<EquipmentCategoryVO> children = this.equipmentCategoryService.queryListByPid(id);
        if (children != null && children.size() > 0) {
            return CommonResponse.error((String)"\u8be5\u5206\u7c7b\u4e0b\u6709\u5b50\u5206\u7c7b\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        List<EquipmentVO> equipmentList = this.equipmentService.queryListByCategoryId(id);
        if (equipmentList != null && equipmentList.size() > 0) {
            return CommonResponse.error((String)"\u8be5\u5206\u7c7b\u4e0b\u6709\u8bbe\u5907\u4e86\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        EquipmentCategoryVO entity = this.equipmentCategoryService.queryDetail(id);
        this.equipmentCategoryService.delete(id);
        JSONObject param = new JSONObject();
        param.put("categoryCode", (Object)entity.getCode());
        param.put("categoryName", (Object)entity.getName());
        param.put("categoryName", (Object)entity.getName());
        param.put("isDelete", (Object)true);
        param.put("sourceSystem", (Object)1800);
        param.put("status", (Object)1);
        JSONObject result = new JSONObject();
        String method = "ymc.co.material.category.update";
        try {
            this.logger.info("\u53c2\u6570\uff1a{}", (Object)param.toJSONString());
            String response = DataToYzwUtil.queryByYzw(param, this.yzwUrl2, method, this.yzwVersion, this.yzwAppKey2, this.yzwAppSecret2);
            this.logger.info("\u7269\u8d44\u5206\u7c7b\u5220\u9664\u63a8\u9001\u8fd4\u56de\u63a5\u53e3:{}", (Object)response);
            JSONObject respone = JSONObject.parseObject((String)response);
            if (0 != (Integer)respone.get((Object)"Code") || null == respone.getJSONObject("Data").getJSONArray("Rows")) {
                this.logger.info(respone.toJSONString());
            }
        }
        catch (Exception e) {
            this.logger.info(e.getMessage());
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/enabled/update"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> updateEnabled(@RequestBody EquipmentCategoryVO equipmentCategoryVo) {
        EquipmentCategoryVO condition = this.equipmentCategoryService.queryDetail(equipmentCategoryVo.getId());
        this.equipmentCategoryService.updateEnabled(equipmentCategoryVo.getEnabled(), condition.getTenantId(), condition.getInnerCode());
        return CommonResponse.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @RequestMapping(value={"/sync"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> syncEquipmentCategoryList() {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (this.OMS_TENANT.equals(tenantId.toString())) {
            return CommonResponse.error((String)"\u5e73\u53f0\u8fd0\u8425\u4eba\u5458\u4e0d\u80fd\u64cd\u4f5c\u6b64\u529f\u80fd");
        }
        this.equipmentCategoryService.insertCategoryListFromPlatform();
        return CommonResponse.success((String)"\u540c\u6b65\u6210\u529f");
    }

    @RequestMapping(value={"/queryEquipmentRefTree"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> queryEquipmentRefTree(@RequestParam(required=false) String searchText) {
        List<EquipmentCategoryVO> dataList = null;
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            if (StringUtils.isNotBlank((CharSequence)searchText)) {
                params.put("searchText", searchText);
            }
            params.put("tenantId", InvocationInfoProxy.getTenantid());
            dataList = this.equipmentCategoryService.queryListTree(params);
            List map = BeanMapper.mapList(dataList, Map.class);
            return ResultAsTree.createTreeData((List)map);
        }
        catch (Exception e) {
            return null;
        }
    }

    @RequestMapping(value={"/lazyEquipmentCategoryTree"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> lazyEquipmentCategoryTree(@RequestParam(required=false) String condition, @RequestParam(required=false) Long pid, @RequestParam(required=false) String searchText) {
        List<EquipmentCategoryVO> dataList = null;
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            if (StringUtils.isNotBlank((CharSequence)searchText)) {
                params.put("searchText", searchText);
                params.put("tenantId", InvocationInfoProxy.getTenantid());
                dataList = this.equipmentCategoryService.queryListTree(params);
            } else {
                dataList = this.equipmentCategoryService.queryListByPid(pid);
            }
            List map = BeanMapper.mapList(dataList, Map.class);
            return ResultAsTree.createTreeData((List)map);
        }
        catch (Exception e) {
            return null;
        }
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"material-category-import.xlsx", (String)"\u8bbe\u5907\u5206\u7c7b\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        ArrayList successList = new ArrayList();
        ArrayList<MaterialCategoryImportVO> processList = new ArrayList<MaterialCategoryImportVO>();
        ArrayList<MaterialCategoryImportVO> errorList = new ArrayList<MaterialCategoryImportVO>();
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            if (result.size() > 10000) {
                return CommonResponse.error((String)"\u5206\u7c7b\u6570\u636e\u8d85\u8fc710000\u6761\uff0c\u8bf7\u5206\u6279\u4e0a\u4f20\uff01");
            }
            HashMap<String, ArrayList<MaterialCategoryImportVO>> mapChildren = new HashMap<String, ArrayList<MaterialCategoryImportVO>>();
            HashMap<String, MaterialCategoryImportVO> codeToData = new HashMap<String, MaterialCategoryImportVO>();
            HashMap codeNotExistData = new HashMap();
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                MaterialCategoryImportVO materialVo = new MaterialCategoryImportVO();
                materialVo.setId(IdWorker.getId());
                materialVo.setCode((String)datas.get(0));
                materialVo.setParentCode((String)datas.get(1));
                materialVo.setName((String)datas.get(2));
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(0)))) {
                    materialVo.setDescription("\u5206\u7c7b\u7f16\u7801\u4e3a\u7a7a\uff01");
                    errorList.add(materialVo);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(2)))) {
                    materialVo.setDescription("\u5206\u7c7b\u540d\u79f0\u4e3a\u7a7a\uff01");
                    errorList.add(materialVo);
                    continue;
                }
                List<EquipmentCategoryEntity> list = this.equipmentCategoryService.queryByCode(String.valueOf(datas.get(0)));
                if (ListUtil.isEmpty(list)) {
                    List<MaterialCategoryImportVO> list1;
                    list = this.equipmentCategoryService.queryByName(String.valueOf(datas.get(2)));
                    if (ListUtil.isNotEmpty(list)) {
                        materialVo.setDescription("\u5206\u7c7b\u540d\u79f0\u91cd\u590d\uff01");
                        errorList.add(materialVo);
                        continue;
                    }
                    if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(1)))) {
                        materialVo.setInnerCode(materialVo.getId().toString());
                    }
                    materialVo.setEnabled(1);
                    materialVo.setCreateUserCode(InvocationInfoProxy.getUsercode());
                    materialVo.setCreateTime(new Date());
                    materialVo.setTenantId(InvocationInfoProxy.getTenantid());
                    processList.add(materialVo);
                    codeToData.put(materialVo.getCode(), materialVo);
                    if (StringUtils.isBlank((CharSequence)materialVo.getParentCode())) {
                        list1 = (ArrayList<MaterialCategoryImportVO>)mapChildren.get("null");
                        if (ListUtil.isEmpty((List)list1)) {
                            list1 = new ArrayList<MaterialCategoryImportVO>();
                            mapChildren.put("null", (ArrayList<MaterialCategoryImportVO>)list1);
                        }
                        list1.add(materialVo);
                        continue;
                    }
                    list1 = (List)mapChildren.get(materialVo.getParentCode());
                    if (ListUtil.isEmpty((List)list1)) {
                        list1 = new ArrayList();
                        mapChildren.put(materialVo.getParentCode(), (ArrayList<MaterialCategoryImportVO>)list1);
                    }
                    list1.add(materialVo);
                    continue;
                }
                materialVo.setDescription("\u5206\u7c7b\u7f16\u7801\u91cd\u590d\uff01");
                errorList.add(materialVo);
            }
            if (ListUtil.isNotEmpty(processList)) {
                processList.forEach(p -> {
                    if (StringUtils.isNotEmpty((CharSequence)p.getParentCode())) {
                        MaterialCategoryImportVO parentVo = (MaterialCategoryImportVO)codeToData.get(p.getParentCode());
                        if (parentVo == null) {
                            if (StringUtils.isNotEmpty((CharSequence)((CharSequence)codeNotExistData.get(p.getParentCode())))) {
                                p.setDescription("\u7236\u5206\u7c7b\u7f16\u7801\u4e0d\u5b58\u5728");
                                errorList.add((MaterialCategoryImportVO)p);
                            } else {
                                List<EquipmentCategoryEntity> list = this.equipmentCategoryService.queryByCode(p.getParentCode());
                                if (ListUtil.isEmpty(list)) {
                                    codeNotExistData.put(p.getParentCode(), p.getParentCode());
                                    p.setDescription("\u7236\u5206\u7c7b\u7f16\u7801\u4e0d\u5b58\u5728");
                                    errorList.add((MaterialCategoryImportVO)p);
                                } else {
                                    p.setInnerCode(list.get(0).getInnerCode() + "|" + p.getId());
                                    p.setParentId(list.get(0).getId());
                                }
                            }
                        } else if (StringUtils.isEmpty((CharSequence)parentVo.getInnerCode())) {
                            this.setInnerCodeAndParentId(parentVo, codeToData, codeNotExistData);
                            if (StringUtils.isEmpty((CharSequence)parentVo.getInnerCode())) {
                                p.setDescription("\u7236\u5206\u7c7b\u7f16\u7801\u4e0d\u5b58\u5728");
                                errorList.add((MaterialCategoryImportVO)p);
                            } else {
                                p.setInnerCode(parentVo.getInnerCode() + "|" + p.getId());
                                p.setParentId(parentVo.getId());
                                successList.add(p);
                            }
                        } else {
                            p.setInnerCode(parentVo.getInnerCode() + "|" + p.getId());
                            p.setParentId(parentVo.getId());
                            successList.add(p);
                        }
                    } else {
                        successList.add(p);
                    }
                });
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }

    private void setInnerCodeAndParentId(MaterialCategoryImportVO vo, Map<String, MaterialCategoryImportVO> codeToData, Map<String, String> codeNotExistData) {
        MaterialCategoryImportVO parentVo = codeToData.get(vo.getParentCode());
        if (parentVo == null) {
            if (StringUtils.isNotEmpty((CharSequence)codeNotExistData.get(vo.getParentCode()))) {
                vo.setDescription("\u7236\u5206\u7c7b\u7f16\u7801\u4e0d\u5b58\u5728");
            } else {
                List<EquipmentCategoryEntity> list = this.equipmentCategoryService.queryByCode(vo.getParentCode());
                if (ListUtil.isEmpty(list)) {
                    codeNotExistData.put(vo.getParentCode(), vo.getParentCode());
                    vo.setDescription("\u7236\u5206\u7c7b\u7f16\u7801\u4e0d\u5b58\u5728");
                } else {
                    vo.setInnerCode(list.get(0).getInnerCode() + "|" + vo.getId());
                    vo.setParentId(list.get(0).getId());
                }
            }
        } else if (StringUtils.isEmpty((CharSequence)parentVo.getInnerCode())) {
            this.setInnerCodeAndParentId(parentVo, codeToData, codeNotExistData);
            if (StringUtils.isEmpty((CharSequence)parentVo.getInnerCode())) {
                vo.setDescription("\u7236\u5206\u7c7b\u7f16\u7801\u4e0d\u5b58\u5728");
            } else {
                vo.setInnerCode(parentVo.getInnerCode() + "|" + vo.getId());
                vo.setParentId(parentVo.getId());
            }
        } else {
            vo.setInnerCode(parentVo.getInnerCode() + "|" + vo.getId());
            vo.setParentId(parentVo.getId());
        }
    }

    @RequestMapping(value={"/saveImportExcelEquipmentCategory"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveImportExcelEquipmentCategory(@RequestBody List<MaterialCategoryImportVO> importVOS) {
        if (ListUtil.isEmpty(importVOS)) {
            return CommonResponse.error((String)"\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        ArrayList<EquipmentCategoryEntity> toSave = new ArrayList<EquipmentCategoryEntity>();
        importVOS.forEach(importVO -> toSave.add((EquipmentCategoryEntity)BeanMapper.map((Object)importVO, EquipmentCategoryEntity.class)));
        this.equipmentCategoryService.insertBatch(toSave);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }
}

