package com.ejianc.foundation.share.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 客户
 *
 * @author guoming
 *
 */
@TableName("ejc_support_supplier")
public class CustomerProEntity extends BaseEntity {

	private static final long serialVersionUID = 1L;

	@TableField(value = "code")
	private String code; // 客户编码

	@TableField(value = "name")
	private String name; // 客户名称

	@TableField(value = "category_id")
	private Long categoryId; // 客户分类ID

	@TableField(value = "category_name")
	private String categoryName; // 客户分类名称

	@TableField(value = "social_credit_code")
	private String socialCreditCode; // 社会信用代码

	@TableField(value = "legal")
	private String legal; // 法定代表人

	@TableField(value = "business_scope")
	private String businessScope; // 经营范围

	@TableField(value = "enabled")
	private Integer enabled; // 启停用（1：启用 ， 0：停用）

	@TableField(value = "area")
	private String area; // 地区

	@TableField(value = "address")
	private String address; // 详细地址

	@TableField(value = "telephone")
	private String telephone; // 客户电话

	@TableField(value = "bank_name")
	private String bankName; // 账户名

	@TableField(value = "bank_account")
	private String bankAccount;// 银行账号

	@TableField(value = "bank_code")
	private String bankCode; // 开户行

	@TableField(value = "description")
	private String description; // 描述

	@TableField(value = "source_id")
	private String sourceId; // 来源id

	/**
	 * 省份
	 */
	@TableField(value = "province")
	private String province;

	/**
	 * 市区
	 */
	@TableField(value = "city")
	private String city;

	/**
	 * 区县
	 */
	@TableField(value = "region")
	private String region;

	@TableField(value = "org_id")
	private Long orgId; // 所属组织ID

	@TableField(value = "inside_org_id")
	private Long insideOrgId; // 内部客商--来源组织id
	@TableField(value = "inside_org")
	private Boolean insideOrg; // 内外部客商 true：内部，false：外部
	@TableField(value = "org_name")
	private String orgName; // 所属组织

	@TableField(value = "enterprise_nature")
	private Long enterpriseNature; // 企业性质
	@TableField(value = "register_time")
	private Date registerTime; // 注册日期
	@TableField(value = "tax_payer_identifier")
	private String taxPayerIdentifier; // 纳税人识别号
	@TableField(value = "registered_capital")
	private BigDecimal registeredCapital; // 注册资金
	@TableField(value = "legal_phone")
	private String legalPhone; // 法人电话
	@TableField(value = "issuing_time")
	private Date issuingTime; // 发证时间
	@TableField(value = "evaluation_grade")
	private Integer evaluationGrade; // 评价等级(1-合格，0-不合格)
	@TableField(value = "supplier_flag")
	private Integer supplierFlag; // 客商属性，1、供应商，2、客户，3、客商
	@TableField(value = "sub_flag")
	private Integer subFlag; // 是否属于分包，0-否，1-是
	@TableField(value = "blacklist_flag")
	private Integer blacklistFlag; // 是否黑名单，0-否，1-是
	@TableField(value = "redlist_flag")
	private Integer redlistFlag; // 是否红名单，0-否，1-是
	@TableField(value = "operate_id")
	private Long operateId; // 操作人id
	@TableField(value = "operate_name")
	private String operateName; // 操作人名称
	@TableField(value = "operate_time")
	private Date operateTime; // 操作时间
	@TableField(value = "operate_org_id")
	private Long operateOrgId; // 操作人所属组织id
	@TableField(value = "operate_org_name")
	private String operateOrgName; // 操作人所属组织名称
	@TableField(value = "bl_time")
	private Date blTime; // 营业执照有效期
	@TableField(value = "spl_time")
	private Date splTime; // 安全生产许可证有效期
	@TableField(value = "qc_time")
	private Date qcTime; // 资质证书有效期
	@TableField(value = "sc_time")
	private Date scTime; // 安全证有效期
	// 证件类型：lppoa-法人委托授权书，lpidc-法人身份复印件，bl-营业执照，spl-安全生产许可证，qc-资质证书，sc-安全证，other-其他证件
	@TableField(value="access_id")
	private Long accessId; // 供应商准入id


	/** 供应商准入数据 */

	@TableField(value="bill_state")
	private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
	@TableField(value="supply_query_type")
	private String supplyQueryType; // 查询客户列表时候使用的分类， 物资设备供应商：materialEquipment，劳务分包供应商：laborSub
	@TableField(value="supply_type")
	private String supplyType; // 客户类别：专业分包：major，劳务分包：labor，分包班组：sub，材料：material，设备：equipment，其他：other
	@TableField(value="supply_type_name")
	private String supplyTypeName; // 客户类别名称
	@TableField(value="personal")
	private String personal; // 个人：p，企业：e
	@TableField(value="group_in_or_out")
	private String groupInOrOut; // 集团内外：内in，外out
	@TableField(value="apply_org_name")
	private String applyOrgName; // 申请单位
	@TableField(value="apply_org_id")
	private Long applyOrgId; // 申请单位id
	@TableField(value="enterprise_nature_name")
	private String enterpriseNatureName; // 企业性质名称

	@TableField(value="register_country_id")
	private Long registerCountryId; // 注册国家id
	@TableField(value="register_country_name")
	private String registerCountryName; // 注册国家名称

	@TableField(value="area_name")
	private String areaName; // 所在地区
	@TableField(value="in_or_out")
	private Integer inOrOut; // 国内外：1国内，2国外
	@TableField(value="memo")
	private String memo; // 准入说明
	@TableField(value="turnover")
	private BigDecimal turnover; // 年营业额
	@TableField(value="in_exception")
	private Boolean inException; // 是否异常
	@TableField(value="exception_end_date")
	private Date exceptionEndDate; // 异常结束时间
	@TableField(value="last_co_date")
	private Date lastCoDate; // 最近合作时间

	@TableField(value="business_person")
	private String businessPerson;	//业务代表
	@TableField(value="business_phone")
	private String businessPhone;	//业务代表电话
	@TableField(value="main_business_category")
	private String mainBusinessCategory; // 主营类别
	@TableField(value="distributer_or_manufactor")
	private String distributerOrManufactor; // 厂家经销商
	@TableField(value="taxpayer_type")
	private String taxpayerType;//纳税人类型
	@TableField(value="billing_address")
	private String billingAddress;//开票地址
	@TableField(value="billing_phone")
	private String billingPhone;//开票电话
	@TableField(value="bank_account_id")
	private Long bankAccountId;//开票银行
	@TableField(value="bank_account_name")
	private String bankAccountName;//开票银行
	@TableField(value="bank_account_code")
	private String bankAccountCode;//开票银行账户

	@TableField(value="custom_type")
	private Long customType;//客户分类
	@TableField(value="custom_type_name")
	private String customTypeName;//客户分类名称
	@TableField(value="parent_id")
	private Long parentId;//上级客户
	@TableField(value="unit_i8_code")
	private String unitI8Code;//I8单位编码 云南使用
	@TableField(value="customer_level")
	private Integer customerLevel; // 客户等级
	@TableField(value="income_mny")
	private BigDecimal incomeMny; // 累计施工合同额
	@TableField(value="income_num")
	private Integer incomeNum; // 累计施工合同数
	@TableField(value="industry_involved_id")
	private Long industryInvolvedId; // 所属行业id
	@TableField(value="industry_involved")
	private String industryInvolved; // 所属行业

	@TableField(exist=false)
	@SubEntity(serviceName="customerLinkerService",pidName = "customerId")
	private List<CustomerLinkerEntity> linkmen = new ArrayList<>(); // 客户联系人


	public Integer getCustomerLevel() {
		return customerLevel;
	}

	public void setCustomerLevel(Integer customerLevel) {
		this.customerLevel = customerLevel;
	}

	public BigDecimal getIncomeMny() {
		return incomeMny;
	}

	public void setIncomeMny(BigDecimal incomeMny) {
		this.incomeMny = incomeMny;
	}

	public Integer getIncomeNum() {
		return incomeNum;
	}

	public void setIncomeNum(Integer incomeNum) {
		this.incomeNum = incomeNum;
	}

	public Long getIndustryInvolvedId() {
		return industryInvolvedId;
	}

	public void setIndustryInvolvedId(Long industryInvolvedId) {
		this.industryInvolvedId = industryInvolvedId;
	}

	public String getIndustryInvolved() {
		return industryInvolved;
	}

	public void setIndustryInvolved(String industryInvolved) {
		this.industryInvolved = industryInvolved;
	}

	public String getUnitI8Code() {
		return unitI8Code;
	}

	public void setUnitI8Code(String unitI8Code) {
		this.unitI8Code = unitI8Code;
	}

	public String getTaxpayerType() {
		return taxpayerType;
	}

	public void setTaxpayerType(String taxpayerType) {
		this.taxpayerType = taxpayerType;
	}

	public String getBillingAddress() {
		return billingAddress;
	}

	public void setBillingAddress(String billingAddress) {
		this.billingAddress = billingAddress;
	}

	public String getBillingPhone() {
		return billingPhone;
	}

	public void setBillingPhone(String billingPhone) {
		this.billingPhone = billingPhone;
	}

	public Long getBankAccountId() {
		return bankAccountId;
	}

	public void setBankAccountId(Long bankAccountId) {
		this.bankAccountId = bankAccountId;
	}

	public String getBankAccountName() {
		return bankAccountName;
	}

	public void setBankAccountName(String bankAccountName) {
		this.bankAccountName = bankAccountName;
	}

	public String getBankAccountCode() {
		return bankAccountCode;
	}

	public void setBankAccountCode(String bankAccountCode) {
		this.bankAccountCode = bankAccountCode;
	}

	public String getMainBusinessCategory() {
		return mainBusinessCategory;
	}

	public void setMainBusinessCategory(String mainBusinessCategory) {
		this.mainBusinessCategory = mainBusinessCategory;
	}

	public String getDistributerOrManufactor() {
		return distributerOrManufactor;
	}

	public void setDistributerOrManufactor(String distributerOrManufactor) {
		this.distributerOrManufactor = distributerOrManufactor;
	}


	public String getBusinessPerson() {
		return businessPerson;
	}

	public void setBusinessPerson(String businessPerson) {
		this.businessPerson = businessPerson;
	}

	public String getBusinessPhone() {
		return businessPhone;
	}

	public void setBusinessPhone(String businessPhone) {
		this.businessPhone = businessPhone;
	}

	public Integer getBillState() {
		return billState;
	}

	public void setBillState(Integer billState) {
		this.billState = billState;
	}

	public String getSupplyQueryType() {
		return supplyQueryType;
	}

	public void setSupplyQueryType(String supplyQueryType) {
		this.supplyQueryType = supplyQueryType;
	}

	public String getSupplyType() {
		return supplyType;
	}

	public void setSupplyType(String supplyType) {
		this.supplyType = supplyType;
	}

	public String getSupplyTypeName() {
		return supplyTypeName;
	}

	public void setSupplyTypeName(String supplyTypeName) {
		this.supplyTypeName = supplyTypeName;
	}

	public String getPersonal() {
		return personal;
	}

	public void setPersonal(String personal) {
		this.personal = personal;
	}

	public String getGroupInOrOut() {
		return groupInOrOut;
	}

	public void setGroupInOrOut(String groupInOrOut) {
		this.groupInOrOut = groupInOrOut;
	}


	public String getApplyOrgName() {
		return applyOrgName;
	}

	public void setApplyOrgName(String applyOrgName) {
		this.applyOrgName = applyOrgName;
	}

	public Long getApplyOrgId() {
		return applyOrgId;
	}

	public void setApplyOrgId(Long applyOrgId) {
		this.applyOrgId = applyOrgId;
	}

	public String getEnterpriseNatureName() {
		return enterpriseNatureName;
	}

	public void setEnterpriseNatureName(String enterpriseNatureName) {
		this.enterpriseNatureName = enterpriseNatureName;
	}

	public Long getRegisterCountryId() {
		return registerCountryId;
	}

	public void setRegisterCountryId(Long registerCountryId) {
		this.registerCountryId = registerCountryId;
	}

	public String getRegisterCountryName() {
		return registerCountryName;
	}

	public void setRegisterCountryName(String registerCountryName) {
		this.registerCountryName = registerCountryName;
	}


	public String getAreaName() {
		return areaName;
	}

	public void setAreaName(String areaName) {
		this.areaName = areaName;
	}

	public Integer getInOrOut() {
		return inOrOut;
	}

	public void setInOrOut(Integer inOrOut) {
		this.inOrOut = inOrOut;
	}

	public String getMemo() {
		return memo;
	}

	public void setMemo(String memo) {
		this.memo = memo;
	}

	public BigDecimal getTurnover() {
		return turnover;
	}

	public void setTurnover(BigDecimal turnover) {
		this.turnover = turnover;
	}

	public Boolean getInException() {
		return inException;
	}

	public void setInException(Boolean inException) {
		this.inException = inException;
	}

	public Date getExceptionEndDate() {
		return exceptionEndDate;
	}

	public void setExceptionEndDate(Date exceptionEndDate) {
		this.exceptionEndDate = exceptionEndDate;
	}

	public Date getLastCoDate() {
		return lastCoDate;
	}

	public void setLastCoDate(Date lastCoDate) {
		this.lastCoDate = lastCoDate;
	}

	public Long getAccessId() {
		return accessId;
	}

	public void setAccessId(Long accessId) {
		this.accessId = accessId;
	}

	public Integer getRedlistFlag() {
		return redlistFlag;
	}

	public void setRedlistFlag(Integer redlistFlag) {
		this.redlistFlag = redlistFlag;
	}

	public Date getBlTime() {
		return blTime;
	}

	public void setBlTime(Date blTime) {
		this.blTime = blTime;
	}

	public Date getSplTime() {
		return splTime;
	}

	public void setSplTime(Date splTime) {
		this.splTime = splTime;
	}

	public Date getQcTime() {
		return qcTime;
	}

	public void setQcTime(Date qcTime) {
		this.qcTime = qcTime;
	}

	public Date getScTime() {
		return scTime;
	}

	public void setScTime(Date scTime) {
		this.scTime = scTime;
	}

	public Long getEnterpriseNature() {
		return enterpriseNature;
	}

	public void setEnterpriseNature(Long enterpriseNature) {
		this.enterpriseNature = enterpriseNature;
	}

	public Date getRegisterTime() {
		return registerTime;
	}

	public void setRegisterTime(Date registerTime) {
		this.registerTime = registerTime;
	}

	public String getTaxPayerIdentifier() {
		return taxPayerIdentifier;
	}

	public void setTaxPayerIdentifier(String taxPayerIdentifier) {
		this.taxPayerIdentifier = taxPayerIdentifier;
	}

	public BigDecimal getRegisteredCapital() {
		return registeredCapital;
	}

	public void setRegisteredCapital(BigDecimal registeredCapital) {
		this.registeredCapital = registeredCapital;
	}

	public String getLegalPhone() {
		return legalPhone;
	}

	public void setLegalPhone(String legalPhone) {
		this.legalPhone = legalPhone;
	}

	public Date getIssuingTime() {
		return issuingTime;
	}

	public void setIssuingTime(Date issuingTime) {
		this.issuingTime = issuingTime;
	}

	public Integer getEvaluationGrade() {
		return evaluationGrade;
	}

	public void setEvaluationGrade(Integer evaluationGrade) {
		this.evaluationGrade = evaluationGrade;
	}

	public Integer getSupplierFlag() {
		return supplierFlag;
	}

	public void setSupplierFlag(Integer supplierFlag) {
		this.supplierFlag = supplierFlag;
	}

	public Integer getSubFlag() {
		return subFlag;
	}

	public void setSubFlag(Integer subFlag) {
		this.subFlag = subFlag;
	}

	public Integer getBlacklistFlag() {
		return blacklistFlag;
	}

	public void setBlacklistFlag(Integer blacklistFlag) {
		this.blacklistFlag = blacklistFlag;
	}

	public Long getOperateId() {
		return operateId;
	}

	public void setOperateId(Long operateId) {
		this.operateId = operateId;
	}

	public String getOperateName() {
		return operateName;
	}

	public void setOperateName(String operateName) {
		this.operateName = operateName;
	}

	public Date getOperateTime() {
		return operateTime;
	}

	public void setOperateTime(Date operateTime) {
		this.operateTime = operateTime;
	}

	public Long getOperateOrgId() {
		return operateOrgId;
	}

	public void setOperateOrgId(Long operateOrgId) {
		this.operateOrgId = operateOrgId;
	}

	public String getOperateOrgName() {
		return operateOrgName;
	}

	public void setOperateOrgName(String operateOrgName) {
		this.operateOrgName = operateOrgName;
	}

	public String getOrgName() {
		return orgName;
	}

	public void setOrgName(String orgName) {
		this.orgName = orgName;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Long getCategoryId() {
		return categoryId;
	}

	public void setCategoryId(Long categoryId) {
		this.categoryId = categoryId;
	}

	public String getCategoryName() {
		return categoryName;
	}

	public void setCategoryName(String categoryName) {
		this.categoryName = categoryName;
	}

	public String getSocialCreditCode() {
		return socialCreditCode;
	}

	public void setSocialCreditCode(String socialCreditCode) {
		this.socialCreditCode = socialCreditCode;
	}

	public String getLegal() {
		return legal;
	}

	public void setLegal(String legal) {
		this.legal = legal;
	}

	public String getBusinessScope() {
		return businessScope;
	}

	public void setBusinessScope(String businessScope) {
		this.businessScope = businessScope;
	}

	public Integer getEnabled() {
		return enabled;
	}

	public void setEnabled(Integer enabled) {
		this.enabled = enabled;
	}

	public String getArea() {
		return area;
	}

	public void setArea(String area) {
		this.area = area;
	}

	public String getAddress() {
		return address;
	}

	public void setAddress(String address) {
		this.address = address;
	}

	public String getTelephone() {
		return telephone;
	}

	public void setTelephone(String telephone) {
		this.telephone = telephone;
	}

	public String getBankName() {
		return bankName;
	}

	public void setBankName(String bankName) {
		this.bankName = bankName;
	}

	public String getBankAccount() {
		return bankAccount;
	}

	public void setBankAccount(String bankAccount) {
		this.bankAccount = bankAccount;
	}

	public String getBankCode() {
		return bankCode;
	}

	public void setBankCode(String bankCode) {
		this.bankCode = bankCode;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getSourceId() {
		return sourceId;
	}

	public void setSourceId(String sourceId) {
		this.sourceId = sourceId;
	}

	public String getProvince() {
		return province;
	}

	public void setProvince(String province) {
		this.province = province;
	}

	public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	public String getRegion() {
		return region;
	}

	public void setRegion(String region) {
		this.region = region;
	}

	public Long getOrgId() {
		return orgId;
	}

	public void setOrgId(Long orgId) {
		this.orgId = orgId;
	}

	public Long getInsideOrgId() {
		return insideOrgId;
	}

	public void setInsideOrgId(Long insideOrgId) {
		this.insideOrgId = insideOrgId;
	}

	public Boolean getInsideOrg() {
		return insideOrg;
	}

	public void setInsideOrg(Boolean insideOrg) {
		this.insideOrg = insideOrg;
	}

	public List<CustomerLinkerEntity> getLinkmen() {
		return linkmen;
	}

	public void setLinkmen(List<CustomerLinkerEntity> linkmen) {
		this.linkmen = linkmen;
	}

	public Long getCustomType() {
		return customType;
	}

	public void setCustomType(Long customType) {
		this.customType = customType;
	}

	public String getCustomTypeName() {
		return customTypeName;
	}

	public void setCustomTypeName(String customTypeName) {
		this.customTypeName = customTypeName;
	}

	public Long getParentId() {
		return parentId;
	}

	public void setParentId(Long parentId) {
		this.parentId = parentId;
	}
}
