package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.bean.CustomerProEntity;
import com.ejianc.foundation.share.bean.ProjectSetPoolEntity;
import com.ejianc.foundation.share.service.ICustomerProService;
import com.ejianc.foundation.share.service.IProjectSetService;
import com.ejianc.foundation.share.service.ISupplyBankService;
import com.ejianc.foundation.share.vo.CustomerProVO;
import com.ejianc.foundation.share.vo.SupplyBankVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.bean.BankAccountEntity;
import com.ejianc.foundation.support.service.IBankAccountService;
import com.ejianc.foundation.support.vo.BankAccountVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 大企业客户
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("customerPro")
public class CustomerProController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "pro-supplier-code";//此处需要根据实际修改

    @Autowired
    private ICustomerProService service;

    @Autowired
    private ISupplyBankService supplyBankService;

    @Autowired
    private IBankAccountService bankAccountService;

    @Autowired
    private IProjectSetService projectSetService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CustomerProVO> saveOrUpdate(@RequestBody CustomerProVO saveOrUpdateVO) {
    	CustomerProEntity entity = BeanMapper.map(saveOrUpdateVO, CustomerProEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
    	    if(StringUtils.isEmpty(entity.getCode())){
                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if(billCode.isSuccess()) {
                    entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                }else{
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }
            QueryParam param = new QueryParam();
            param.getParams().put("code",new Parameter(QueryParam.EQ,entity.getCode()));
            List<CustomerProEntity> entities = service.queryList(param);
            if(ListUtil.isNotEmpty(entities)){
                return CommonResponse.error("编码重复！");
            }
            param = new QueryParam();
            param.getParams().put("taxPayerIdentifier",new Parameter(QueryParam.EQ,entity.getTaxPayerIdentifier()));
            entities = service.queryList(param);
            if(ListUtil.isNotEmpty(entities)){
                return CommonResponse.error("纳税人识别号重复！");
            }
            param = new QueryParam();
            param.getParams().put("name",new Parameter(QueryParam.EQ,entity.getName()));
            entities = service.queryList(param);
            if(ListUtil.isNotEmpty(entities)){
                return CommonResponse.error("客户名称重复！");
            }
        }else {
            QueryParam param = new QueryParam();
            param.getParams().put("code",new Parameter(QueryParam.EQ,entity.getCode()));
            param.getParams().put("id",new Parameter(QueryParam.NE,entity.getId()));
            List<CustomerProEntity> entities = service.queryList(param);
            if(ListUtil.isNotEmpty(entities)){
                return CommonResponse.error("编码重复！");
            }
            param = new QueryParam();
            param.getParams().put("id",new Parameter(QueryParam.NE,entity.getId()));
            param.getParams().put("taxPayerIdentifier",new Parameter(QueryParam.EQ,entity.getTaxPayerIdentifier()));
            entities = service.queryList(param);
            if(ListUtil.isNotEmpty(entities)){
                return CommonResponse.error("纳税人识别号重复！");
            }
            param = new QueryParam();
            param.getParams().put("id",new Parameter(QueryParam.NE,entity.getId()));
            param.getParams().put("name",new Parameter(QueryParam.EQ,entity.getName()));
            entities = service.queryList(param);
            if(ListUtil.isNotEmpty(entities)){
                return CommonResponse.error("客户名称重复！");
            }
        }
    	if(entity.getEnabled() == null){
    	    entity.setEnabled(1);
        }
    	service.saveOrUpdate(entity, false);
    	CustomerProVO vo = BeanMapper.map(entity, CustomerProVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CustomerProVO> queryDetail(Long id) {
    	CustomerProEntity entity = service.selectById(id);


        QueryParam param = new QueryParam();
        param.getParams().put("supplierId", new Parameter(QueryParam.EQ, id));

        List<BankAccountEntity> supplyBankEntities = bankAccountService.queryList(param, false);

        CustomerProVO vo = BeanMapper.map(entity, CustomerProVO.class);
        if (entity.getParentId() == null){
            //获取子级项目信息
             List<CustomerProEntity> list = service.list(new QueryWrapper<CustomerProEntity>()
                    .eq("dr", 0)
                    .eq("parent_id", id));
            BigDecimal sum = vo.getIncomeMny();
            //计算本级加子级数量总和
            for (CustomerProEntity customerProEntity : list) {
                sum = sum.add(customerProEntity.getIncomeMny());
            }
            vo.setSumMny(sum);
            vo.setChildrenNum(list.size());
        }
        /**
         * 根据建设单位id获取在建中的项目个数
         */
        Integer count = projectSetService.count(new QueryWrapper<ProjectSetPoolEntity>()
                .eq("dr", 0)
                .eq("construct_id", id)
                .eq("project_status", 1));//在建
        vo.setConstructionNum(count);

    	vo.setBanks(BeanMapper.mapList(supplyBankEntities,BankAccountVO.class));
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CustomerProVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (CustomerProVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                 CommonResponse<String> resp = billTypeApi.checkQuote("BT200422000000028", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }
                CustomerProEntity customer = service.selectById(vo.getId());
                if(customer.getInsideOrg()!=null && customer.getInsideOrg()){
                    return CommonResponse.error("删除失败！不能删除内部单位！");
                }
            }
        }
        service.removeByIds(vos.stream().map(CustomerProVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CustomerProVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("code");
        fuzzyFields.add("tax_payer_identifier");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        //supplierFlag 客商属性，1、供应商，2、客户，3、客商
        if(param.getParams().get("supplierFlag") == null){
            param.getParams().put("supplierFlag", new Parameter(QueryParam.IN, "2,3"));
        }

        IPage<CustomerProEntity> page = service.queryPage(param,false);
        IPage<CustomerProVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), CustomerProVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<CustomerProEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("CustomerPro-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refCustomerProData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<CustomerProVO>> refCustomerProData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("code");
        fuzzyFields.add("tax_payer_identifier");

        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        param.getParams().put("supplierFlag", new Parameter(QueryParam.IN, "2,3"));

        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            Boolean insideOrg = _con.getBoolean("insideOrg");
            if(insideOrg!=null){
                param.getParams().put("insideOrg",new Parameter(QueryParam.EQ,insideOrg));
            }

        }

        IPage<CustomerProEntity> page = service.queryPage(param,false);
        IPage<CustomerProVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CustomerProVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 新增或者修改银行信息
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/saveOrUpdateBank", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<BankAccountVO>> saveOrUpdateBank(@RequestBody SupplyBankVO supplyBankVO) {

        if(supplyBankVO.getPid() == null){
            return CommonResponse.error("请先新建客户再添加银行档案！");
        }
        CustomerProEntity customer = service.selectById(supplyBankVO.getPid());
        if(customer == null){
            return CommonResponse.error("请先新建客户再添加银行档案！");
        }

        QueryParam param = new QueryParam();
        param.getParams().put("supplierId", new Parameter(QueryParam.EQ, customer.getId()));
        List<BankAccountEntity> supplyBankEntities = bankAccountService.queryList(param, false);

        if(supplyBankEntities.size() == 0) {
            supplyBankVO.setDefaultable(1);
        }else {
            if(supplyBankVO.getId()!=null){
                BankAccountEntity bankAccountEntity = bankAccountService.selectById(supplyBankVO.getId());
                if(supplyBankVO.getDefaultable() == 1 && bankAccountEntity.getDefaultFlag() != 1){
                    for (BankAccountEntity bankEntity : supplyBankEntities) {
                        bankEntity.setDefaultFlag(0);
                    }
                    bankAccountService.saveOrUpdateBatch(supplyBankEntities);
                    bankAccountEntity = bankAccountService.selectById(supplyBankVO.getId());
                }else {
                    if(supplyBankVO.getDefaultable() != 1 && bankAccountEntity.getDefaultFlag() == 1){
                        return CommonResponse.error("至少有一个默认账户！");
                    }
                }
                bankAccountEntity.setDefaultFlag(supplyBankVO.getDefaultable());
                bankAccountEntity.setBankId(supplyBankVO.getBankId());
                bankAccountEntity.setBankName(supplyBankVO.getBankName());
                bankAccountEntity.setBankCode(supplyBankVO.getBankCode());
                bankAccountEntity.setBankAccount(supplyBankVO.getBankAccount());
                bankAccountEntity.setCategoryId(supplyBankVO.getCategoryId());
                bankAccountEntity.setCategoryName(supplyBankVO.getCategoryName());
                bankAccountEntity.setSupplierFlag(customer.getSupplierFlag());
                bankAccountEntity.setBankAddress(supplyBankVO.getAddress());
                bankAccountEntity.setBankNum(supplyBankVO.getBankNum());
                bankAccountEntity.setSupplierCode(customer.getCode());
                bankAccountEntity.setEnabled(1);
                if(bankAccountEntity.getDefaultFlag()==null){
                    bankAccountEntity.setDefaultFlag(0);
                }
                bankAccountService.saveOrUpdateNoES(bankAccountEntity);

                supplyBankEntities = bankAccountService.queryList(param, false);

                List<BankAccountVO> vo = BeanMapper.mapList(supplyBankEntities,BankAccountVO.class);
                return CommonResponse.success("修改成功！",vo);
            }
        }


        BankAccountVO bankAccountVO = BeanMapper.map(supplyBankVO, BankAccountVO.class);
        if(customer.getInsideOrg()!=null && customer.getInsideOrg()){
            bankAccountVO.setInsideState(1);
        }else {
            bankAccountVO.setInsideState(0);
        }
        bankAccountVO.setSupplierId(customer.getId());
        bankAccountVO.setSupplierName(customer.getName());
        bankAccountVO.setOrgId(customer.getApplyOrgId());
        bankAccountVO.setOrgName(customer.getApplyOrgName());
        bankAccountVO.setSupplierCode(customer.getCode());
        bankAccountVO.setBankAddress(supplyBankVO.getAddress());
        bankAccountVO.setSupplierFlag(customer.getSupplierFlag());
        bankAccountVO.setEnabled(1);
        if(bankAccountVO.getDefaultFlag()==null){
            bankAccountVO.setDefaultFlag(0);
        }
        bankAccountService.insertOrUpdate(bankAccountVO);
        supplyBankEntities = bankAccountService.queryList(param, false);
        List<BankAccountVO> vo = BeanMapper.mapList(supplyBankEntities,BankAccountVO.class);
        return CommonResponse.success("保存成功！",vo);
    }

    /**
     * 删除
     *
     * @param ids
     * @return
     */
    @RequestMapping(value = "/delBank", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<BankAccountVO>> delBank(@RequestBody List<Long> ids) {
        BankAccountEntity accountEntity = null;
        if(ListUtil.isNotEmpty(ids)){
            for (Long id : ids) {
                CommonResponse<String>  response = billTypeApi.checkQuote("BT200422000000028",id);
                if(!response.isSuccess()){
                    return CommonResponse.error("删除失败："+response.getMsg());
                }
                accountEntity = bankAccountService.selectById(id);
            }
            bankAccountService.delBySuppAndCustomIds("supplierId",ids);
        }else {
            return CommonResponse.error("删除失败：主键为空!");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("supplierId", new Parameter(QueryParam.EQ, accountEntity.getSupplierId()));
        List<BankAccountEntity> supplyBankEntities = bankAccountService.queryList(param, false);
        List<BankAccountVO> vo = BeanMapper.mapList(supplyBankEntities,BankAccountVO.class);
        return CommonResponse.success("删除成功");
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryChildrenId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<Long>> queryChildrenId(Long id) {
        List<CustomerProEntity> list = service.list(new QueryWrapper<CustomerProEntity>()
                .eq("dr", 0)
                .eq("parent_id", id));
        List<Long> collect = list.stream().map(CustomerProEntity::getId).collect(Collectors.toList());
        return CommonResponse.success("查询详情数据成功！",collect);
    }

}
