/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.bean.ProsubCategoryEntity;
import com.ejianc.foundation.share.service.IProsubCategoryService;
import com.ejianc.foundation.share.service.IProsubItemService;
import com.ejianc.foundation.share.vo.ProsubCategoryVO;
import com.ejianc.foundation.share.vo.RefProsubCategoryVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/majorSub/category"})
public class ProsubCategoryController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IProsubCategoryService service;
    @Autowired
    private IProsubItemService prosubItemService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ProsubCategoryVO> saveOrUpdate(@RequestBody ProsubCategoryVO saveorUpdateVO) {
        CommonResponse<ProsubCategoryVO> response = this.service.saveOrUpdateProsubCategory(saveorUpdateVO);
        return response;
    }

    @RequestMapping(value={"/bandSubject"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> bandSubject(@RequestBody Map map) {
        List ids = (List)map.get("ids");
        Long subjectId = Long.valueOf(map.get("subjectId").toString());
        String subjectName = (String)map.get("subjectName");
        this.service.updateSubject(subjectId, subjectName, ids);
        return CommonResponse.success((String)"\u7ed1\u5b9a\u6210\u529f!");
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ProsubCategoryVO> queryDetail(Long id) {
        ProsubCategoryEntity entity = (ProsubCategoryEntity)((Object)this.service.selectById(id));
        ProsubCategoryVO vo = (ProsubCategoryVO)BeanMapper.map((Object)((Object)entity), ProsubCategoryVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProsubCategoryVO> vos) {
        CommonResponse<String> msg = this.service.deleteById(vos);
        return msg;
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List<ProsubCategoryVO> dataList = this.service.queryProsubCategoryList(param);
        List resultMapList = BeanMapper.mapList(dataList, Map.class);
        resultMapList.forEach(l -> {
            if (l.get("isLeaf").equals(false)) {
                l.put("children", new ArrayList());
            }
        });
        List treeData = ResultAsTree.createTreeData((List)resultMapList);
        return CommonResponse.success((Object)treeData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>(list.size());
        beans.put("records", list);
        ExcelExport.getInstance().export("ProsubCategory-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refProsubCategoryData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> refProsubCategoryData(Integer pageNumber, Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.getFuzzyFields().add("detail_name");
        param.getFuzzyFields().add("detail_code");
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        try {
            QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
            List<Map> list = this.service.queryMajorSubList(wrapper);
            if (StringUtils.isNotEmpty((CharSequence)searchText) && CollectionUtils.isNotEmpty(list)) {
                HashSet parentIds = new HashSet();
                ArrayList ids = new ArrayList();
                List<String> innerCodeList = list.stream().map(map -> String.valueOf(map.get("inner_code"))).collect(Collectors.toList());
                innerCodeList.forEach(innerCode -> {
                    String[] innerCodeArr = innerCode.split("\\|");
                    List<String> innerCodeSplit = Arrays.asList(innerCodeArr);
                    if (innerCodeSplit.size() > 1) {
                        innerCodeSplit.forEach(t -> parentIds.add(Long.valueOf(t)));
                        ids.add(Long.valueOf(innerCodeSplit.get(innerCodeSplit.size() - 1)));
                    } else {
                        Long pIdOrId = Long.valueOf(innerCodeSplit.get(0));
                        parentIds.add(pIdOrId);
                        ids.add(pIdOrId);
                    }
                });
                QueryWrapper searchWrapper = new QueryWrapper();
                searchWrapper.in((Object)"id", parentIds);
                if (CollectionUtils.isNotEmpty((Collection)ids)) {
                    ids.forEach(id -> {
                        searchWrapper.or();
                        searchWrapper.like((Object)"inner_code", (Object)(id + "|"));
                    });
                    list = this.service.queryMajorSubList(searchWrapper);
                }
            }
            ArrayList listMap = new ArrayList();
            for (Map map2 : list) {
                HashMap map1 = new HashMap();
                map1.put("detailName", map2.get("detail_name"));
                map1.put("detailCode", map2.get("detail_code"));
                map1.put("unitName", map2.get("unit_name"));
                map1.put("jobContent", map2.get("job_content"));
                map1.put("priceType", map2.get("price_type"));
                map1.put("id", map2.get("id"));
                map1.put("remarks", map2.get("remarks"));
                map1.put("parentId", map2.get("parentId"));
                map1.put("flag", map2.get("flag"));
                listMap.add(map1);
            }
            List treeData = ResultAsTree.createTreeData(listMap);
            return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)treeData);
        }
        catch (Exception e) {
            return null;
        }
    }

    @RequestMapping(value={"/refProsubCategoryTreeData"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> refProsubCategoryTreeData(Integer pageNumber, Integer pageSize, String condition, String searchObject, String searchText) {
        CommonResponse<List<Map<String, Object>>> listCommonResponse = this.refProsubCategoryData(pageNumber, pageSize, condition, searchObject, searchText);
        return null == listCommonResponse ? null : (List)listCommonResponse.getData();
    }

    @RequestMapping(value={"/lazyProSubCategoryTree"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> lazyProsubCategoryTree(@RequestParam(required=false) Integer pageNumber, @RequestParam(required=false) Integer pageSize, String condition, String searchObject, String searchText, Long pid) {
        JSONObject con;
        Object categoryIdObj;
        QueryParam param = new QueryParam();
        if (pageSize != null) {
            param.setPageSize(pageSize.intValue());
        }
        if (pageNumber != null) {
            param.setPageIndex(pageNumber.intValue());
        }
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.setFuzzyFields(Arrays.asList("categoryCode", "categoryName", "remarks"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (pid != null) {
            param.getParams().put("parent_id", new Parameter("eq", (Object)pid));
        } else if (StringUtils.isNotBlank((CharSequence)condition) && null == pid && null != (categoryIdObj = (con = JSONObject.parseObject((String)condition)).get((Object)"categoryId"))) {
            List<Long> asList = new ArrayList<Long>();
            String categoryId = (String)categoryIdObj;
            if (categoryId.indexOf(",") > 0) {
                String[] strings;
                for (String str : strings = categoryId.split(",")) {
                    asList.add(Long.valueOf(str));
                }
            } else {
                asList.add(Long.valueOf(categoryId));
            }
            if (StringUtils.isNotBlank((CharSequence)searchText)) {
                List<ProsubCategoryEntity> categoryVOS = this.service.queryListByPids(asList);
                asList = categoryVOS.stream().map(BaseEntity::getId).collect(Collectors.toList());
            }
            param.getParams().put("id", new Parameter("in", asList));
        }
        List prosubCategoryEntities = this.service.queryList(param, false);
        List prosubCategoryVOS = BeanMapper.mapList((Iterable)prosubCategoryEntities, RefProsubCategoryVO.class);
        List map = BeanMapper.mapList((Iterable)prosubCategoryVOS, Map.class);
        List treeData = ResultAsTree.createTreeData((List)map);
        if (CollectionUtils.isNotEmpty((Collection)treeData)) {
            map.forEach(item -> {
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("parent_id", new Parameter("eq", item.get("id")));
                List prosubCategoryEntities1 = this.service.queryList(queryParam);
                if (CollectionUtils.isNotEmpty((Collection)prosubCategoryEntities1)) {
                    item.put("isLeaf", false);
                } else {
                    item.put("isLeaf", true);
                }
            });
        }
        return treeData;
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"prosub-category-import.xlsx", (String)"\u4e13\u4e1a\u5206\u5305\u5206\u7c7b\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request) {
        CommonResponse<JSONObject> response = this.service.excelImport(request);
        return response;
    }

    @RequestMapping(value={"/saveImportExcelProsubCategory"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveImportExcelProsubCategory(@RequestBody List<ProsubCategoryEntity> importVos) {
        if (ListUtil.isEmpty(importVos)) {
            return CommonResponse.error((String)"\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        ArrayList toSave = new ArrayList();
        importVos.forEach(importVO -> {
            ProsubCategoryEntity entity = (ProsubCategoryEntity)((Object)((Object)BeanMapper.map((Object)importVO, ProsubCategoryEntity.class)));
            entity.setOrgId(this.sessionManager.getUserContext().getOrgId());
            entity.setOrgName(this.sessionManager.getUserContext().getOrgName());
            toSave.add(entity);
        });
        this.service.saveBatch(toSave, toSave.size());
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/changeCategoryEnableState"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> changeCategoryEnableState(@RequestParam(value="id") Long id, @RequestParam(value="enabled") Integer enabled) {
        this.service.changeCategoryEnableState(id, enabled);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }
}

