package com.ejianc.foundation.share.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.share.bean.SupplierEntity;
import com.ejianc.foundation.share.service.ISupplierService;
import com.ejianc.foundation.share.service.ISupplyBankService;
import com.ejianc.foundation.share.vo.BankVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.bean.BankAccountEntity;
import com.ejianc.foundation.support.bean.BankEntity;
import com.ejianc.foundation.support.service.IBankAccountService;
import com.ejianc.foundation.support.service.IBankService;
import com.ejianc.foundation.support.vo.BankAccountVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author CJ
 * @Description:
 * @date 2020/6/30 15:03
 */
@RestController
@RequestMapping("/api/bankApi/")
public class BankApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBankAccountService bankAccountService;
    @Autowired
    private ISupplierService supplierService;
    @Autowired
    private IBankService bankService;

    @Autowired
    private ISupplyBankService supplyBankService;

    /***
     * @description: 推送银行档案
     * @param
     * @param
     * @date: 2022/3/28
     */
    @PostMapping(value = "pushToBank")
    public CommonResponse<String> pushToBank(@RequestBody byte[] supplyByte) {
        String supplyStr = new String(supplyByte, StandardCharsets.UTF_8);
        SupplierVO supplierVO = JSONObject.parseObject(supplyStr, SupplierVO.class);
        supplierVO.setSocialCreditCode(supplierVO.getTaxPayerIdentifier());
        supplierVO.setEnabled(1);//默认启用
        supplierVO.setComeFrom("邀请入库");//邀请入库
        supplierVO.setInsideOrg(false);//外部客商
        supplierVO.setGroupInOrOut("out");//集团外
        supplierVO.setSupplierFlag(1);
        SupplierEntity se = BeanMapper.map(supplierVO, SupplierEntity.class);
        Boolean coordination = se.getCoordination();
        if (coordination == null) {
            se.setCoordination(false);
        }
        supplierService.saveOrUpdate(se, false);
        //同步至主数据
        supplierService.syncMdmSupplierZzyj(se.getId());
        SupplierVO vo = BeanMapper.map(se, SupplierVO.class);
        List<BankAccountVO> banks = supplierVO.getBanks();
        if (banks.size() != 0) {
            QueryParam params = new QueryParam();
            List<Long> collect = banks.stream().map(BankAccountVO::getId).collect(Collectors.toList());
            params.getParams().put("id", new Parameter(QueryParam.IN, collect));
            List<BankAccountEntity> bankAccountEntityList = bankAccountService.queryList(params);
            if (CollectionUtils.isNotEmpty(bankAccountEntityList)) {
                return CommonResponse.error("保存失败！已存在相同账号的银行账户");
            }
            logger.info("推送，生成银行账户pushToBank--=-=-=-=-=-=----------------------------------------------{}", supplyStr);

            for (BankAccountVO bankVO : banks) {
                BankAccountEntity accountEntity = BeanMapper.map(bankVO,BankAccountEntity.class);
                accountEntity.setOrgName(supplierVO.getApplyOrgName());
                accountEntity.setOrgId(supplierVO.getApplyOrgId());
                accountEntity.setSupplierId(supplierVO.getId());
                accountEntity.setSupplierName(supplierVO.getName());
                accountEntity.setSupplierCode(supplierVO.getCode());

                if(bankVO.getBankNum() == null){
                    BankEntity bankEntity = bankService.selectById(bankVO.getBankId());
                    accountEntity.setBankNum(bankEntity.getCode());
                    accountEntity.setCategoryName(bankEntity.getBankCategoryName());
                    accountEntity.setCategoryId(bankEntity.getBankCategoryId());
                }
                accountEntity.setTenantId(999999L);
                accountEntity.setEnabled(1);
                accountEntity.setInsideState(0);
                accountEntity.setSupplierFlag(1);//供应商
                if(accountEntity.getDefaultFlag()==null){
                    accountEntity.setDefaultFlag(0);
                }
                bankAccountService.saveOrUpdate(accountEntity);

                //同步至主数据
                supplyBankService.syncMdmBankInfoZzyj(Arrays.asList(accountEntity.getId()));

            }
        }

        return CommonResponse.success();
    }


    /***
     * @param bankAccountVO
     * @param1 supplierId 供应商id
     * @param2 supplierName 供应商名称
     * @param3 enabled 是否启用 1启用 0停用
     * @param4 defaultFlag 是否默认 1是 0否
     * @description: 通过条件获取银行账户
     * @return: com.ejianc.framework.core.response.CommonResponse<java.util.List < com.ejianc.foundation.support.vo.BankAccountVO>>
     * @author songlx
     * @date: 2022/5/24
     */
    @PostMapping(value = "getBankAccountsByCondition")
    public CommonResponse<List<BankAccountVO>> getBankAccountsByCondition(@RequestBody BankAccountVO bankAccountVO) {
        QueryWrapper<BankAccountEntity> bankAccountEntityQueryWrapper = new QueryWrapper<>();
        bankAccountEntityQueryWrapper.eq(bankAccountVO.getSupplierId() != null, "supplier_id", bankAccountVO.getSupplierId());
        bankAccountEntityQueryWrapper.in(CollectionUtils.isNotEmpty(bankAccountVO.getSupplierIds()), "supplier_id", bankAccountVO.getSupplierIds());
        bankAccountEntityQueryWrapper.eq(bankAccountVO.getSupplierName() != null, "supplier_name", bankAccountVO.getSupplierName());
        bankAccountEntityQueryWrapper.eq(bankAccountVO.getEnabled() != null, "enabled", bankAccountVO.getEnabled());
        bankAccountEntityQueryWrapper.eq(bankAccountVO.getDefaultFlag() != null, "default_flag", bankAccountVO.getDefaultFlag());
        List<BankAccountEntity> list = bankAccountService.list(bankAccountEntityQueryWrapper);
        List<BankAccountVO> bankAccountVOS = BeanMapper.mapList(list, BankAccountVO.class);
        return CommonResponse.success("通过条件获取账户成功！", bankAccountVOS);
    }


    /**
     * 批量插入/更新银行账户
     */
    @PostMapping(value = "batchSaveOrUpdBankAccount")
    CommonResponse<String> batchSaveOrUpdBankAccount(@RequestBody List<BankAccountVO> bankAccountVOS) {
        if (CollectionUtils.isEmpty(bankAccountVOS)) {
            return CommonResponse.error("银行账号列表不能为空！");
        }
        List<BankAccountVO> addItems = bankAccountVOS.stream().filter(s -> s.getId() == null).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(addItems)) {
            bankAccountService.validate(addItems, null, null, false);
            for (BankAccountVO addItem : addItems) {
                if (StringUtils.isNotEmpty(addItem.getWarnType())) {
                    return CommonResponse.error(addItem.getWarnType());
                }
            }
        }
        List<BankAccountEntity> bankAccountEntities = BeanMapper.mapList(bankAccountVOS, BankAccountEntity.class);
        bankAccountService.saveOrUpdateBatch(bankAccountEntities);
        return CommonResponse.success("批量插入/更新银行账户成功！");
    }

}
