package com.ejianc.foundation.share.service.impl;

import com.ejianc.foundation.share.bean.MaterialCategoryEntity;
import com.ejianc.foundation.share.bean.MaterialEntity;
import com.ejianc.foundation.share.mapper.MaterialCategoryMapper;
import com.ejianc.foundation.share.mapper.SteelMaterialCategoryMapper;
import com.ejianc.foundation.share.service.IMaterialCategoryService;
import com.ejianc.foundation.share.service.IMaterialService;
import com.ejianc.foundation.share.service.ISteelMaterialCategoryService;
import com.ejianc.foundation.share.service.ISteelMaterialService;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

@Service
public class SteelMaterialCategoryServiceImpl implements ISteelMaterialCategoryService {

	@Autowired
	private SteelMaterialCategoryMapper materialCategoryMapper;
	@Autowired
	private ISteelMaterialService materialService;

	@Override
	public List<MaterialCategoryEntity> queryList(QueryParam queryParam) {
		Map<String, Parameter> paramMap = queryParam.getParams();

		Map<String,Object> condition = new HashMap<String, Object>();
		for(Map.Entry<String, Parameter> entry:paramMap.entrySet()) {
			condition.put(entry.getKey(), entry.getValue().getValue());
		}
		//放入租户ID进map
		condition.put("tenantId", InvocationInfoProxy.getTenantid());
		List<MaterialCategoryEntity> resultList = materialCategoryMapper.queryList(condition);
		return resultList;
	}

	@Override
	public MaterialCategoryVO queryDetail(Long id) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		MaterialCategoryEntity entity = materialCategoryMapper.queryDetail(tenantId, id);
		if(entity != null) {
			return BeanMapper.map(entity, MaterialCategoryVO.class);
		}
		return null;
	}

	@Override
	public void update(MaterialCategoryEntity entity) {
		materialCategoryMapper.update(entity);
		Long tenantId = InvocationInfoProxy.getTenantid();
		List<Long> ids = new ArrayList<>();
		ids.add(entity.getId());
		List<MaterialCategoryEntity> materialCategoryEntities = materialCategoryMapper.queryByInnerCodes(tenantId,ids);
		ids.clear();
		materialCategoryEntities.forEach(item->{
			ids.add(item.getId());
			// 更新字表的数据
			materialService.updateByCategoryId(item.getId(),entity.getSubjectId(),entity.getSubjectName());
		});
		materialCategoryMapper.updateSubject(tenantId,entity.getSubjectId(),entity.getSubjectName(),ids);
	}

	@Override
	public void updateSubject(Long subjectId, String subjectName, List<Long> ids) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		List<MaterialCategoryEntity> materialCategoryEntities = materialCategoryMapper.queryByInnerCodes(tenantId, ids);
		ids.clear();
		materialCategoryEntities.forEach(item->{
			ids.add(item.getId());
			// 更新字表的数据
			materialService.updateByCategoryId(item.getId(),subjectId,subjectName);
		});
		materialCategoryMapper.updateSubject(tenantId,subjectId,subjectName,ids);
	}

	@Override
	public void save(MaterialCategoryEntity entity) {
		materialCategoryMapper.insert(entity);
	}

	/**
	 * 批量新增
	 *
	 * @param categoryEntityList
	 */
	@Override
	public void insertBatch(List<MaterialCategoryEntity> categoryEntityList) {
		if(ListUtil.isNotEmpty(categoryEntityList)){
			List<MaterialCategoryEntity> toInsert = new ArrayList<>();
			for (MaterialCategoryEntity entity : categoryEntityList){
				if (toInsert.size()>0 && toInsert.size() % 1000 == 0) {
					materialCategoryMapper.insertBatch(InvocationInfoProxy.getTenantid(),toInsert);
					toInsert = new ArrayList<>();
				}
				toInsert.add(entity);
			}
			if(toInsert.size()>0){
				materialCategoryMapper.insertBatch(InvocationInfoProxy.getTenantid(),toInsert);
			}
		}
	}

	@Override
	public List<MaterialCategoryVO> queryListByPid(Long id) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		List<MaterialCategoryEntity> materialCategoryList = materialCategoryMapper.queryListByPid(tenantId, id);
		if(materialCategoryList != null && materialCategoryList.size() > 0) {
			return BeanMapper.mapList(materialCategoryList, MaterialCategoryVO.class);
		}
		return null;
	}

	@Override
	public List<MaterialCategoryVO> queryListAllByPid(Long id) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		List<MaterialCategoryEntity> materialCategoryList = materialCategoryMapper.queryListAllByPid(tenantId, id);
		if(materialCategoryList != null && materialCategoryList.size() > 0) {
			return BeanMapper.mapList(materialCategoryList, MaterialCategoryVO.class);
		}
		return null;
	}

	@Override
	public void delete(Long id) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		materialCategoryMapper.delete(tenantId,id);
	}

	@Override
	public void updateEnabled(Integer enabled, Long tenantId, String innerCode) {
		materialCategoryMapper.updateEnabled(enabled,tenantId,innerCode,InvocationInfoProxy.getUsercode());
	}

	@Override
	public List<MaterialCategoryEntity> queryByCode(String code) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		return materialCategoryMapper.queryByCode(tenantId, code);
	}

	@Override
	public List<MaterialCategoryEntity> queryByName(String name) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		return materialCategoryMapper.queryByName(tenantId, name);
	}

	@Override
	public void insertCategoryListFromPlatform() {
		Long tenantId = InvocationInfoProxy.getTenantid();
		materialCategoryMapper.insertCategoryListFromPlatform(tenantId);
	}

	@Override
	public List<MaterialCategoryVO> queryListTree(Map<String, Object> params) {
		List<MaterialCategoryEntity> materialCategoryList = materialCategoryMapper.queryListTree(params);
		if(materialCategoryList != null && materialCategoryList.size() > 0) {
			return BeanMapper.mapList(materialCategoryList, MaterialCategoryVO.class);
		}
		return null;
	}
	
	@Override
	public List<MaterialCategoryEntity> queryListEntityTree(Map<String, Object> params) {
		List<MaterialCategoryEntity> materialCategoryList = materialCategoryMapper.queryListTree(params);
		return materialCategoryList;
	}

	@Override
	public List<Long> queryUnenabledCategoryListId() {
		return materialCategoryMapper.queryUnenabledCategoryListId();
	}

	@Override
	@Transactional
	public void changeCategoryEnableState(Long id, Integer enabled) {
		//1、查询出该分类
		MaterialCategoryEntity entity = materialCategoryMapper.queryDetail(InvocationInfoProxy.getTenantid(), id);
		if (entity == null) {
			throw new BusinessException("该分类不存在！");
		}
		Map<String, Object> params = new HashMap<>();
		params.put("innerCode", entity.getInnerCode());
		params.put("tenantId", InvocationInfoProxy.getTenantid());
		List<MaterialCategoryEntity> categoryEntities = materialCategoryMapper.queryListByInnerCode(params);
		List<Long> categoryIds = categoryEntities.stream().map(MaterialCategoryEntity::getId).collect(Collectors.toList());
		materialCategoryMapper.updateEnabled(enabled, InvocationInfoProxy.getTenantid(), entity.getInnerCode(),InvocationInfoProxy.getUsercode());
		materialService.updateStateByCategoryId(categoryIds, enabled, InvocationInfoProxy.getTenantid());
	}

	@Override
	public MaterialCategoryVO queryBySourceId(String sourceId) {
		MaterialCategoryEntity entity = materialCategoryMapper.queryBySourceId(sourceId, InvocationInfoProxy.getTenantid());
		if (entity != null && entity.getId() != null) {
			return BeanMapper.map(entity, MaterialCategoryVO.class);
		}
		return null;
	}

	@Override
	public List<MaterialCategoryVO> queryListByInnerCode(Map<String, Object> params) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		params.put("tenantId", tenantId);
		List<MaterialCategoryEntity> materialCategoryList = materialCategoryMapper.queryListByInnerCode(params);
		if(materialCategoryList != null && materialCategoryList.size() > 0) {
			return BeanMapper.mapList(materialCategoryList, MaterialCategoryVO.class);
		}
		return null;
	}

	@Override
	public List<MaterialCategoryVO> queryCategoryListByChildren(List<Long> ids) {
		List<MaterialCategoryVO> result = new ArrayList<>();
		Map<String, Object> params = new HashMap<>();
		Long tenantId = InvocationInfoProxy.getTenantid();
		params.put("tenantId", tenantId);
		List<MaterialCategoryEntity> materialCategoryList = materialCategoryMapper.queryListTree(params);
		if(materialCategoryList != null && materialCategoryList.size() > 0) {
			Set<Long> keySet = new HashSet<>();
			List<MaterialCategoryVO> materialCategoryVOS =  BeanMapper.mapList(materialCategoryList, MaterialCategoryVO.class);
			Map<Long, MaterialCategoryVO> categoryVOMap = materialCategoryVOS.stream().collect(Collectors.toMap(MaterialCategoryVO::getId, Function.identity(), (key1, key2) -> key2));
			for(Long id : ids){
				MaterialCategoryVO categoryVO = categoryVOMap.get(id);
				String innerCode = categoryVO.getInnerCode();
				String[] keyArray = innerCode.split("\\|");
				for(String keyStr : keyArray){
					Long key = Long.valueOf(keyStr);
					if(!keySet.contains(key)){
						keySet.add(key);
						result.add(categoryVOMap.get(key));
					}
				}
			}
		}
		return result;
	}

	@Override
	public Map<Long, List<MaterialCategoryVO>> queryCategoryListByMaterialId(List<Long> ids) {
		List<MaterialEntity> materialEntityList = materialService.queryMaterialByIds(ids);
		Map<Long, List<MaterialCategoryVO>> resMap = new HashMap<>();
		Map<String, Object> params = new HashMap<>();
		Long tenantId = InvocationInfoProxy.getTenantid();
		params.put("tenantId", tenantId);
		List<MaterialCategoryEntity> materialCategoryList = materialCategoryMapper.queryListTree(params);
		if(materialCategoryList != null && materialCategoryList.size() > 0) {
			List<MaterialCategoryVO> materialCategoryVOS =  BeanMapper.mapList(materialCategoryList, MaterialCategoryVO.class);
			Map<Long, MaterialCategoryVO> categoryVOMap = materialCategoryVOS.stream().collect(Collectors.toMap(MaterialCategoryVO::getId, Function.identity(), (key1, key2) -> key2));
			for(MaterialEntity mentity:materialEntityList){
				Long categoryId = mentity.getCategoryId();
				MaterialCategoryVO categoryVO = categoryVOMap.get(categoryId);
				String innerCode = categoryVO.getInnerCode();
				String[] keyArray = innerCode.split("\\|");
				List<MaterialCategoryVO> result = new ArrayList<>();
				for(int i = keyArray.length - 1; i >= 0; i --){
					Long key = Long.valueOf(keyArray[i]);
					result.add(categoryVOMap.get(key));
				}
				resMap.put(mentity.getId(),result);
			}
		}
		return resMap;
	}

	@Override
	public List<MaterialCategoryVO> queryCategoryListByIds(List<Long> ids) {
		Map<String, Object> params = new HashMap<>();
		Long tenantId = InvocationInfoProxy.getTenantid();
		params.put("tenantId", tenantId);
		params.put("ids", ids);
		List<MaterialCategoryEntity> materialCategoryList = materialCategoryMapper.queryListByIds(params);
		if(materialCategoryList != null && materialCategoryList.size() > 0) {
			return BeanMapper.mapList(materialCategoryList, MaterialCategoryVO.class);
		}
		return null;
	}

	@Override
	public List<MaterialCategoryVO> queryRemoveListByIds(Long pid) {
		Map<String, Object> params = new HashMap<>();
		Long tenantId = InvocationInfoProxy.getTenantid();
		params.put("tenantId", tenantId);
		params.put("parentId",pid);
		List<MaterialCategoryEntity> materialCategoryList = materialCategoryMapper.queryRemoveListByIds(params);
		if(materialCategoryList != null && materialCategoryList.size() > 0) {
			return BeanMapper.mapList(materialCategoryList, MaterialCategoryVO.class);
		}
		return null;
	}

	@Override
	public void delete(List<Long> ids) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		for(Long id:ids) {
			materialCategoryMapper.delete(tenantId, id);
		}
	}

}
