package com.ejianc.foundation.share.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.share.bean.SupplierEntity;
import com.ejianc.foundation.share.bean.SupplyBankEntity;
import com.ejianc.foundation.share.mapper.SupplyBankMapper;
import com.ejianc.foundation.share.service.ISupplyBankService;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.util.http.HttpTookitNew;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

/**
 * 供应商准入---单位银行信息
 * 
 * @author generator
 * 
 */
@Service("supplyBankService")
public class SupplyBankServiceImpl extends BaseServiceImpl<SupplyBankMapper, SupplyBankEntity> implements ISupplyBankService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Value("${common.env.base-host}")
	private String baseHost;

	@Autowired
	private SupplyBankMapper supplyBankMapper;

	@Override
	public List<JSONObject> querySupplyBankListBySyncTime(String syncTime) {
		List<JSONObject> supplierBankList = supplyBankMapper.querySupplyBankListBySyncTime(syncTime);
		return supplierBankList;
	}

	@Override
	public void updateNoTransBankInfo() {
		supplyBankMapper.updateNoTransBankInfo();
	}



	/**
	 * 同步到主数据(业务同步)，重要的新增操作执行此方法，其余新增修改通过主数据同步完成
	 * @param accountIds
	 * @return
	 */
	@Override
	public String syncMdmBankInfoZzyj(List<Long> accountIds) {
		logger.info(">>>>郑州一建 业务同步供应商银行账户数据startsupplierId = {}",accountIds.toString());

		String syncUrl = baseHost+"ejc-mdm-web/zzyj/sync/bankInfos/synczzyj";
		List<JSONObject> jsonObjects = baseMapper.querySupplyBankListById(accountIds);
		if (jsonObjects != null && jsonObjects.size() >0) {
			try {
				String resp = HttpTookitNew.postJson(syncUrl, JSONObject.toJSONString(jsonObjects));
				logger.info(">>>>郑州一建 业务同步供应商银行账户数据...syncUrl = {},resp:{}", syncUrl,resp);

			} catch (Exception e) {
				e.printStackTrace();
				logger.error(">>>>郑州一建业务同步 供应商银行账户报错---------", e);
			}
		}else {
			logger.error(">>>>郑州一建业务同步 无供应商银行账户数据---------{}", accountIds);
		}
		return ">>>>郑州一建业务同步 供应商银行账户执行完毕!";
	}
}
