package com.ejianc.foundation.share.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.foundation.share.bean.PriceDepotPowerSetEntity;
import com.ejianc.foundation.share.service.IPriceDepotPowerSetService;
import com.ejianc.foundation.share.vo.PriceDepotPowerSetVO;

/**
 * 价格库权限设置
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("priceDepotPowerSet")
public class PriceDepotPowerSetController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IPriceDepotPowerSetService service;

    private static final String BILL_CODE = "PRICE_DEPOT_POWER";//此处需要根据实际修改

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PriceDepotPowerSetVO> saveOrUpdate(@RequestBody PriceDepotPowerSetVO saveOrUpdateVO) {
    	PriceDepotPowerSetEntity entity = BeanMapper.map(saveOrUpdateVO, PriceDepotPowerSetEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            // 新增时校验org唯一性
            Long orgId = entity.getOrgId();
            QueryWrapper<PriceDepotPowerSetEntity> wrapper = new QueryWrapper<>();
            wrapper.eq("org_id",orgId);
            List<PriceDepotPowerSetEntity> list = service.list(wrapper);
            if(list.size() > 0){
                return CommonResponse.error("该组织已经存在配置！");
            }
            CommonResponse<String> codeBatchByRuleCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(codeBatchByRuleCode.isSuccess()){
                entity.setCode(codeBatchByRuleCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }else{
            // 当前登录的组织
            Long thisOrgId = InvocationInfoProxy.getOrgId();
            // 单据中的组织
            Long orgId = entity.getOrgId();
            CommonResponse<OrgVO> oneById = iOrgApi.getOneById(orgId);
            if(!oneById.isSuccess() || oneById.getData() == null) {
                return CommonResponse.error("查询组织信息失败！");
            }

            Boolean result = false;
            OrgVO data = oneById.getData();
            String innerCode = data.getInnerCode();
            String[] split = innerCode.split("\\|");
            for (String s : split) {
                if(Long.valueOf(s).equals(thisOrgId)){
                    result = true;
                }
            }
            if(!result){
                return CommonResponse.error("非本上组织不可操作！");
            }
        }
    	service.saveOrUpdate(entity, false);
    	PriceDepotPowerSetVO vo = BeanMapper.map(entity, PriceDepotPowerSetVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PriceDepotPowerSetVO> queryDetail(Long id) {
    	PriceDepotPowerSetEntity entity = service.selectById(id);
    	PriceDepotPowerSetVO vo = BeanMapper.map(entity, PriceDepotPowerSetVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> delete(@RequestParam List<Long> ids) {
        List<PriceDepotPowerSetVO> vos = new ArrayList<>();
        if(ListUtil.isNotEmpty(ids)){
            QueryWrapper<PriceDepotPowerSetEntity> wrapper = new QueryWrapper<>();
            wrapper.in("id",ids);
            List<PriceDepotPowerSetEntity> list = service.list(wrapper);
            vos = BeanMapper.mapList(list, PriceDepotPowerSetVO.class);
            for (PriceDepotPowerSetVO vo : vos) {
                // 当前登录的组织
                Long thisOrgId = InvocationInfoProxy.getOrgId();
                // 单据中的组织
                Long orgId = vo.getOrgId();
                CommonResponse<OrgVO> oneById = iOrgApi.getOneById(orgId);
                if(!oneById.isSuccess() || oneById.getData() == null) {
                    return CommonResponse.error("查询组织信息失败！");
                }

                Boolean result = false;
                OrgVO data = oneById.getData();
                String innerCode = data.getInnerCode();
                String[] split = innerCode.split("\\|");
                for (String s : split) {
                    if(Long.valueOf(s).equals(thisOrgId)){
                        result = true;
                    }
                }
                if(!result){
                    return CommonResponse.error(vo.getCode()+",非本上组织不可操作！");
                }
            }
        }
        service.removeByIds(vos.stream().map(PriceDepotPowerSetVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PriceDepotPowerSetVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        Parameter orgIdValue = param.getParams().get("orgId");
        Long orgId = orgIdValue == null || orgIdValue.getValue() == null ? InvocationInfoProxy.getOrgId() : Long.valueOf(String.valueOf(orgIdValue.getValue()));
        List<Long> orgids = iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        CommonResponse<OrgVO> oneById = iOrgApi.getOneById(orgId);
        if(oneById.isSuccess() && oneById.getData() != null){
            OrgVO data = oneById.getData();
            String innerCode = data.getInnerCode();
            String[] split = innerCode.split("\\|");
            for (String s : split) {
                orgids.add(Long.valueOf(s));
            }
        }
        param.getParams().put("orgId", new Parameter(QueryParam.IN, orgids));
        param.getOrderMap().put("createTime", "desc");
        IPage<PriceDepotPowerSetEntity> page = service.queryPage(param,false);
        IPage<PriceDepotPowerSetVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<PriceDepotPowerSetVO> priceDepotPowerSetVOS = BeanMapper.mapList(page.getRecords(), PriceDepotPowerSetVO.class);
        priceDepotPowerSetVOS.forEach(item->{
            if(item.getPowerType() == 1){
                item.setPowerTypeName("价格保密");
            }
        });
        pageData.setRecords(priceDepotPowerSetVOS);
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<PriceDepotPowerSetEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("priceDepotPowerSet-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refpriceDepotPowerSetData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PriceDepotPowerSetVO>> refpriceDepotPowerSetData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                                 String condition,
                                                                                 String searchObject,
                                                                                 String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<PriceDepotPowerSetEntity> page = service.queryPage(param,false);
        IPage<PriceDepotPowerSetVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PriceDepotPowerSetVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
