package com.ejianc.foundation.share.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.foundation.share.bean.CustomerCategoryEntity;
import com.ejianc.foundation.share.bean.CustomerEntity;
import com.ejianc.foundation.share.bean.CustomerProEntity;
import com.ejianc.foundation.share.service.ICustomerCategoryService;
import com.ejianc.foundation.share.service.ICustomerProService;
import com.ejianc.foundation.share.service.ICustomerService;
import com.ejianc.foundation.share.vo.CustomerCategoryVO;
import com.ejianc.foundation.share.vo.CustomerVO;
import com.ejianc.foundation.share.vo.ShareCustomerVO;
import com.ejianc.foundation.support.vo.CustomerIncomeInfoVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@RestController
@RequestMapping("/api/shareCustomerApi/")
public class CustomerApi {

    @Autowired
    private ICustomerService customerService;
    @Autowired
    private ICustomerCategoryService customerCategoryService;

    @Autowired
    private ICustomerProService service;

    @GetMapping("findOneByName")
    public CommonResponse<CustomerVO> findOneByName(@RequestParam(value = "name") String name,
                                                    @RequestParam(value = "tenantId") Long tenantId) {
        CustomerVO vo = null;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("name", new Parameter(QueryParam.EQ, name));
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, tenantId));

        List<CustomerEntity> list = customerService.queryList(queryParam, false);
        if(CollectionUtils.isNotEmpty(list)) {
            vo = BeanMapper.map(list.get(0), CustomerVO.class);
        }

        return CommonResponse.success("查询成功！", vo);
    }

    /**
     * 根据客户Id查询客户信息
     *
     * @param id
     * @return
     */
    @GetMapping("queryById")
    CommonResponse<CustomerVO> detailById(@RequestParam(value = "id") Long id) {
        CustomerVO vo = customerService.queryDetail(id);
        return CommonResponse.success("查询成功！", vo);
    }

    @GetMapping("queryListByIds")
    CommonResponse<List<ShareCustomerVO>> detailsByIds(@RequestParam List<Long> ids) {
        QueryWrapper<CustomerEntity> query = new QueryWrapper<>();
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.in("id", ids);

        List<CustomerEntity> list = customerService.list(query);
        List<ShareCustomerVO> voList =BeanMapper.mapList(list, ShareCustomerVO.class);
        return CommonResponse.success("查询成功！", voList);
    }

    /**
     * 查询客户档案分类
     * @param tenantId
     * @return
     */
    @GetMapping("queryCategoryList")
    CommonResponse<List<CustomerCategoryVO>> queryCategoryList(@RequestParam(value = "tenantId") Long tenantId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, tenantId));

        List<CustomerCategoryEntity> list = customerCategoryService.queryList(queryParam);
        List<CustomerCategoryVO> voList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(list)) {
            voList = BeanMapper.mapList(list,CustomerCategoryVO.class);
        }
        return CommonResponse.success("查询成功！", voList);
    }

    /**
     * 修改客户累计金额信息
     * @param customerIncomeInfoVO
     * @return
     */
    @PostMapping("updateIncomeMny")
    CommonResponse<String> updateIncomeMny(@RequestBody CustomerIncomeInfoVO customerIncomeInfoVO){
        //判断顾客等级  5-10亿为大客户  >10亿为战略客户

        //普通客户 0<=mny<5亿
        //大客户  5亿<=mny<10亿
        //战略客户 10亿<=mny
        Integer level = 1;
        if (customerIncomeInfoVO.getSum() != null){
            if (customerIncomeInfoVO.getSum().compareTo(new BigDecimal(500000000) ) >= 0
                    && customerIncomeInfoVO.getSum().compareTo(new BigDecimal(1000000000) ) <0
            ){
                level = 2;
            }else if (customerIncomeInfoVO.getSum().compareTo(new BigDecimal(1000000000) ) >= 0){
                level = 3;
            }
        }
        //更新客户信息
        LambdaUpdateWrapper<CustomerProEntity> wrapper = new LambdaUpdateWrapper<>();
        wrapper.set(CustomerProEntity::getIncomeMny,customerIncomeInfoVO.getSum());
        wrapper.set(CustomerProEntity::getIncomeNum,customerIncomeInfoVO.getCount());
        wrapper.set(CustomerProEntity::getCustomerLevel,level);
        wrapper.eq(CustomerProEntity::getId,customerIncomeInfoVO.getCustomerId());
        service.update(wrapper);

        return CommonResponse.success("更新成功！");
    }
}
