package com.ejianc.foundation.share.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.share.bean.LabsubCategoryEntity;
import com.ejianc.foundation.share.bean.LabsubItemEntity;
import com.ejianc.foundation.share.bean.ProsubCategoryEntity;
import com.ejianc.foundation.share.service.ILabsubCategoryService;
import com.ejianc.foundation.share.service.ILabsubItemService;
import com.ejianc.foundation.share.service.IProsubCategoryService;
import com.ejianc.foundation.share.vo.LabsubCategoryVO;
import com.ejianc.foundation.share.vo.LabsubItemVO;
import com.ejianc.foundation.share.vo.ProsubCategoryVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@RequestMapping("/api/shareLabsubApi/")
public class LabsubApi {

    @Autowired
    private ILabsubItemService labsubItemService;

    @Autowired
    private ILabsubCategoryService service;
    @Autowired
    private IProsubCategoryService prosubCategoryService;
    /**
     * @Author xuannl
     * @Date 2022/04/18 根据id查询
     * @Param [id]
     * @Return
     */
    @GetMapping(value = "queryLabsubItemByIds")
    CommonResponse<List<LabsubItemVO>> queryLabsubItemByIds(@RequestParam(value = "ids") List<Long> ids){
        QueryWrapper<LabsubItemEntity> wrapper = new QueryWrapper<>();
        wrapper.in("id",ids);
        List<LabsubItemEntity> entitys = labsubItemService.list(wrapper);
        if(null != entitys && entitys.size() > 0){
            return CommonResponse.success(BeanMapper.mapList(entitys, LabsubItemVO.class));
        }
        return CommonResponse.error("查询失败,未查到相关数据。");
    };

    /**
     * 根据分类id查询分类信息
     * @Author zhangwx
     * @param id
     * @return
     */
    @GetMapping(value = "/queryLabSubByCategoryId")
    CommonResponse<LabsubCategoryVO> queryLabSubByCategoryId(@RequestParam(value = "id") Long id){
        LabsubCategoryVO vo = new LabsubCategoryVO();
        LabsubCategoryEntity entity = service.selectById(id);
        if (entity!=null){
           vo = BeanMapper.map(entity, LabsubCategoryVO.class);
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * 根据分类id查询分类信息
     * @Author zhangwx
     * @param id
     * @return
     */
    @GetMapping(value = "/queryMajorSubByCategoryId")
    CommonResponse<ProsubCategoryVO> queryMajorSubByCategoryId(@RequestParam(value = "id") Long id){
        ProsubCategoryVO vo=new ProsubCategoryVO();
        ProsubCategoryEntity prosubCategoryEntity = prosubCategoryService.selectById(id);
        if (prosubCategoryEntity!=null){
             vo = BeanMapper.map(prosubCategoryEntity, ProsubCategoryVO.class);
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    @GetMapping("queryCategoryListByIds")
    public CommonResponse<List<LabsubCategoryVO>> queryCategoryListByIds(@RequestParam(value = "ids") List<Long> ids) {
        List<LabsubCategoryVO> list = service.queryCategoryListByIds(ids);
        return CommonResponse.success("查询成功！", list);
    }

    @GetMapping("queryUnenabledCategoryListId")
    public CommonResponse<List<Long>> queryUnenabledCategoryListId() {
        List<Long> list = service.queryUnenabledCategoryListId();
        return CommonResponse.success("查询成功！", list);
    }
}
