package com.ejianc.foundation.share.controller.api;

import cn.hutool.json.JSONArray;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.share.bean.MaterialCategoryEntity;
import com.ejianc.foundation.share.bean.MaterialEntity;
import com.ejianc.foundation.share.bean.SupplierEntity;
import com.ejianc.foundation.share.controller.SteelMaterialCategoryController;
import com.ejianc.foundation.share.mapper.SteelMaterialCategoryMapper;
import com.ejianc.foundation.share.service.IMaterialCategoryService;
import com.ejianc.foundation.share.service.IMaterialService;
import com.ejianc.foundation.share.service.ISteelMaterialCategoryService;
import com.ejianc.foundation.share.service.ISteelMaterialService;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.share.vo.SteelVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.support.idworker.util.IdWorker;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

@RestController
@RequestMapping("/api/steelMaterialApiNoAuth/")
public class SteelMaterialApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private ISteelMaterialService materialService;
	@Autowired
	private ISteelMaterialCategoryService materialCategoryService;

    @Autowired
    private com.ejianc.foundation.share.controller.SteelMaterialCategoryController steelMaterialCategoryController;

    /**
     * @Description 钢构金蝶数据库同步
     * @param param
     * @Return void
     */
    @RequestMapping(value = "kisSteelSync", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody String param) {
        logger.info("同步钢构金蝶材料字典--开始！");
        logger.info("接收到参数:{}", param);
        // 使用JSONArray解析JSON字符串
        List<SteelVO> steelVOS = JSON.parseArray(param, SteelVO.class);
        List<Long> collect = steelVOS.stream().map(SteelVO::getFItemID).collect(Collectors.toList());
        //左侧树
        List<Long> collect1 = null;
        if (steelVOS.get(0).getFParentID() == 0) {
            List<MaterialCategoryVO> materialCategoryVOS = materialCategoryService.queryCategoryListByIds(collect);
            collect1 = materialCategoryVOS.stream().map(MaterialCategoryVO::getId).collect(Collectors.toList());
        }else {
            List<MaterialEntity> materialEntities = materialService.queryMaterialByIds(collect);
            collect1 =  materialEntities.stream().map(MaterialEntity::getId).collect(Collectors.toList());
        }
        collect.removeAll(collect1);
        if (collect.size() > 0) {
            logger.info("本次新增:{}", collect.size());
            Map<Long, SteelVO> collect2 = steelVOS.stream().collect(Collectors.toMap(SteelVO::getFItemID, Function.identity(), (key1, key2) -> key2));
            for (Long aLong : collect) {
                SteelVO steelVO = collect2.get(aLong);
                //左侧树
                if (steelVOS.get(0).getFParentID() == 0) {
                    MaterialCategoryVO materialCategoryVO = new MaterialCategoryVO();
                    materialCategoryVO.setId(steelVO.getFItemID());
                    if (steelVO.getFParentID() == 0) {
                        materialCategoryVO.setParentId(null);
                        materialCategoryVO.setInnerCode(steelVO.getFItemID() + "");
                    } else {
                        materialCategoryVO.setParentId(steelVO.getFParentID());
                        materialCategoryVO.setInnerCode(steelVO.getFParentID() + "|" + steelVO.getFItemID());
                    }
                    materialCategoryVO.setName(steelVO.getFFullName());
                    materialCategoryVO.setCode(steelVO.getFNumber());
                    //materialCategoryVO.setId(steelVO.getFModel());
                    saveOrUpdate(materialCategoryVO);
                } else {
                    //右侧表
                    MaterialVO materialVO = new MaterialVO();
                    materialVO.setId(steelVO.getFItemID());
                    materialVO.setCategoryId(steelVO.getFParentID());
                    materialVO.setName(steelVO.getFFullName());
                    materialVO.setCode(steelVO.getFNumber());
                    materialVO.setSpec(steelVO.getFModel());

                    materialVO.setOrgId(1406795679670312962L);//后期可以修改
                    materialVO.setUnitId(1506878704947564546L);//后期可以修改
                    materialVO.setUnitName("吨");//后期可以修改
                    materialVO.setProperty(1L);//后期可以修改
                    materialVO.setPropertyName("工程材料");//后期可以修改

                    saveOrUpdateMaterial(materialVO);


                }
            }

        }


    }

public void saveOrUpdate(@RequestBody MaterialCategoryVO materialCategoryVo){
    Long tenantId = InvocationInfoProxy.getTenantid();
    if (tenantId == null){
        tenantId = 999999L;
    }
        MaterialCategoryEntity entity = BeanMapper.map(materialCategoryVo, MaterialCategoryEntity.class);
        entity.setEnabled(1);
        entity.setCreateUserCode(InvocationInfoProxy.getUsercode());
        entity.setCreateTime(new Date());
        entity.setTenantId(tenantId);
        materialCategoryService.save(entity);

}
    public void saveOrUpdateMaterial(@RequestBody MaterialVO materialVo){
        materialVo.setCreateUserCode(InvocationInfoProxy.getUsercode());
        materialVo.setCreateTime(new Date());
        materialVo.setTenantId(999999L);
        materialVo.setEnabled(1);
        materialService.save(materialVo);
    }

    @PostMapping("queryExitFlag")
    public CommonResponse<MaterialVO> queryExitFlag(@RequestBody MaterialVO materialVO) {
    	MaterialVO vo = materialService.queryExitFlag(materialVO.getName(), materialVO.getSpec(), materialVO.getUnitName(), materialVO.getCategoryId());
    	return CommonResponse.success("查询成功！", vo);
    }
//    @PostMapping("queryExcelFlag")
//    public CommonResponse<List<MaterialVO>> queryExcelFlag(@RequestBody MaterialVO materialVO) {
//        List<MaterialVO> list = materialService.queryExcelFlag(materialVO.getName(), materialVO.getSpec(), materialVO.getUnitName(), materialVO.getCategoryName());
//        return CommonResponse.success("查询成功！", list);
//    }

    @GetMapping("queryCategoryByCode")
    public CommonResponse<MaterialCategoryVO> queryCategoryByCode(@RequestParam(value = "code") String code) {
        List<MaterialCategoryEntity> list = materialCategoryService.queryByCode(String.valueOf(code));
        MaterialCategoryVO vo = null;
        if(ListUtil.isNotEmpty(list)){
            vo = BeanMapper.map(list.get(0),MaterialCategoryVO.class);
        }
        if(vo == null){
            return CommonResponse.error("查询失败,没有查询到该编码所属分类！");
        }
    	return CommonResponse.success("查询成功！", vo);
    }

    @GetMapping("queryCategoryListByPid")
    public CommonResponse<List<MaterialCategoryVO>> queryCategoryListByPid(@RequestParam(value = "id") Long id) {
    	List<MaterialCategoryVO> list = materialCategoryService.queryListByPid(id);
    	return CommonResponse.success("查询成功！", list);
    }

    @GetMapping("queryCategoryAllListByPid")
    public CommonResponse<List<MaterialCategoryVO>> queryCategoryAllListByPid(@RequestParam(value = "id") Long id) {
        List<MaterialCategoryVO> list = materialCategoryService.queryListAllByPid(id);
        return CommonResponse.success("查询成功！", list);
    }

    @GetMapping("queryCategoryListByChildren")
    public CommonResponse<List<MaterialCategoryVO>> queryCategoryListByChildren(@RequestParam(value = "ids") List<Long> ids) {
        List<MaterialCategoryVO> list = materialCategoryService.queryCategoryListByChildren(ids);
        return CommonResponse.success("查询成功！", list);
    }

    /**
     * @Author mrsir_wxp
     * @Date 2020/10/19 根据sourceId查询物资
     * @Description queryMaterialBySourceId
     * @Param [sourceId]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.foundation.share.vo.MaterialVO>
     */
    @GetMapping("queryMaterialBySourceId")
    public CommonResponse<MaterialVO> queryMaterialBySourceId(String sourceId) {
        MaterialEntity entity = materialService.queryBySourceId(sourceId);
        if(entity!=null){
            return CommonResponse.success(BeanMapper.map(entity,MaterialVO.class));
        }
        return CommonResponse.error("查询失败,未查到相关物资。");
    }

	/**
	 * @Author liyj
	 * @Date 2020/10/29 根据ids查询物资列表（包括物资来源id，物资分类来源id）
	 * @Param [ids]
	 * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.foundation.share.vo.MaterialVO>
	 */
	@GetMapping(value = "queryMaterialByIds")
	CommonResponse<List<MaterialVO>> queryMaterialByIds(@RequestParam(value = "ids") List<Long> ids){
		List<MaterialEntity> entitys = materialService.queryMaterialByIds(ids);
        if(entitys!=null&&entitys.size()>0){
            return CommonResponse.success(BeanMapper.mapList(entitys,MaterialVO.class));
        }
        return CommonResponse.error("查询失败,未查到相关物资。");
	};

    /**
     * @Author xuannl
     * @Date 2022/04/18 根据id查询物资
     * @Param [id]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.foundation.share.vo.MaterialVO>
     */
    @GetMapping(value = "queryMaterialItemByIds")
    CommonResponse<List<MaterialVO>> queryMaterialItemByIds(@RequestParam(value = "ids") List<Long> ids){
        List<MaterialVO> materialVOS = materialService.queryItem(ids);
        if(null != materialVOS && materialVOS.size() > 0){
            return CommonResponse.success(materialVOS);
        }
        return CommonResponse.error("查询失败,未查到相关数据。");
    };

    /**
     * 根据主键查询物料分类详情
     * @Author zhangwx
     * @param id
     * @return
     */
    @GetMapping("queryCategoryById")
    public CommonResponse<MaterialCategoryVO> queryCategoryById(@RequestParam(value = "id") Long id) {
        return CommonResponse.success("查询成功！", materialCategoryService.queryDetail(id));
    }

    /**
     * 根据物资分类主键查询所有物料详情列表
     * @Author zhangwx
     * @param ids
     * @return
     */
    @PostMapping("queryMaterialByCategoryId")
    public CommonResponse<List<MaterialVO>> queryMaterialByCategoryId(@RequestBody List<Long> ids) {
        List<MaterialVO> res = new ArrayList<>();
        if(ListUtil.isNotEmpty(ids)){
            ids.forEach(id->{
                List<MaterialVO> materialVOS = materialService.queryListByCategoryId(id);
                if(ListUtil.isNotEmpty(materialVOS)){
                    res.addAll(materialVOS);
                }
            });
        }

        return CommonResponse.success("查询成功！", res);
    }

    /**
     * 根据编码查询物料详情
     * @Author liyongjia
     * @param code
     * @return
     */
    @GetMapping("queryMaterialByCode")
    public CommonResponse<MaterialVO> queryMaterialByCode(@RequestParam(value = "code") String code) {
        MaterialVO vo = materialService.queryByCode(String.valueOf(code));
        if(vo == null){
            return CommonResponse.error("查询失败,没有查询到该编码对应的物料！");
        }
    	return CommonResponse.success("查询成功！", vo);
    }

    /**
     * 根据材料主键查对应的所有上级分类
     * @return
     */
    @GetMapping("queryCategoryListByMaterialId")
    public CommonResponse<Map<Long,List<MaterialCategoryVO>>> queryCategoryListByMaterialId(@RequestParam(value = "ids") List<Long> ids) {
        Map<Long,List<MaterialCategoryVO>> map = materialCategoryService.queryCategoryListByMaterialId(ids);
        return CommonResponse.success("查询成功！", map);
    }

    @GetMapping("queryCategoryListByIds")
    public CommonResponse<List<MaterialCategoryVO>> queryCategoryListByIds(@RequestParam(value = "ids") List<Long> ids) {
        List<MaterialCategoryVO> list = materialCategoryService.queryCategoryListByIds(ids);
        return CommonResponse.success("查询成功！", list);
    }

    @GetMapping("queryUnenabledCategoryListId")
    public CommonResponse<List<Long>> queryUnenabledCategoryListId() {
        List<Long> list = materialCategoryService.queryUnenabledCategoryListId();
        return CommonResponse.success("查询成功！", list);
    }
}
