package com.ejianc.foundation.share.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.share.bean.EquipmentCategoryEntity;
import com.ejianc.foundation.share.bean.EquipmentEntity;
import com.ejianc.foundation.share.bean.MaterialCategoryEntity;
import com.ejianc.foundation.share.bean.MaterialEntity;
import com.ejianc.foundation.share.controller.param.YnsbjMaterialAndEquipCategoryParam;
import com.ejianc.foundation.share.controller.param.YnsbjMaterialAndEquipParam;
import com.ejianc.foundation.share.controller.resp.YnsbjDataInfo;
import com.ejianc.foundation.share.mapper.*;
import com.ejianc.foundation.share.service.IMaterialService;
import com.ejianc.foundation.share.service.ISteelMaterialService;
import com.ejianc.foundation.share.vo.EquipmentVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
@Transactional
public class SteelMaterialServiceImpl implements ISteelMaterialService {

	@Autowired
	private SteelMaterialMapper materialMapper;
	@Autowired
	private SteelMaterialCategoryMapper materialCategoryMapper;

	@Override
	public List<MaterialVO> queryListByCategoryId(Long categoryId) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		List<MaterialEntity> entities = materialMapper.queryListByCategoryId(tenantId, categoryId);
		if(entities != null && entities.size() > 0) {
			return BeanMapper.mapList(entities, MaterialVO.class);
		}
		return null;
	}

	@Override
	public CommonResponse updateByCategoryId(Long categoryId, Long subjectId, String subjectName) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		int i = materialMapper.updateByCategoryId(tenantId, categoryId, subjectId, subjectName);
		return CommonResponse.success();
	}

	@Override
	public CommonResponse updateCategoryCodeByCategoryId(Long categoryId, String categoryCode) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		int i = materialMapper.updateCategoryCodeByCategoryId(tenantId, categoryId, categoryCode);
		return CommonResponse.success();
	}

	@Override
	public void updateStateByCategoryId(List<Long> categoryIds, Integer state, Long tenantId) {
		materialMapper.updateStateByCategoryId(tenantId, categoryIds, state);
	}

	@Override
	public MaterialVO queryDetail(Long id) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		MaterialEntity entity = materialMapper.queryDetail(tenantId, id);
		if (entity != null) {
			return BeanMapper.map(entity, MaterialVO.class);
		}
		return null;
	}


	@Override
	public List<MaterialVO> queryItem(List<Long> ids) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		List<MaterialEntity> materialEntities = materialMapper.queryItem(tenantId, ids);
		if(materialEntities != null && materialEntities.size() > 0) {
			return BeanMapper.mapList(materialEntities, MaterialVO.class);
		}
		return null;
	}

	@Override
	public void update(MaterialVO uniqueBean) {
		materialMapper.update(uniqueBean);
	}

	@Override
	public void updateSubject(Long subjectId, String subjectName, List<Long> ids) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		List<MaterialEntity> materialEntities = materialMapper.queryMaterialByIds(ids,tenantId);
		List<MaterialVO> list = new ArrayList<>();
		materialEntities.forEach(entity -> list.add(BeanMapper.map(entity, MaterialVO.class)));
		list.forEach(vo -> {
			vo.setSubjectId(subjectId);
			vo.setSubjectName(subjectName);
		});
		list.forEach(vo -> {
			materialMapper.update(vo);
		});
	}

	@Override
	public void save(MaterialVO materialVo) {
		materialMapper.save(materialVo);
	}

	/**
	 * 批量保存
	 *
	 * @param materialVOList
	 */
	@Override
	public void insertBatch(List<MaterialVO> materialVOList) {
		if(ListUtil.isNotEmpty(materialVOList)){
			List<MaterialVO> toInsert = new ArrayList<>();
			for (MaterialVO materialVO : materialVOList) {
				if (toInsert.size()>0 && toInsert.size() % 1000 == 0) {
					materialMapper.insertBatch(InvocationInfoProxy.getTenantid(),toInsert);
					toInsert = new ArrayList<>();
				}
				toInsert.add(materialVO);
			}
			if(toInsert.size()>0){
				materialMapper.insertBatch(InvocationInfoProxy.getTenantid(),toInsert);
			}
		}
	}
	@Override
	public void amend(Long id,Long property,String propertyName) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		materialMapper.amend(id,property,propertyName,tenantId);
	}

	@Override
	public void delete(List<Long> ids) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		for(Long id:ids) {
			materialMapper.delete(tenantId, id);
		}
	}

	@Override
	public IPage<MaterialEntity> queryPage(QueryParam queryParam) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		Map<String, Parameter> paramMap = queryParam.getParams();

		Map<String, Object> condition = new HashMap<String, Object>();
		for(Map.Entry<String, Parameter> entry:paramMap.entrySet()) {
			if("categoryId".equals(entry.getKey())) {
				Parameter parameter = entry.getValue();
				if(StringUtils.isBlank(parameter.getValue()+"")) {
					continue;
				}
				Object value = parameter.getValue();
				if (value==null){
					continue;
				}
				MaterialCategoryEntity categoryEntity = materialCategoryMapper.queryDetail(tenantId, Long.parseLong(parameter.getValue().toString()));
				if(categoryEntity != null) {
					condition.put("innerCode", categoryEntity.getInnerCode());
				}
			}else{
				condition.put(entry.getKey(), entry.getValue().getValue());
			}
		}
		condition.put("pageIndex", (queryParam.getPageIndex()-1)*queryParam.getPageSize());
		condition.put("pageSize", queryParam.getPageSize());

		List<MaterialEntity> records = materialMapper.queryList(condition);
		Long count = materialMapper.queryCount(condition);

		IPage<MaterialEntity> page = new Page<>();
		page.setCurrent(queryParam.getPageIndex());
		page.setSize(queryParam.getPageSize());
		page.setTotal(count);
		page.setRecords(records);
		return page;
	}

	@Override
	public MaterialVO queryExitFlag(String name, String spec, String unitName, Long categoryId) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		MaterialVO materialVo = materialMapper.queryExitFlag(tenantId, name, spec, unitName, categoryId);
		return materialVo;
	}

	/**
	 * 根据code查询物料
	 *
	 * @param code
	 * @return
	 */
	@Override
	public MaterialVO queryByCode(String code) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		return materialMapper.queryByCode(tenantId, code);
	}

	@Override
	public List<MaterialEntity> queryList(QueryParam queryParam) {
		Map<String, Parameter> paramMap = queryParam.getParams();

		Map<String, Object> condition = new HashMap<String, Object>();
		for(Map.Entry<String, Parameter> entry:paramMap.entrySet()) {
			condition.put(entry.getKey(), entry.getValue().getValue());
		}
		List<MaterialEntity> records = materialMapper.queryExportList(condition);
		return records;
	}

	@Override
	public void insertMaterialListFromPlatform() {
		Long tenantId = InvocationInfoProxy.getTenantid();
		materialMapper.insertMaterialListFromPlatform(tenantId);
	}

	@Override
	public IPage<MaterialVO> queryRefMaterialPage(Map<String, Object> params) {
		List<MaterialEntity> dataList = materialMapper.queryRefMaterialList(params);
		Long dataCount = materialMapper.queryRefMaterialCount(params);
		List<MaterialVO> materialVOS = BeanMapper.mapList(dataList, MaterialVO.class);
		IPage<MaterialVO> page = new Page<>();
		page.setRecords(materialVOS);

		page.setTotal(dataCount);
		return page;
	}

	@Override
	public IPage<MaterialVO> queryRefMaterialPageZzyj(Map<String, Object> params) {
		List<MaterialEntity> dataList = materialMapper.queryRefMaterialListZzyj(params);
		Long dataCount = materialMapper.queryRefMaterialCountZzyj(params);
		List<MaterialVO> materialVOS = BeanMapper.mapList(dataList, MaterialVO.class);
		IPage<MaterialVO> page = new Page<>();
		page.setRecords(materialVOS);

		page.setTotal(dataCount);
		return page;
	}

	@Override
	public MaterialEntity queryBySourceId(String sourceId) {
		return materialMapper.queryBySourceId(sourceId,InvocationInfoProxy.getTenantid());
	}

	@Override
	public List<MaterialEntity> queryMaterialByIds(List<Long> ids) {
		Long tenantid = InvocationInfoProxy.getTenantid();
		if (tenantid==null){
			tenantid = 999999L;
		}
		return materialMapper.queryMaterialByIds(ids,tenantid);
	}

}
