package com.ejianc.foundation.support.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.foundation.share.bean.SupplierEntity;
import com.ejianc.foundation.share.service.ISupplierService;
import com.ejianc.foundation.share.service.ISupplyBankService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.bean.BankAccountEntity;
import com.ejianc.foundation.support.bean.BankCategoryEntity;
import com.ejianc.foundation.support.bean.BankEntity;
import com.ejianc.foundation.support.mapper.BankAccountMapper;
import com.ejianc.foundation.support.service.IBankAccountService;
import com.ejianc.foundation.support.service.IBankCategoryService;
import com.ejianc.foundation.support.service.IBankService;
import com.ejianc.foundation.support.vo.BankAccountVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 银行账户实体
 *
 * @author generator
 */
@Service("bankAccountService")
public class BankAccountServiceImpl extends BaseServiceImpl<BankAccountMapper, BankAccountEntity> implements IBankAccountService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String BILL_TYPE_CODE = "BT211028000000001";

    @Autowired
    private IBankService bankService;

    @Autowired
    private IBankCategoryService categoryService;

    @Autowired
    private ISupplierService supplierService;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IBillTypeApi billTypeApi;

    @Autowired
    private ISupplyBankService supplyBankService;

    @Override
    public BankAccountVO insertOrUpdate(BankAccountVO saveorUpdateVO) {
        BankAccountEntity entity = BeanMapper.map(saveorUpdateVO, BankAccountEntity.class);
        Long id = entity.getId();
        Long supplierId = entity.getSupplierId();
        // 银行账户唯一性校验
        if (StringUtils.isNotEmpty(entity.getBankCode())) {
            QueryWrapper<BankAccountEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("bank_code", entity.getBankCode());
            queryWrapper.ne(id != null, "id", id);
            int count = this.count(queryWrapper);
            if (count > 0) {
                throw new BusinessException("保存失败！银行账号已存在");
            }
        }

        QueryWrapper<BankAccountEntity> defaultWrapper = new QueryWrapper<>();
        defaultWrapper.eq("supplier_id", supplierId);
        defaultWrapper.ne(id != null, "id", id);
        int count = this.count(defaultWrapper);
        if (count > 9) {
            throw new BusinessException("保存失败！该供应商名下账户已超过10个！");
        }

        SupplierEntity supplierEntity = supplierService.selectById(supplierId);

        // 内部单位
        if (supplierEntity == null) {
            throw new BusinessException("未在供应商库查询到该供应商/客户/客商");
        } else {
            entity.setSupplierName(supplierEntity.getName());
            entity.setSupplierFlag(supplierEntity.getSupplierFlag());
            entity.setInsideState(supplierEntity.getInsideOrg()!=null&&supplierEntity.getInsideOrg() ? 1 : 0);
        }

        QueryWrapper<BankAccountEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("supplier_id", supplierId);
        wrapper.eq("default_flag", 1);
        wrapper.ne(id != null, "id", id);
        int count1 = super.count(wrapper);
        entity.setDefaultFlag(count1 == 0 ? 1 : 0);
        if (entity.getDefaultFlag() == 1 && entity.getEnabled() != 1) {
            throw new BusinessException("供应商默认账户的启动状态不可修改！");
        }

        if (entity.getEnabled() == null) {
            entity.setEnabled(1);
        }
        if (entity.getEnableUserId() == null) {
            entity.setEnableUserId(InvocationInfoProxy.getUserid());
            entity.setEnableUserName(sessionManager.getUserContext().getUserName());
            entity.setEnableTime(new Date());
        }
        //补录银行类别编码
        Long categoryId = entity.getCategoryId();
        if (categoryId != null) {
            BankCategoryEntity byId = categoryService.getById(categoryId);
            entity.setCategoryCode(byId != null ? byId.getCode() : entity.getCategoryCode());
        }
        super.saveOrUpdate(entity, false);

        //同步至主数据
        supplyBankService.syncMdmBankInfoZzyj(Arrays.asList(entity.getId()));

        BankAccountVO vo = BeanMapper.map(entity, BankAccountVO.class);
        return vo;
    }

    @Override
    public String delete(List<Long> ids) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id", new Parameter(QueryParam.IN, ids));
        List<BankAccountEntity> list = super.queryList(queryParam);
        for (BankAccountEntity entity : list) {
            if (NumberUtils.INTEGER_ONE.equals(entity.getDefaultFlag())) {
                throw new BusinessException("【" + entity.getBankCode() + "】为默认银行账户，不允许删除！");
            }
        }
        Map<Long, BankAccountEntity> map = list.stream().collect(Collectors.toMap(BankAccountEntity::getId, Function.identity()));
        for (Long id : ids) {
            if (!map.containsKey(id)) {
                continue;
            }
            BankAccountEntity data = map.get(id);
            CommonResponse<String> res = billTypeApi.checkQuote(BILL_TYPE_CODE, id);
            logger.info("平台返回查询被引用情况" + res.isSuccess() + "----" + res.getMsg());
            if (!res.isSuccess()) {
                throw new BusinessException("删除失败！银行账户【" + data.getBankCode() + "】已使用，不允许删除！");
            }
            // 供应商或者客户删除银行账户，如果默认账户，且只有一条数据，允许删除，否则不能删除，非内部客商的内部账户没有默认
            if (NumberUtils.INTEGER_ONE.equals(data.getDefaultFlag())) {
                QueryParam param = new QueryParam();
                if (data.getSupplierId() != null) {
                    param.getParams().put("supplierId", new Parameter(QueryParam.EQ, data.getSupplierId()));
                }
                if (MapUtils.isNotEmpty(param.getParams())) {
                    param.getParams().put("id", new Parameter(QueryParam.NOT_IN, ids));
                    List<BankAccountEntity> dataList = super.queryList(param);
                    if (CollectionUtils.isNotEmpty(dataList)) {
                        throw new BusinessException("删除失败！银行账户【" + data.getBankCode() + "】为默认账户，且非档案下唯一账户，不允许删除！");
                    }
                }
            }
        }
        super.removeByIds(ids, true);

        //同步至主数据
        supplyBankService.syncMdmBankInfoZzyj(ids);

        return "删除成功！";
    }

    @Override
    public String delBySuppAndCustomIds(String type, List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new BusinessException("未选择单据");
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id", new Parameter(QueryParam.IN, ids));
        List<BankAccountEntity> list = super.queryList(queryParam);
        List<Long> delIds = new ArrayList<>();
        for (BankAccountEntity entity : list) {
            CommonResponse<String> res = billTypeApi.checkQuote(BILL_TYPE_CODE, entity.getId());
            logger.info("平台返回查询被引用情况" + res.isSuccess() + "----" + res.getMsg());
            if (!res.isSuccess()) {
                throw new BusinessException("删除失败！银行账户【" + entity.getBankCode() + "】已使用，不允许删除！");
            }
            delIds.add(entity.getId());
        }
        if (CollectionUtils.isNotEmpty(delIds)) {
            super.removeByIds(delIds, true);


            //同步至主数据
            supplyBankService.syncMdmBankInfoZzyj(delIds);
        }
        return "删除成功！";
    }


    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        JSONObject resp = new JSONObject();

        if (isFailed) {
            return CommonResponse.error("文件格式不合法！");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                if (result.size() > 10000) {
                    return CommonResponse.error("超过10000条，请分批上传！");
                }
                // 处理导入文件
                Map<String, Integer> indexMap = new HashMap<>();
                List<BankAccountVO> voList = new ArrayList<>();
                HashMap<String, Integer> countMap = new HashMap<>();
                HashMap<String, String> defaultFlagMap = new HashMap<>();
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    BankAccountVO vo = new BankAccountVO();
                    vo.setId(IdWorker.getId());
                    String warnType = "";

                    String supplierName = datas.get(0);
                    String supplierCode = datas.get(1);
                    String bankCode = datas.get(2);

                    if (StringUtils.isEmpty(supplierName)) {// 户名为空
                        vo.setSupplierName(null);
                        warnType = warnType + "[供应商/客户/客商名称为空]";
                    } else {
                        vo.setSupplierName(supplierName.trim());
                    }
                    if (StringUtils.isEmpty(supplierCode)) {// 户名为空
                        vo.setSupplierCode(null);
                        warnType = warnType + "[供应商/客户/客商编码为空]";
                    } else {
                        vo.setSupplierCode(supplierCode.trim());
                    }
                    if (StringUtils.isEmpty(bankCode)) {
                        vo.setBankCode(null);
                        warnType = warnType + "[供应商/客户/客商账户为空]";
                    } else {
                        vo.setBankCode(bankCode);
                        if (indexMap.containsKey(bankCode)) {//账号重复
                            return CommonResponse.error("第" + (i + 2) + "行账号和第" + (indexMap.get(bankCode) + 2) + "行重复");
                        } else {
                            indexMap.put(bankCode, i);
                        }
                    }

                    if (StringUtils.isEmpty(datas.get(3))) {// 户名为空
                        vo.setBankAccount(null);
                        warnType = warnType + "[户名为空]";
                    } else {
                        vo.setBankAccount(datas.get(3).trim());
                    }

                    if (StringUtils.isEmpty(datas.get(4))) {//开户银行为空
                        vo.setBankName(null);
                        warnType = warnType + "[开户银行为空]";
                    } else {
                        vo.setBankName(datas.get(4).trim());
                    }

                    if (StringUtils.isEmpty(datas.get(5))) {//银行类别为空
                        vo.setCategoryName(null);
                        warnType = warnType + "[银行类别为空]";
                    } else {
                        vo.setCategoryName(datas.get(5).trim());
                    }

                    vo.setMemo(datas.get(6));// 备注

                    vo.setDefaultFlagName(datas.get(7));// 是否默认名称
                    if (StringUtils.isEmpty(datas.get(7))) {// 默认为空
                        vo.setDefaultFlag(0);
                        warnType = warnType + "[默认不能为空]";
                    } else {
                        if ("是".equals(datas.get(7))) {
                            vo.setDefaultFlag(1);
                            // 同一个客户只能有一个为默认
                            String str = defaultFlagMap.get(supplierCode);
                            if (StringUtils.isNotEmpty(str)) {
                                warnType = warnType + "['" + supplierName + "'只能有一条默认账户]";
                            } else {
                                defaultFlagMap.put(supplierCode, supplierCode);
                            }
                        } else {
                            vo.setDefaultFlag(0);
                        }
                    }

                    // 校验数量
                    Integer count = countMap.get(supplierCode) != null ? countMap.get(supplierCode) : 0;
                    if (count > 10) {
                        warnType = warnType + "['" + supplierName + "'累计账户超过10个！]";
                    } else {
                        count++;
                    }

                    countMap.put(supplierCode, count);

                    vo.setWarnType(warnType);
                    vo.setRowState("add");
                    voList.add(vo);
                }

                // 根据数据库赋值校验
                this.validate(voList, defaultFlagMap, countMap, true);

                // 处理成功列表和失败列表
                List<BankAccountVO> successList = new ArrayList<>();
                List<BankAccountVO> errorList = new ArrayList<>();
                if (CollectionUtils.isNotEmpty(voList)) {
                    voList.forEach(vo -> {
                        if (StringUtils.isEmpty(vo.getWarnType())) {
                            successList.add(vo);
                        } else {
                            errorList.add(vo);
                        }
                    });
                }
                resp.put("successList", successList);
                resp.put("errorList", errorList);
                resp.put("successNum", successList.size());
                resp.put("errorNum", errorList.size());
                return CommonResponse.success(resp);
            }
            return CommonResponse.error("Excel为空");
        }
    }


    @Override
    public String saveImportExcel(HttpServletRequest request, List<BankAccountVO> importVOS) {
        if (ListUtil.isEmpty(importVOS)) {
            throw new BusinessException("导入的数据为空！");
        }

        List<BankAccountEntity> list = new ArrayList<>();
        for (BankAccountVO importVO : importVOS) {
            importVO.setEnabled(1);
            importVO.setEnableUserId(InvocationInfoProxy.getUserid());
            importVO.setEnableUserName(sessionManager.getUserContext().getUserName());
            importVO.setEnableTime(new Date());
            list.add(BeanMapper.map(importVO, BankAccountEntity.class));
        }
        if (CollectionUtils.isNotEmpty(list)) {
            super.saveOrUpdateBatch(list);
        }
        return "保存成功！";
    }

    @Override
    public String enabled(List<BankAccountVO> vos) {
        if (CollectionUtils.isEmpty(vos)) {
            return "未选择单据！";
        }
        List<Long> ids = vos.stream().map(BankAccountVO::getId).collect(Collectors.toList());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id", new Parameter(QueryParam.IN, ids));
        List<BankAccountEntity> entityList = super.queryList(queryParam);
        for (BankAccountEntity entity : entityList) {
            if (!NumberUtils.INTEGER_ONE.equals(vos.get(0).getEnabled()) && NumberUtils.INTEGER_ONE.equals(entity.getDefaultFlag())) {
                throw new BusinessException("【" + entity.getBankCode() + "】为默认银行账户，不允许停用！");
            }
            // 启用/停用
            Integer enabled = vos.get(0).getEnabled();
            entity.setEnabled(enabled);
            if (enabled == 1) {
                entity.setEnableUserId(InvocationInfoProxy.getUserid());
                entity.setEnableUserName(sessionManager.getUserContext().getUserName());
                entity.setEnableTime(new Date());
            }
            if (enabled == 0) {
                entity.setUnenableUserId(InvocationInfoProxy.getUserid());
                entity.setUnenableUserName(sessionManager.getUserContext().getUserName());
                entity.setUnenableTime(new Date());
            }
        }
        if (CollectionUtils.isNotEmpty(entityList)) {
            super.saveOrUpdateBatch(entityList);
        }
        return "操作成功！";
    }

    @Override
    public String defaultFlag(BankAccountVO vo) {
        BankAccountEntity entity = super.selectById(vo.getId());
        if (!NumberUtils.INTEGER_ONE.equals(vo.getDefaultFlag()) && !NumberUtils.INTEGER_ONE.equals(entity.getDefaultFlag())) {
            throw new BusinessException("已经为非默认银行账户！");
        }
        if (NumberUtils.INTEGER_ONE.equals(vo.getDefaultFlag()) && NumberUtils.INTEGER_ONE.equals(entity.getDefaultFlag())) {
            throw new BusinessException("已经为默认银行账户！");
        }
        if (!NumberUtils.INTEGER_ONE.equals(vo.getDefaultFlag()) && NumberUtils.INTEGER_ONE.equals(entity.getDefaultFlag())) {
            throw new BusinessException("至少有一个为默认银行账户！");
        }
        if (NumberUtils.INTEGER_ONE.equals(vo.getDefaultFlag()) && !NumberUtils.INTEGER_ONE.equals(entity.getEnabled())) {
            throw new BusinessException("该银行账户已停用！");
        }
        // 处理默认
        QueryParam param = new QueryParam();
        if (entity.getSupplierId() != null) {
            param.getParams().put("supplierId", new Parameter(QueryParam.EQ, entity.getSupplierId()));
        }
        param.getParams().put("defaultFlag", new Parameter(QueryParam.EQ, 1));
        List<BankAccountEntity> dataList = super.queryList(param);
        if (NumberUtils.INTEGER_ONE.equals(vo.getDefaultFlag()) && CollectionUtils.isNotEmpty(dataList)) {// 如果引入有默认，把之前的默认修改
            dataList.forEach(x -> {
                x.setDefaultFlag(0);
            });
            super.saveOrUpdateBatch(dataList);
        }
        entity.setDefaultFlag(1);
        super.saveOrUpdate(entity, false);
        return "操作成功！";
    }

    /**
     * 根据数据库赋值校验
     *
     * @param voList
     * @param defaultFlagMap
     * @param countMap
     * @return
     */
    public void validate(List<BankAccountVO> voList, HashMap<String, String> defaultFlagMap, HashMap<String, Integer> countMap, boolean isValidateDefaultAndCount) {
        // 查询数据库
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("bankCode", new Parameter(QueryParam.IN, voList.stream().map(BankAccountVO::getBankCode).distinct().collect(Collectors.toList())));
        List<BankAccountEntity> dataList = super.queryList(queryParam);
        List<String> bankCodes = dataList.stream().map(BankAccountEntity::getBankCode).distinct().collect(Collectors.toList());

        QueryParam queryParam2 = new QueryParam();
        queryParam2.getParams().put("name", new Parameter(QueryParam.IN, voList.stream().map(BankAccountVO::getBankName).distinct().collect(Collectors.toList())));
        List<BankEntity> bankList = bankService.queryList(queryParam2);
        Map<String, BankEntity> bankMap = bankList.stream().collect(Collectors.toMap(x -> x.getName() + "-" + x.getBankCategoryName(), Function.identity(), (x1, x2) -> x1));

        QueryParam queryParam3 = new QueryParam();
        queryParam3.getParams().put("name", new Parameter(QueryParam.IN, voList.stream().map(BankAccountVO::getCategoryName).distinct().collect(Collectors.toList())));
        List<BankCategoryEntity> categoryList = categoryService.queryList(queryParam3);
        Map<String, BankCategoryEntity> categoryMap = categoryList.stream().collect(Collectors.toMap(x -> x.getName(), Function.identity(), (x1, x2) -> x1));

        Map<String, SupplierEntity> supplierMapTemp = new HashMap<>();

        List<String> collect1 = voList.stream().filter(t -> t.getSupplierCode() != null).map(BankAccountVO::getSupplierCode).distinct().collect(Collectors.toList());
        if (collect1.size() > 0) {
            QueryParam queryParam5 = new QueryParam();
            queryParam5.getParams().put("code", new Parameter(QueryParam.IN, voList.stream().filter(t -> t.getSupplierCode() != null).map(BankAccountVO::getSupplierCode).distinct().collect(Collectors.toList())));
            List<SupplierEntity> supplierEntities = supplierService.queryList(queryParam5);
            supplierMapTemp = supplierEntities.stream().collect(Collectors.toMap(x -> x.getCode(), Function.identity(), (x1, x2) -> x1));
        }
        Map<String, SupplierEntity> supplierMap = supplierMapTemp;
        if (CollectionUtils.isNotEmpty(voList)) {
            voList.forEach(vo -> {
                // 校验账户是否存在
                if (bankCodes.contains(vo.getBankCode())) {
                    vo.setWarnType(vo.getWarnType() + "[银行账号'" + vo.getBankCode() + "'已存在]");
                }
                // 添加银行分类主键
                if (categoryMap.containsKey(vo.getCategoryName())) {
                    BankCategoryEntity bankCategoryEntity = categoryMap.get(vo.getCategoryName());
                    vo.setCategoryId(bankCategoryEntity.getId());
                    vo.setCategoryCode(bankCategoryEntity.getCode());
                    vo.setCategoryName(bankCategoryEntity.getName());
                } else {
                    vo.setWarnType(vo.getWarnType() + "[银行类别'" + vo.getCategoryName() + "'不存在]");
                }
                // 添加银行档案主键
                if (bankMap.containsKey(vo.getBankName() + "-" + vo.getCategoryName())) {
                    BankEntity bankEntity = bankMap.get(vo.getBankName() + "-" + vo.getCategoryName());
                    vo.setBankId(bankEntity.getId());
                    vo.setBankNum(bankEntity.getCode());
                    vo.setBankName(bankEntity.getName());
                    vo.setBankAddress(bankEntity.getAddress());
                } else {
                    vo.setWarnType(vo.getWarnType() + "[银行档案'" + vo.getBankName() + "'不存在]");
                }
                String supplierCode = vo.getSupplierCode();
                // 校验供应商是否存在
                if (StringUtils.isNotEmpty(supplierCode)) {
                    if (supplierMap.containsKey(supplierCode)) {
                        SupplierEntity supplierEntity = supplierMap.get(supplierCode);
                        vo.setSupplierId(supplierEntity.getId());
                        vo.setSupplierFlag(supplierEntity.getSupplierFlag());
                        vo.setInsideState(supplierEntity.getInsideOrg() ? 1 : 0);
                        vo.setOrgId(supplierEntity.getOrgId());
                        vo.setOrgName(supplierEntity.getOrgName());
                    } else {
                        vo.setWarnType(vo.getWarnType() + "[编码为'" + supplierCode + "'的供应商/客户/客商不存在]");
                    }
                }

                if(isValidateDefaultAndCount){
                    QueryWrapper<BankAccountEntity> wrapper = new QueryWrapper<>();
                    wrapper.eq("supplier_code", supplierCode);
                    int count = super.count(wrapper);
                    Integer importCount = countMap.get(supplierCode);
                    if ((importCount + count) > 10) {
                        vo.setWarnType("['" + vo.getSupplierName() + "'累计账户超过10个！]");
                    }

                    // 同一个客户只能有一个为默认
                    String str = defaultFlagMap.get(supplierCode);
                    if (StringUtils.isNotEmpty(str)) {
                        QueryWrapper<BankAccountEntity> defaultWrapper = new QueryWrapper<>();
                        defaultWrapper.eq("supplier_code", supplierCode);
                        defaultWrapper.eq("default_flag", 1);
                        int defaultCount = super.count(defaultWrapper);
                        if (defaultCount > 0) {
                            vo.setWarnType("['" + vo.getSupplierName() + "'只能有一个默认账户！]");
                        }
                    }
                }


            });
        }
    }
}
