package com.ejianc.foundation.share.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.share.bean.EquipmentCategoryEntity;
import com.ejianc.foundation.share.bean.EquipmentEntity;
import com.ejianc.foundation.share.bean.MaterialCategoryEntity;
import com.ejianc.foundation.share.bean.MaterialEntity;
import com.ejianc.foundation.share.controller.param.YnsbjMaterialAndEquipCategoryParam;
import com.ejianc.foundation.share.controller.param.YnsbjMaterialAndEquipParam;
import com.ejianc.foundation.share.controller.resp.YnsbjDataInfo;
import com.ejianc.foundation.share.mapper.EquipmentCategoryMapper;
import com.ejianc.foundation.share.mapper.EquipmentMapper;
import com.ejianc.foundation.share.mapper.MaterialCategoryMapper;
import com.ejianc.foundation.share.mapper.MaterialMapper;
import com.ejianc.foundation.share.service.IMaterialService;
import com.ejianc.foundation.share.vo.EquipmentVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
@Transactional
public class MaterialServiceImpl implements IMaterialService {

	@Autowired
	private MaterialMapper materialMapper;
	@Autowired
	private EquipmentMapper equipmentMapper;
	@Autowired
	private MaterialCategoryMapper materialCategoryMapper;
	@Autowired
	private EquipmentCategoryMapper equipmentCategoryMapper;

	@Override
	public List<MaterialVO> queryListByCategoryId(Long categoryId) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		List<MaterialEntity> entities = materialMapper.queryListByCategoryId(tenantId, categoryId);
		if(entities != null && entities.size() > 0) {
			return BeanMapper.mapList(entities, MaterialVO.class);
		}
		return null;
	}

	@Override
	public CommonResponse updateByCategoryId(Long categoryId, Long subjectId, String subjectName) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		int i = materialMapper.updateByCategoryId(tenantId, categoryId, subjectId, subjectName);
		return CommonResponse.success();
	}

	@Override
	public CommonResponse updateCategoryCodeByCategoryId(Long categoryId, String categoryCode) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		int i = materialMapper.updateCategoryCodeByCategoryId(tenantId, categoryId, categoryCode);
		return CommonResponse.success();
	}

	@Override
	public void updateStateByCategoryId(List<Long> categoryIds, Integer state, Long tenantId) {
		materialMapper.updateStateByCategoryId(tenantId, categoryIds, state);
	}

	@Override
	public MaterialVO queryDetail(Long id) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		MaterialEntity entity = materialMapper.queryDetail(tenantId, id);
		if (entity != null) {
			return BeanMapper.map(entity, MaterialVO.class);
		}
		return null;
	}


	@Override
	public List<MaterialVO> queryItem(List<Long> ids) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		List<MaterialEntity> materialEntities = materialMapper.queryItem(tenantId, ids);
		if(materialEntities != null && materialEntities.size() > 0) {
			return BeanMapper.mapList(materialEntities, MaterialVO.class);
		}
		return null;
	}

	@Override
	public void update(MaterialVO uniqueBean) {
		materialMapper.update(uniqueBean);
	}

	@Override
	public void updateSubject(Long subjectId, String subjectName, List<Long> ids) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		List<MaterialEntity> materialEntities = materialMapper.queryMaterialByIds(ids,tenantId);
		List<MaterialVO> list = new ArrayList<>();
		materialEntities.forEach(entity -> list.add(BeanMapper.map(entity, MaterialVO.class)));
		list.forEach(vo -> {
			vo.setSubjectId(subjectId);
			vo.setSubjectName(subjectName);
		});
		list.forEach(vo -> {
			materialMapper.update(vo);
		});
	}

	@Override
	public void save(MaterialVO materialVo) {
		materialMapper.save(materialVo);
	}

	/**
	 * 批量保存
	 *
	 * @param materialVOList
	 */
	@Override
	public void insertBatch(List<MaterialVO> materialVOList) {
		if(ListUtil.isNotEmpty(materialVOList)){
			List<MaterialVO> toInsert = new ArrayList<>();
			for (MaterialVO materialVO : materialVOList) {
				if (toInsert.size()>0 && toInsert.size() % 1000 == 0) {
					materialMapper.insertBatch(InvocationInfoProxy.getTenantid(),toInsert);
					toInsert = new ArrayList<>();
				}
				toInsert.add(materialVO);
			}
			if(toInsert.size()>0){
				materialMapper.insertBatch(InvocationInfoProxy.getTenantid(),toInsert);
			}
		}
	}
	@Override
	public void amend(Long id,Long property,String propertyName) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		materialMapper.amend(id,property,propertyName,tenantId);
	}

	@Override
	public void delete(List<Long> ids) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		for(Long id:ids) {
			materialMapper.delete(tenantId, id);
		}
	}

	@Override
	public IPage<MaterialEntity> queryPage(QueryParam queryParam) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		Map<String, Parameter> paramMap = queryParam.getParams();

		Map<String, Object> condition = new HashMap<String, Object>();
		for(Map.Entry<String, Parameter> entry:paramMap.entrySet()) {
			if("categoryId".equals(entry.getKey())) {
				Parameter parameter = entry.getValue();
				if(StringUtils.isBlank(parameter.getValue()+"")) {
					continue;
				}
				Object value = parameter.getValue();
				if (value==null){
					continue;
				}
				MaterialCategoryEntity categoryEntity = materialCategoryMapper.queryDetail(tenantId, Long.parseLong(parameter.getValue().toString()));
				if(categoryEntity != null) {
					condition.put("innerCode", categoryEntity.getInnerCode());
				}
			}else{
				condition.put(entry.getKey(), entry.getValue().getValue());
			}
		}
		condition.put("pageIndex", (queryParam.getPageIndex()-1)*queryParam.getPageSize());
		condition.put("pageSize", queryParam.getPageSize());

		List<MaterialEntity> records = materialMapper.queryList(condition);
		Long count = materialMapper.queryCount(condition);

		IPage<MaterialEntity> page = new Page<>();
		page.setCurrent(queryParam.getPageIndex());
		page.setSize(queryParam.getPageSize());
		page.setTotal(count);
		page.setRecords(records);
		return page;
	}

	@Override
	public MaterialVO queryExitFlag(String name, String spec, String unitName, Long categoryId) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		MaterialVO materialVo = materialMapper.queryExitFlag(tenantId, name, spec, unitName, categoryId);
		return materialVo;
	}

	@Override
	public List<MaterialVO> queryExcelFlag(String name, String spec, String unitName, String categoryName) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		List<MaterialVO> list = materialMapper.queryExcelFlag(tenantId, name, spec, unitName, categoryName);
		return list;
	}

	/**
	 * 根据code查询物料
	 *
	 * @param code
	 * @return
	 */
	@Override
	public MaterialVO queryByCode(String code) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		return materialMapper.queryByCode(tenantId, code);
	}

	@Override
	public List<MaterialEntity> queryList(QueryParam queryParam) {
		Map<String, Parameter> paramMap = queryParam.getParams();

		Map<String, Object> condition = new HashMap<String, Object>();
		for(Map.Entry<String, Parameter> entry:paramMap.entrySet()) {
			condition.put(entry.getKey(), entry.getValue().getValue());
		}
		List<MaterialEntity> records = materialMapper.queryExportList(condition);
		return records;
	}

	@Override
	public void insertMaterialListFromPlatform() {
		Long tenantId = InvocationInfoProxy.getTenantid();
		materialMapper.insertMaterialListFromPlatform(tenantId);
	}

	@Override
	public IPage<MaterialVO> queryRefMaterialPage(Map<String, Object> params) {
		List<MaterialEntity> dataList = materialMapper.queryRefMaterialList(params);
		Long dataCount = materialMapper.queryRefMaterialCount(params);
		List<MaterialVO> materialVOS = BeanMapper.mapList(dataList, MaterialVO.class);
		IPage<MaterialVO> page = new Page<>();
		page.setRecords(materialVOS);

		page.setTotal(dataCount);
		return page;
	}

	@Override
	public IPage<MaterialVO> queryRefMaterialPageZzyj(Map<String, Object> params) {
		List<MaterialEntity> dataList = materialMapper.queryRefMaterialListZzyj(params);
		Long dataCount = materialMapper.queryRefMaterialCountZzyj(params);
		List<MaterialVO> materialVOS = BeanMapper.mapList(dataList, MaterialVO.class);
		IPage<MaterialVO> page = new Page<>();
		page.setRecords(materialVOS);

		page.setTotal(dataCount);
		return page;
	}

	@Override
	public MaterialEntity queryBySourceId(String sourceId) {
		return materialMapper.queryBySourceId(sourceId,InvocationInfoProxy.getTenantid());
	}

	@Override
	public List<MaterialEntity> queryMaterialByIds(List<Long> ids) {
		return materialMapper.queryMaterialByIds(ids,InvocationInfoProxy.getTenantid());
	}

	@Override
	public IPage<MaterialEntity> queryZjwjRefMaterialPage(Map<String, Object> params) {
		IPage<MaterialEntity> page = new Page<>();
		if (params.containsKey("sourceOrgId") && null !=params.get("sourceOrgId")) {
			List<MaterialEntity> dataList = materialMapper.queryZjwjRefMaterialList(params);
			Long dataCount = materialMapper.queryZjwjRefMaterialCount(params);
			page.setRecords(dataList);
			page.setTotal(dataCount);
		}
		return page;
	}

	/**
	 * 保存或修改物料和设备分类
	 * 
	 * @param categoryParam
	 * @return
	 */
	@Override
	public YnsbjDataInfo saveOrUpdateYnsbjMaterialAndEquipCategory(YnsbjMaterialAndEquipCategoryParam categoryParam) {
		 String categoryCode = categoryParam.getCategoryCode();
		System.out.println("云南物资设备分类参数：---"+JSONObject.toJSONString(categoryParam));
		 if(StringUtils.isNotBlank(categoryCode)) {
			 String prefixCode = categoryCode.substring(0, 1);
			 if("1".equals(prefixCode)) { //物料分类
				 //根据code查看当前分类是否存在，如果存在则修改
				 List<MaterialCategoryEntity> materialCategoryList = materialCategoryMapper.queryByCode(999999L, categoryCode);
				 MaterialCategoryEntity materialCategory = null;
				 String operateMethod="";
				 if(materialCategoryList != null && materialCategoryList.size() > 0) {
					 materialCategory = materialCategoryList.get(0);
					 materialCategory.setName(categoryParam.getCategoryName());
					 materialCategory.setDescription(categoryParam.getDescription());
					 if(StringUtils.isNotBlank(categoryParam.getState())) {
							 if("正常".equals(categoryParam.getState())){
							materialCategory.setEnabled(1);
						}else {
							materialCategory.setEnabled(2);
						}
					 }else {
						 materialCategory.setEnabled(1);
					 }
					 operateMethod = "update";
				 }else{
					 materialCategory = new MaterialCategoryEntity();
					 materialCategory.setId(IdWorker.getId());
					 materialCategory.setCode(categoryParam.getCategoryCode());
					 materialCategory.setName(categoryParam.getCategoryName());
					 materialCategory.setDescription(categoryParam.getDescription());
					 if(StringUtils.isNotBlank(categoryParam.getState())) {
						 if("正常".equals(categoryParam.getState())){
							 materialCategory.setEnabled(1);
						 }else {
							 materialCategory.setEnabled(2);
						 }
					 }else {
						 materialCategory.setEnabled(1);
					 }
					 operateMethod="add";
				 }
				 MaterialCategoryEntity parentMaterialCategory = null;
				 if(StringUtils.isNotBlank(categoryParam.getParentCode())) {
					 List<MaterialCategoryEntity> parentMaterialCategoryList = materialCategoryMapper.queryByCode(999999L, categoryParam.getParentCode());
					 if(parentMaterialCategoryList != null && parentMaterialCategoryList.size() > 0) {
						 parentMaterialCategory = parentMaterialCategoryList.get(0);
					 }
					 if(parentMaterialCategory != null) {
						 materialCategory.setParentId(parentMaterialCategory.getId());
						 materialCategory.setInnerCode(parentMaterialCategory.getInnerCode()+"|"+materialCategory.getId());
					 }else {
						 materialCategory.setInnerCode("有上级，但是没有先推过来，没查到，所以成了现在这样子");
					 }
				 }else {
					 materialCategory.setInnerCode(materialCategory.getId()+"");

				 }
				 materialCategory.setTenantId(999999L);
				 if("add".equals(operateMethod)) {
					 materialCategoryMapper.insert(materialCategory);
				 }else{
					 materialCategoryMapper.update(materialCategory);
				 }
			 } else { //设备分类
				//根据code查看当前分类是否存在，如果存在则修改
				 List<EquipmentCategoryEntity> equipmentCategoryList = equipmentCategoryMapper.queryByCode(999999L, categoryCode);
				 EquipmentCategoryEntity equipmentCategory = null;
				 String operateMethod="";
				 if(equipmentCategoryList != null && equipmentCategoryList.size() > 0) {
					 equipmentCategory = equipmentCategoryList.get(0);
					 equipmentCategory.setName(categoryParam.getCategoryName());
					 equipmentCategory.setDescription(categoryParam.getDescription());
					 if(StringUtils.isNotBlank(categoryParam.getState())) {
						 if("正常".equals(categoryParam.getState())){
							 equipmentCategory.setEnabled(1);
						 }else {
							 equipmentCategory.setEnabled(2);
						 }
					 }else {
						 equipmentCategory.setEnabled(1);
					 }
					 operateMethod = "update";
				 }else{
					 equipmentCategory = new EquipmentCategoryEntity();
					 equipmentCategory.setId(IdWorker.getId());
					 equipmentCategory.setCode(categoryParam.getCategoryCode());
					 equipmentCategory.setName(categoryParam.getCategoryName());
					 equipmentCategory.setDescription(categoryParam.getDescription());
					 if(StringUtils.isNotBlank(categoryParam.getState())) {
						 if("正常".equals(categoryParam.getState())){
							 equipmentCategory.setEnabled(1);
						 }else {
							 equipmentCategory.setEnabled(2);
						 }
					 }else {
						 equipmentCategory.setEnabled(1);
					 }
					 operateMethod="add";
				 }
				 EquipmentCategoryEntity parentEquipmentCategory = null;
				 if(StringUtils.isNotBlank(categoryParam.getParentCode())) {
					 System.out.println("云南设备分类上级1：---"+parentEquipmentCategory);
					 List<EquipmentCategoryEntity> parentMaterialCategoryList = equipmentCategoryMapper.queryByCode(999999L, categoryParam.getParentCode());
					 if(parentMaterialCategoryList != null && parentMaterialCategoryList.size() > 0) {
						 parentEquipmentCategory = parentMaterialCategoryList.get(0);
					 }
					 System.out.println("云南设备分类上级2：---"+JSONObject.toJSONString(parentMaterialCategoryList));
					 if(parentEquipmentCategory != null) {
						 System.out.println("云南设备分类上级3：---"+JSONObject.toJSONString(parentEquipmentCategory));
						 equipmentCategory.setParentId(parentEquipmentCategory.getId());
						 equipmentCategory.setInnerCode(parentEquipmentCategory.getInnerCode()+"|"+equipmentCategory.getId());
						 System.out.println("云南设备分类上级4InnerCode：---"+equipmentCategory.getInnerCode());
					 }else {
						 equipmentCategory.setInnerCode("有上级，但是没有先推过来，没查到，所以成了现在这样子");
					 }
				 }else {
					 System.out.println("云南设备分类没有上级：---");
					 equipmentCategory.setInnerCode(""+equipmentCategory.getId());
					 System.out.println("云南设备分类没有上级InnerCode：---"+equipmentCategory.getInnerCode());
				 }
				 equipmentCategory.setTenantId(999999L);
				 equipmentCategory.setSystemId("ZHUSHUJU");
				 equipmentCategory.setSourceId(categoryParam.getCategoryCode());
				 if("add".equals(operateMethod)) {
					 System.out.println("云南设备分类保存：---"+JSONObject.toJSONString(equipmentCategory));
					 equipmentCategoryMapper.insert(equipmentCategory);
				 }else{
					 System.out.println("云南设备分类更新：---"+JSONObject.toJSONString(equipmentCategory));
					 equipmentCategoryMapper.update(equipmentCategory);
				 }
			 }
		 }
		 YnsbjDataInfo dataInfo = new YnsbjDataInfo(categoryParam.getUuid(), categoryParam.getMasterDataCode(), "0", "");
		 return dataInfo;
	}

	/**
	 * 保存或修改物料和设备
	 * 
	 * @param ynsbjMaterialAndEquipParam
	 * @return
	 */
	@Override
	public YnsbjDataInfo saveOrUpdateYnsbjMaterialAndEquip(YnsbjMaterialAndEquipParam ynsbjMaterialAndEquipParam) {
		YnsbjDataInfo dataInfo = null;
		String materialAndEquipCode = ynsbjMaterialAndEquipParam.getMaterialAndEquipCode();
		if(StringUtils.isNotBlank(materialAndEquipCode)) {
			 String prefixCode = materialAndEquipCode.substring(0, 1);
			 if("1".equals(prefixCode)) { //物资
				 String categoryCode = ynsbjMaterialAndEquipParam.getCategoryCode();
				 List<MaterialCategoryEntity> materialCategoryList = materialCategoryMapper.queryByCode(999999l, categoryCode);
				 if(materialCategoryList != null && materialCategoryList.size() > 0) {
					 MaterialCategoryEntity materialCategoryEntity = materialCategoryList.get(0);
					 
					 String sourceId = ynsbjMaterialAndEquipParam.getMasterDataCode();
					 MaterialEntity materialEntity = materialMapper.queryBySourceId(sourceId, 999999l);
					 if(materialEntity != null) {
						 materialEntity.setCategoryId(materialCategoryEntity.getId());
						 materialEntity.setCategoryCode(materialCategoryEntity.getCode());
						 materialEntity.setCategoryName(materialCategoryEntity.getName());
						 materialEntity.setCode(ynsbjMaterialAndEquipParam.getMaterialAndEquipCode());
						 materialEntity.setName(ynsbjMaterialAndEquipParam.getMaterialAndEquipName());
						 materialEntity.setSpec(ynsbjMaterialAndEquipParam.getMaterialAndEquipModel());
						 materialEntity.setUnitName(ynsbjMaterialAndEquipParam.getUnitName());
						 materialEntity.setTenantId(999999L);

						 MaterialVO materialVo = BeanMapper.map(materialEntity, MaterialVO.class);
						 materialMapper.update(materialVo);
					 }else{
						 materialEntity = new MaterialEntity(); 
						 materialEntity.setId(IdWorker.getId());
						 materialEntity.setTenantId(999999L);
						 materialEntity.setCategoryId(materialCategoryEntity.getId());
						 materialEntity.setCategoryCode(materialCategoryEntity.getCode());
						 materialEntity.setCategoryName(materialCategoryEntity.getName());
						 materialEntity.setCode(ynsbjMaterialAndEquipParam.getMaterialAndEquipCode());
						 materialEntity.setName(ynsbjMaterialAndEquipParam.getMaterialAndEquipName());
						 materialEntity.setSpec(ynsbjMaterialAndEquipParam.getMaterialAndEquipModel());
						 materialEntity.setUnitName(ynsbjMaterialAndEquipParam.getUnitName());
						 materialEntity.setSourceId(ynsbjMaterialAndEquipParam.getMasterDataCode());
						 
						 MaterialVO materialVo = BeanMapper.map(materialEntity, MaterialVO.class);
						 materialMapper.save(materialVo);
					 }
					 dataInfo = new YnsbjDataInfo(ynsbjMaterialAndEquipParam.getUuid(), ynsbjMaterialAndEquipParam.getMasterDataCode(), "0", "");
				 }else{
					 dataInfo = new YnsbjDataInfo(ynsbjMaterialAndEquipParam.getUuid(), ynsbjMaterialAndEquipParam.getMasterDataCode(), "1", "物料："+ynsbjMaterialAndEquipParam.getMaterialAndEquipName()+"所属分类为空！");
				 }
			 }else{ //设备
				 String categoryCode = ynsbjMaterialAndEquipParam.getCategoryCode();
				 List<EquipmentCategoryEntity> equipmentCategoryList = equipmentCategoryMapper.queryByCode(999999l, categoryCode);
				 if(equipmentCategoryList != null && equipmentCategoryList.size() > 0) {
					 EquipmentCategoryEntity equipmentCategoryEntity = equipmentCategoryList.get(0);
					 
					 String sourceId = ynsbjMaterialAndEquipParam.getMasterDataCode();
					 EquipmentEntity equipmentEntity = equipmentMapper.queryBySourceId(sourceId, 999999l);
					 if(equipmentEntity != null) {
						 equipmentEntity.setCategoryId(equipmentCategoryEntity.getId());
						 equipmentEntity.setCategoryName(equipmentCategoryEntity.getName());
						 equipmentEntity.setCode(ynsbjMaterialAndEquipParam.getMaterialAndEquipCode());
						 equipmentEntity.setName(ynsbjMaterialAndEquipParam.getMaterialAndEquipName());
						 equipmentEntity.setSpec(ynsbjMaterialAndEquipParam.getMaterialAndEquipModel());
						 equipmentEntity.setUnitName(ynsbjMaterialAndEquipParam.getUnitName());
						 equipmentEntity.setTenantId(999999L);

						 EquipmentVO equipmentVo = BeanMapper.map(equipmentEntity, EquipmentVO.class);
						 equipmentMapper.update(equipmentVo);
					 }else{
						 equipmentEntity = new EquipmentEntity(); 
						 equipmentEntity.setId(IdWorker.getId());
						 equipmentEntity.setCategoryId(equipmentCategoryEntity.getId());
						 equipmentEntity.setCategoryName(equipmentCategoryEntity.getName());
						 equipmentEntity.setCode(ynsbjMaterialAndEquipParam.getMaterialAndEquipCode());
						 equipmentEntity.setName(ynsbjMaterialAndEquipParam.getMaterialAndEquipName());
						 equipmentEntity.setSpec(ynsbjMaterialAndEquipParam.getMaterialAndEquipModel());
						 equipmentEntity.setUnitName(ynsbjMaterialAndEquipParam.getUnitName());
						 equipmentEntity.setSourceId(ynsbjMaterialAndEquipParam.getMasterDataCode());
						 equipmentEntity.setSystemId("ZHUSHUJU");
						 equipmentEntity.setTenantId(999999L);
						 
						 EquipmentVO equipmentVo = BeanMapper.map(equipmentEntity, EquipmentVO.class);
						 equipmentMapper.save(equipmentVo);
					 }
					 dataInfo = new YnsbjDataInfo(ynsbjMaterialAndEquipParam.getUuid(), ynsbjMaterialAndEquipParam.getMasterDataCode(), "0", "");
				 }else{
					 dataInfo = new YnsbjDataInfo(ynsbjMaterialAndEquipParam.getUuid(), ynsbjMaterialAndEquipParam.getMasterDataCode(), "1", "物料："+ynsbjMaterialAndEquipParam.getMaterialAndEquipName()+"所属分类为空！");
				 }
			 }
		}
		return dataInfo;
	}

}
