/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.supplier.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.share.bean.SubleadersEntity;
import com.ejianc.foundation.share.bean.SupplierEntity;
import com.ejianc.foundation.share.service.ISubleadersService;
import com.ejianc.foundation.share.service.ISupplierService;
import com.ejianc.foundation.share.vo.SubleadersVO;
import com.ejianc.foundation.share.vo.dto.SubleadersDTO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/shareSubleadersApi/"})
public class SubleadersApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISubleadersService subleadersService;
    @Autowired
    private ISupplierService supplierService;

    @GetMapping(value={"upGradeSubleader"})
    public CommonResponse<String> upGradeSubleader(@RequestParam(value="subleaderId") Long subleaderId, @RequestParam(value="gradeId") Long gradeId, @RequestParam(value="gradeName") String gradeName) {
        this.logger.info("\u8bc4\u7ea7\u66f4\u65b0\u5206\u5305\u8d1f\u8d23\u4eba\u5e93");
        this.logger.info(subleaderId.toString());
        this.logger.info(gradeId.toString());
        this.logger.info(gradeName);
        SubleadersEntity subleadersEntity = (SubleadersEntity)((Object)this.subleadersService.selectById(subleaderId));
        if (subleadersEntity == null) {
            return CommonResponse.error((String)"\u5206\u5305\u8d1f\u8d23\u4eba\u4e0d\u5b58\u5728\uff01");
        }
        subleadersEntity.setGrade(gradeId);
        subleadersEntity.setGradeName(gradeName);
        this.subleadersService.saveOrUpdate((Object)subleadersEntity, false);
        return CommonResponse.success((String)"\u5206\u5305\u8d1f\u8d23\u4eba\u8bc4\u7ea7\u8bbe\u7f6e\u6210\u529f\uff01");
    }

    @GetMapping(value={"selectByUpDateSubLeaders"})
    public CommonResponse<List<SubleadersDTO>> selectByUpDateSubLeaders(@RequestParam(value="upDate") String upDate) {
        List<SubleadersDTO> vos = this.supplierService.selectByUpDateSubLeaders(upDate);
        return CommonResponse.success(vos);
    }

    @PostMapping(value={"getSubleaderList"})
    public CommonResponse<List<SubleadersVO>> getSubleaderList(@RequestBody Map<String, List<Long>> idsMap) {
        this.logger.info("\u63a5\u6536\u5230\u8bf7\u6c42\u53c2\u6570:" + JSONObject.toJSONString(idsMap));
        List<Long> ids = idsMap.get("ids");
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"id", ids);
        List list = this.subleadersService.list((Wrapper)wrapper);
        List subleadersVOS = BeanMapper.mapList((Iterable)list, SubleadersVO.class);
        this.logger.info("\u67e5\u8be2\u7ed3\u679c:" + JSONObject.toJSONString((Object)subleadersVOS));
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01\uff01\uff01\uff01", (Object)subleadersVOS);
    }

    @GetMapping(value={"querySupplierByLeaderId"})
    public CommonResponse<SubleadersVO> querySupplierByLeaderId(@RequestParam(value="id") Long id) {
        SubleadersEntity subleadersEntity = (SubleadersEntity)((Object)this.subleadersService.selectById(id));
        SubleadersVO record = (SubleadersVO)BeanMapper.map((Object)((Object)subleadersEntity), SubleadersVO.class);
        SupplierEntity supplierEntity = (SupplierEntity)((Object)this.supplierService.selectById(subleadersEntity.getPid()));
        String content = "";
        if (StringUtils.isNotEmpty((CharSequence)supplierEntity.getLaborContent())) {
            content = content + supplierEntity.getLaborContent() + ",";
        }
        if (StringUtils.isNotEmpty((CharSequence)supplierEntity.getMajorContent())) {
            content = content + supplierEntity.getMajorContent();
        }
        record.setSupplierContent(content);
        record.setSupplierName(supplierEntity.getName());
        record.setSupplierGrade(supplierEntity.getGradeName());
        record.setArea(supplierEntity.getAreaName());
        record.setSupplierCode(supplierEntity.getCode());
        record.setPersonal(supplierEntity.getPersonal());
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01\uff01\uff01\uff01", (Object)record);
    }

    @PostMapping(value={"querySupplierByLeaderId"})
    public CommonResponse<List<SubleadersVO>> queryLeaderIdsByTenantId(HttpServletRequest request) {
        this.logger.info("\u6839\u636e\u67e5\u8be2\u4f9b\u5e94\u5546tenantid\u83b7\u53d6\u5206\u5305\u8d1f\u8d23\u4eba\u4fe1\u606f\u63a5\u53e3request-{},file-{}", (Object)request);
        String leaderTenantId = request.getParameter("leaderTenantId");
        QueryParam param = new QueryParam();
        param.getParams().put("ejcTenantId", new Parameter("eq", (Object)Long.parseLong(leaderTenantId)));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        List subleadersEntities = this.subleadersService.queryList(param);
        List subleadersVOS = BeanMapper.mapList((Iterable)subleadersEntities, SubleadersVO.class);
        if (CollectionUtils.isNotEmpty((Collection)subleadersVOS)) {
            for (SubleadersVO subleadersVO : subleadersVOS) {
                SupplierEntity supplierEntity = (SupplierEntity)((Object)this.supplierService.selectById(subleadersVO.getPid()));
                subleadersVO.setSupplierName(supplierEntity.getName());
                subleadersVO.setSupplierGrade(supplierEntity.getGradeName());
                subleadersVO.setArea(supplierEntity.getAreaName());
                subleadersVO.setSupplierCode(supplierEntity.getCode());
                subleadersVO.setPersonal(supplierEntity.getPersonal());
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01\uff01\uff01\uff01", (Object)subleadersVOS);
    }
}

