/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.supplier.warn;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.dto.SupplierWarnVO;
import com.ejianc.foundation.supplier.mapper.SuplSupplierMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/supplierWarn/"})
public class WarnController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IWarnCenterApi warnCenterApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IContractPoolApi contractPoolApi;
    @Autowired
    private SuplSupplierMapper mapper;
    static String PC_URL = "/ejc-share-frontend/#/allSupplier/card?id=";

    @PostMapping(value={"majorExecute"})
    public CommonResponse<String> majorExecute(@RequestBody JSONArray jsonParam) {
        this.logger.info("\u63a5\u6536\u5230 Task \u53c2\u6570\uff1a{}", (Object)jsonParam);
        ArrayList<EarlyWarnTransVO> warnList = new ArrayList<EarlyWarnTransVO>();
        String warnCode = null;
        for (int i = 0; i < jsonParam.size(); ++i) {
            List<SupplierWarnVO> major;
            List supplierIds;
            JSONObject o = jsonParam.getJSONObject(i);
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
            QueryParam queryParam = new QueryParam();
            queryParam.setPageIndex(1);
            queryParam.setPageSize(-1);
            queryParam.getParams().put("sourceType", new Parameter("eq", (Object)"proSub"));
            queryParam.getParams().put("performanceStatus", new Parameter("eq", (Object)"2"));
            CommonResponse listCommonResponse = this.contractPoolApi.querySupplierList(queryParam);
            if (!listCommonResponse.isSuccess() || !ListUtil.isNotEmpty((List)(supplierIds = (List)listCommonResponse.getData())) || !ListUtil.isNotEmpty(major = this.mapper.refSupplierWarnList(supplierIds, "major"))) continue;
            for (SupplierWarnVO assessDetailVO : major) {
                int i1;
                JSONObject orgSet = null;
                JSONObject defaultSet = null;
                Long orgId = 1502571152583692289L;
                OrgVO orgVO = (OrgVO)this.iOrgApi.getOneById(orgId).getData();
                if (orgVO == null) continue;
                String innerCode = orgVO.getInnerCode();
                String[] parentIds = innerCode.split("\\|");
                this.logger.info("parentIds______" + innerCode);
                for (i1 = parentIds.length - 1; i1 >= 0; --i1) {
                    Long pOrgId = Long.parseLong(parentIds[i1]);
                    for (int j = 0; j < orgSettings.size(); ++j) {
                        JSONObject set = orgSettings.getJSONObject(j);
                        if (!pOrgId.equals(set.getLong("orgId"))) continue;
                        orgSet = set;
                        break;
                    }
                    if (orgSet != null) break;
                }
                for (i1 = 0; i1 < orgSettings.size(); ++i1) {
                    JSONObject set = orgSettings.getJSONObject(i1);
                    if (!set.getBoolean("default").booleanValue()) continue;
                    defaultSet = set;
                    break;
                }
                if (orgSet == null) {
                    orgSet = defaultSet;
                }
                if (orgSet == null || !ListUtil.isNotEmpty((List)orgSet.getJSONArray("warningSetings"))) continue;
                JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                boolean high = false;
                boolean meddle = false;
                boolean low = false;
                JSONObject useSetHigh = null;
                JSONObject useSetMeddle = null;
                JSONObject useSetLow = null;
                for (int i12 = 0; i12 < warningSettings.size(); ++i12) {
                    JSONObject set = warningSettings.getJSONObject(i12);
                    if ("\u9ad8".equals(set.getString("warningLevel"))) {
                        high = true;
                        useSetHigh = set;
                    }
                    if ("\u4e2d".equals(set.getString("warningLevel"))) {
                        meddle = true;
                        useSetMeddle = set;
                    }
                    if (!"\u4f4e".equals(set.getString("warningLevel"))) continue;
                    low = true;
                    useSetLow = set;
                }
                if (!high && !meddle && !low) continue;
                EarlyWarnTransVO vo = new EarlyWarnTransVO();
                String pattern = "yyyy-MM-dd HH:mm:ss";
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
                vo.setBillName(orgSet.getString("moduleName") + "-" + assessDetailVO.getSupplierName());
                vo.setPcTitle("\u4f9b\u5e94\u5546\u8bc1\u4ef6\u8fc7\u671f\u9884\u8b66");
                vo.setPcUrl(PC_URL + assessDetailVO.getSupplierId());
                vo.setOrgId(Long.valueOf(1502571152583692289L));
                vo.setSendOrgId("1502571152583692289");
                vo.setOrgName(assessDetailVO.getSupplierName());
                vo.setSourceId(assessDetailVO.getSupplierId().toString());
                vo.setTenantId(Long.valueOf(999999L));
                vo.setWarnSetId(orgSet.getLong("warnId"));
                vo.setEarlywarnName(orgSet.getString("warnName"));
                vo.setWarnType(orgSet.getString("warnType"));
                String tmpContent = orgSet.getString("warningContentTemplate");
                if (high) {
                    vo.setWarnLevel("\u9ad8");
                    vo.setWarnSetParamId(useSetHigh.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#supplierName#", assessDetailVO.getSupplierName()).replaceAll("#certName#", assessDetailVO.getCertName()));
                } else if (meddle) {
                    vo.setWarnLevel("\u4e2d");
                    vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#supplierName#", assessDetailVO.getSupplierName()).replaceAll("#certName#", assessDetailVO.getCertName()));
                } else {
                    vo.setWarnLevel("\u4f4e");
                    vo.setWarnSetParamId(useSetLow.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#supplierName#", assessDetailVO.getSupplierName()).replaceAll("#certName#", assessDetailVO.getCertName()));
                }
                warnList.add(vo);
            }
        }
        return this.sendWarnToTask(warnList, warnCode);
    }

    @PostMapping(value={"laborExecute"})
    public CommonResponse<String> laborExecute(@RequestBody JSONArray jsonParam) {
        this.logger.info("\u63a5\u6536\u5230 Task \u53c2\u6570\uff1a{}", (Object)jsonParam);
        ArrayList<EarlyWarnTransVO> warnList = new ArrayList<EarlyWarnTransVO>();
        String warnCode = null;
        for (int i = 0; i < jsonParam.size(); ++i) {
            List<SupplierWarnVO> major;
            List supplierIds;
            JSONObject o = jsonParam.getJSONObject(i);
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
            QueryParam queryParam = new QueryParam();
            queryParam.setPageIndex(1);
            queryParam.setPageSize(-1);
            queryParam.getParams().put("sourceType", new Parameter("eq", (Object)"laborSub"));
            queryParam.getParams().put("performanceStatus", new Parameter("eq", (Object)"2"));
            CommonResponse listCommonResponse = this.contractPoolApi.querySupplierList(queryParam);
            if (!listCommonResponse.isSuccess() || !ListUtil.isNotEmpty((List)(supplierIds = (List)listCommonResponse.getData())) || !ListUtil.isNotEmpty(major = this.mapper.refSupplierWarnList(supplierIds, "labor"))) continue;
            for (SupplierWarnVO assessDetailVO : major) {
                int i1;
                JSONObject orgSet = null;
                JSONObject defaultSet = null;
                Long orgId = 1502571152583692289L;
                OrgVO orgVO = (OrgVO)this.iOrgApi.getOneById(orgId).getData();
                if (orgVO == null) continue;
                String innerCode = orgVO.getInnerCode();
                String[] parentIds = innerCode.split("\\|");
                this.logger.info("parentIds______" + innerCode);
                for (i1 = parentIds.length - 1; i1 >= 0; --i1) {
                    Long pOrgId = Long.parseLong(parentIds[i1]);
                    for (int j = 0; j < orgSettings.size(); ++j) {
                        JSONObject set = orgSettings.getJSONObject(j);
                        if (!pOrgId.equals(set.getLong("orgId"))) continue;
                        orgSet = set;
                        break;
                    }
                    if (orgSet != null) break;
                }
                for (i1 = 0; i1 < orgSettings.size(); ++i1) {
                    JSONObject set = orgSettings.getJSONObject(i1);
                    if (!set.getBoolean("default").booleanValue()) continue;
                    defaultSet = set;
                    break;
                }
                if (orgSet == null) {
                    orgSet = defaultSet;
                }
                if (orgSet == null || !ListUtil.isNotEmpty((List)orgSet.getJSONArray("warningSetings"))) continue;
                JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                boolean high = false;
                boolean meddle = false;
                boolean low = false;
                JSONObject useSetHigh = null;
                JSONObject useSetMeddle = null;
                JSONObject useSetLow = null;
                for (int i12 = 0; i12 < warningSettings.size(); ++i12) {
                    JSONObject set = warningSettings.getJSONObject(i12);
                    if ("\u9ad8".equals(set.getString("warningLevel"))) {
                        high = true;
                        useSetHigh = set;
                    }
                    if ("\u4e2d".equals(set.getString("warningLevel"))) {
                        meddle = true;
                        useSetMeddle = set;
                    }
                    if (!"\u4f4e".equals(set.getString("warningLevel"))) continue;
                    low = true;
                    useSetLow = set;
                }
                if (!high && !meddle && !low) continue;
                EarlyWarnTransVO vo = new EarlyWarnTransVO();
                String pattern = "yyyy-MM-dd HH:mm:ss";
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
                vo.setBillName(orgSet.getString("moduleName") + "-" + assessDetailVO.getSupplierName());
                vo.setPcTitle("\u4f9b\u5e94\u5546\u8bc1\u4ef6\u8fc7\u671f\u9884\u8b66");
                vo.setPcUrl(PC_URL + assessDetailVO.getSupplierId());
                vo.setOrgId(Long.valueOf(1502571152583692289L));
                vo.setSendOrgId("1502571152583692289");
                vo.setOrgName(assessDetailVO.getSupplierName());
                vo.setSourceId(assessDetailVO.getSupplierId().toString());
                vo.setTenantId(Long.valueOf(999999L));
                vo.setWarnSetId(orgSet.getLong("warnId"));
                vo.setEarlywarnName(orgSet.getString("warnName"));
                vo.setWarnType(orgSet.getString("warnType"));
                String tmpContent = orgSet.getString("warningContentTemplate");
                if (high) {
                    vo.setWarnLevel("\u9ad8");
                    vo.setWarnSetParamId(useSetHigh.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#supplierName#", assessDetailVO.getSupplierName()).replaceAll("#certName#", assessDetailVO.getCertName()));
                } else if (meddle) {
                    vo.setWarnLevel("\u4e2d");
                    vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#supplierName#", assessDetailVO.getSupplierName()).replaceAll("#certName#", assessDetailVO.getCertName()));
                } else {
                    vo.setWarnLevel("\u4f4e");
                    vo.setWarnSetParamId(useSetLow.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#supplierName#", assessDetailVO.getSupplierName()).replaceAll("#certName#", assessDetailVO.getCertName()));
                }
                warnList.add(vo);
            }
        }
        return this.sendWarnToTask(warnList, warnCode);
    }

    private CommonResponse<String> sendWarnToTask(List<EarlyWarnTransVO> warnList, String warnCode) {
        CommonResponse warnResp = this.warnCenterApi.sendToWarnCenterByCode(warnList, warnCode);
        if (!warnResp.isSuccess()) {
            this.logger.error("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25\uff0c{}", (Object)warnResp.getMsg());
            return CommonResponse.error((String)("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25" + warnResp.getMsg()));
        }
        return CommonResponse.success((String)"\u4efb\u52a1\u63a5\u53d7\u5904\u7406\u6210\u529f\uff01");
    }
}

