/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.controller.api;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.foundation.share.bean.CustomerProEntity;
import com.ejianc.foundation.share.service.ICustomerCategoryService;
import com.ejianc.foundation.share.service.ICustomerProService;
import com.ejianc.foundation.share.service.ICustomerService;
import com.ejianc.foundation.share.vo.CustomerCategoryVO;
import com.ejianc.foundation.share.vo.CustomerVO;
import com.ejianc.foundation.share.vo.ShareCustomerVO;
import com.ejianc.foundation.support.vo.CustomerIncomeInfoVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/shareCustomerApi/"})
public class CustomerApi {
    @Autowired
    private ICustomerService customerService;
    @Autowired
    private ICustomerCategoryService customerCategoryService;
    @Autowired
    private ICustomerProService service;

    @GetMapping(value={"findOneByName"})
    public CommonResponse<CustomerVO> findOneByName(@RequestParam(value="name") String name, @RequestParam(value="tenantId") Long tenantId) {
        CustomerVO vo = null;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("name", new Parameter("eq", (Object)name));
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)tenantId));
        List list = this.customerService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            vo = (CustomerVO)BeanMapper.map(list.get(0), CustomerVO.class);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", vo);
    }

    @GetMapping(value={"queryById"})
    CommonResponse<CustomerVO> detailById(@RequestParam(value="id") Long id) {
        CustomerVO vo = this.customerService.queryDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)vo);
    }

    @GetMapping(value={"queryListByIds"})
    CommonResponse<List<ShareCustomerVO>> detailsByIds(@RequestParam List<Long> ids) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.in((Object)"id", ids);
        List list = this.customerService.list((Wrapper)query);
        List voList = BeanMapper.mapList((Iterable)list, ShareCustomerVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)voList);
    }

    @GetMapping(value={"queryCategoryList"})
    CommonResponse<List<CustomerCategoryVO>> queryCategoryList(@RequestParam(value="tenantId") Long tenantId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)tenantId));
        List list = this.customerCategoryService.queryList(queryParam);
        List voList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            voList = BeanMapper.mapList((Iterable)list, CustomerCategoryVO.class);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", voList);
    }

    @PostMapping(value={"updateIncomeMny"})
    CommonResponse<String> updateIncomeMny(@RequestBody CustomerIncomeInfoVO customerIncomeInfoVO) {
        Integer level = 1;
        if (customerIncomeInfoVO.getSum() != null) {
            if (customerIncomeInfoVO.getSum().compareTo(new BigDecimal(500000000)) >= 0 && customerIncomeInfoVO.getSum().compareTo(new BigDecimal(1000000000)) < 0) {
                level = 2;
            } else if (customerIncomeInfoVO.getSum().compareTo(new BigDecimal(1000000000)) >= 0) {
                level = 3;
            }
        }
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.set(CustomerProEntity::getIncomeMny, (Object)customerIncomeInfoVO.getSum());
        wrapper.set(CustomerProEntity::getIncomeNum, (Object)customerIncomeInfoVO.getCount());
        wrapper.set(CustomerProEntity::getCustomerLevel, (Object)level);
        wrapper.eq(BaseEntity::getId, (Object)customerIncomeInfoVO.getCustomerId());
        this.service.update((Wrapper)wrapper);
        return CommonResponse.success((String)"\u66f4\u65b0\u6210\u529f\uff01");
    }
}

