/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.utils.EJCDateUtil;
import com.ejianc.foundation.orgcenter.api.IOrgNoAuthApi;
import com.ejianc.foundation.orgcenter.vo.DeptVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.bean.ProjectSetPoolEntity;
import com.ejianc.foundation.share.bean.SupplierEntity;
import com.ejianc.foundation.share.consts.ProjectBusinessStatusEnum;
import com.ejianc.foundation.share.controller.param.YnsbjProjectParam;
import com.ejianc.foundation.share.controller.resp.YnsbjDataInfo;
import com.ejianc.foundation.share.mapper.ProjectSetMapper;
import com.ejianc.foundation.share.service.IProjectSetService;
import com.ejianc.foundation.share.service.ISupplierService;
import com.ejianc.foundation.share.utils.TreeNodeBUtil;
import com.ejianc.foundation.share.vo.ProjectDesktopSubParentVO;
import com.ejianc.foundation.share.vo.ProjectDesktopSubVO;
import com.ejianc.foundation.share.vo.ProjectDesktopVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ProjectSetServiceImpl
extends BaseServiceImpl<ProjectSetMapper, ProjectSetPoolEntity>
implements IProjectSetService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ProjectSetMapper projectSetMapper;
    @Autowired
    private ISupplierService iSupplierService;
    @Autowired
    private IOrgNoAuthApi iOrgNoAuthApi;
    @Autowired
    private IDefdocApi iDefdocApi;

    @Override
    public YnsbjDataInfo saveOrUpdateYnsbjProject(YnsbjProjectParam projectParam) {
        CommonResponse oneByOrgVO;
        DefdocDetailVO detailVO;
        int i;
        this.logger.info("\u4e3b\u6570\u636e\u63d2\u5165\u9879\u76ee\u4fe1\u606f-{}", (Object)JSONObject.toJSONString((Object)projectParam));
        QueryParam param = new QueryParam();
        param.getParams().put("code", new Parameter("eq", (Object)projectParam.getCode()));
        List projectSetPoolEntities = this.queryList(param);
        ProjectSetPoolEntity projectSetPoolEntity = ListUtil.isNotEmpty((List)projectSetPoolEntities) ? (ProjectSetPoolEntity)((Object)projectSetPoolEntities.get(0)) : new ProjectSetPoolEntity();
        YnsbjDataInfo dataInfo = null;
        OrgVO orgVO = new OrgVO();
        String code = projectParam.getOrgId();
        projectSetPoolEntity.setName(projectParam.getPrjName());
        projectSetPoolEntity.setShortName(projectParam.getPrjName());
        projectSetPoolEntity.setBillState(1);
        projectSetPoolEntity.setCode(projectParam.getCode());
        projectSetPoolEntity.setNumber(projectParam.getPrjCode());
        QueryParam cus = new QueryParam();
        cus.getParams().put("name", new Parameter("eq", (Object)projectParam.getConstructName()));
        List supplierEntities = this.iSupplierService.queryList(cus);
        if (ListUtil.isNotEmpty((List)supplierEntities)) {
            projectSetPoolEntity.setConstructId(((SupplierEntity)((Object)supplierEntities.get(0))).getId());
        }
        projectSetPoolEntity.setConstructName(projectParam.getConstructName());
        projectSetPoolEntity.setDesigner(projectParam.getDesignerName());
        this.logger.info("\u5de5\u7a0b\u7c7b\u522b-{}", (Object)projectParam.getProfessionType());
        CommonResponse response = this.iDefdocApi.getDefDocDetailByDefCodeAndTenantId("pro-market-project-engineeringType", Long.valueOf(999999L));
        if (response.isSuccess() && ListUtil.isNotEmpty((List)((List)response.getData()))) {
            for (i = 0; i < ((List)response.getData()).size(); ++i) {
                detailVO = (DefdocDetailVO)((List)response.getData()).get(i);
                if (!detailVO.getName().equals(projectParam.getProfessionType())) continue;
                projectSetPoolEntity.setEngineeringTypeId(detailVO.getId());
            }
        }
        projectSetPoolEntity.setSupervisor(projectParam.getSupervisorName());
        projectSetPoolEntity.setTaxType("\u7b80\u6613\u8ba1\u7a0e".equals(projectParam.getTaxType()) ? "2" : "1");
        this.logger.info("\u9879\u76ee\u7c7b\u578b\u5206\u7c7b-{}", (Object)projectParam.getProjectTypeCategory());
        projectSetPoolEntity.setProjectNewType(projectParam.getProjectTypeCategory());
        this.logger.info("\u884c\u4e1a\u7c7b\u522b-{}", (Object)projectParam.getIndustryType());
        response = this.iDefdocApi.getDefDocDetailByDefCodeAndTenantId("pro_matket_industry_type", Long.valueOf(999999L));
        if (response.isSuccess() && ListUtil.isNotEmpty((List)((List)response.getData()))) {
            for (i = 0; i < ((List)response.getData()).size(); ++i) {
                detailVO = (DefdocDetailVO)((List)response.getData()).get(i);
                if (!detailVO.getName().equals(projectParam.getIndustryType())) continue;
                projectSetPoolEntity.setIndustryType(detailVO.getId());
            }
        } else {
            this.logger.info("\u884c\u4e1a\u7c7b\u522b\u8fd4\u56de\u6570\u636e\uff1a-{}", (Object)JSONObject.toJSONString((Object)response));
        }
        this.logger.info("\u627f\u5305\u6a21\u5f0f-{}", (Object)projectParam.getProjectType());
        response = this.iDefdocApi.getDefDocDetailByDefCodeAndTenantId("pro-market-project-type", Long.valueOf(999999L));
        if (response.isSuccess() && ListUtil.isNotEmpty((List)((List)response.getData()))) {
            for (i = 0; i < ((List)response.getData()).size(); ++i) {
                detailVO = (DefdocDetailVO)((List)response.getData()).get(i);
                if (!detailVO.getName().equals(projectParam.getProjectType())) continue;
                projectSetPoolEntity.setProjectType(detailVO.getId());
            }
        }
        this.logger.info("\u7ecf\u8425\u65b9\u5f0f-{}", (Object)projectParam.getRunType());
        response = this.iDefdocApi.getDefDocDetailByDefCodeAndTenantId("pro-market-project-run-type", Long.valueOf(999999L));
        if (response.isSuccess() && ListUtil.isNotEmpty((List)((List)response.getData()))) {
            for (i = 0; i < ((List)response.getData()).size(); ++i) {
                detailVO = (DefdocDetailVO)((List)response.getData()).get(i);
                if (!detailVO.getName().equals(projectParam.getRunType())) continue;
                projectSetPoolEntity.setRunType(detailVO.getId());
            }
        }
        projectSetPoolEntity.setMainDeploy(projectParam.getDevMainName());
        if (StringUtils.isNotEmpty((CharSequence)projectParam.getOperateMainCode())) {
            OrgVO mainDeploy = new OrgVO();
            mainDeploy.setCode(projectParam.getOperateMainCode());
            CommonResponse r = this.iOrgNoAuthApi.findOneByOrgVO(mainDeploy);
            if (r.isSuccess()) {
                projectSetPoolEntity.setMainDeployId(((OrgVO)r.getData()).getId());
            } else {
                this.logger.error("\u5b9e\u65bd\u4e3b\u4f53 DESC69=" + projectParam.getOperateMainCode() + "\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7ec4\u7ec7\uff01\u8bf7\u5148\u540c\u6b65\u8be5\u7ec4\u7ec7\uff01");
            }
        } else {
            this.logger.error("\u5b9e\u65bd\u4e3b\u4f53 DESC69=" + projectParam.getOperateMainCode() + "  \u4e3a\u7a7a\uff01");
        }
        if ("\u81ea\u8425".equals(projectParam.getDevType())) {
            projectSetPoolEntity.setDevType("1");
        } else if ("\u8054\u8425".equals(projectParam.getDevType())) {
            projectSetPoolEntity.setDevType("2");
        }
        this.logger.info("\u878d\u8d44\u5efa\u8bbe-{}", (Object)projectParam.getFinanceConstruct());
        projectSetPoolEntity.setFinancingConstruction(projectParam.getFinanceConstruct());
        this.logger.info("\u8d44\u91d1\u6765\u6e90-{}", (Object)projectParam.getFundsSource());
        response = this.iDefdocApi.getDefDocDetailByDefCodeAndTenantId("pro-market-project-fine-source", Long.valueOf(999999L));
        if (response.isSuccess() && ListUtil.isNotEmpty((List)((List)response.getData()))) {
            for (int i2 = 0; i2 < ((List)response.getData()).size(); ++i2) {
                detailVO = (DefdocDetailVO)((List)response.getData()).get(i2);
                if (!detailVO.getName().equals(projectParam.getFundsSource())) continue;
                projectSetPoolEntity.setFundsSource(detailVO.getId());
            }
        }
        this.logger.info("\u56fd\u5bb6-{}", (Object)projectParam.getNationalName());
        response = this.iDefdocApi.getDefDocDetailByDefCodeAndTenantId("sddjsprj_project_area", Long.valueOf(999999L));
        if (response.isSuccess() && ListUtil.isNotEmpty((List)((List)response.getData()))) {
            for (int i3 = 0; i3 < ((List)response.getData()).size(); ++i3) {
                detailVO = (DefdocDetailVO)((List)response.getData()).get(i3);
                if (!detailVO.getName().equals(projectParam.getNationalName())) continue;
                projectSetPoolEntity.setNationalId(detailVO.getId());
                projectSetPoolEntity.setNationalName(projectParam.getNationalName());
            }
        }
        projectSetPoolEntity.setAreaName((projectParam.getProvince() == null ? "" : projectParam.getProvince()) + "," + (projectParam.getCity() == null ? "" : projectParam.getCity()) + "," + (projectParam.getArea() == null ? "" : projectParam.getArea()));
        String hasParent = projectParam.getHasParent();
        if ("DJB01".equals(projectParam.getContractMainCode()) && "DJB01".equals(projectParam.getOperateMainCode())) {
            if (StringUtils.isNotEmpty((CharSequence)code)) {
                orgVO = new OrgVO();
                orgVO.setCode(code);
                oneByOrgVO = this.iOrgNoAuthApi.findOneByOrgVO(orgVO);
                if (oneByOrgVO.isSuccess()) {
                    projectSetPoolEntity.setBuildUnitName(((OrgVO)oneByOrgVO.getData()).getName());
                    projectSetPoolEntity.setBuildUnitId(((OrgVO)oneByOrgVO.getData()).getId());
                }
            }
            if ("\u662f".equals(hasParent)) {
                projectSetPoolEntity.setHasParent(1);
                param = new QueryParam();
                param.getParams().put("code", new Parameter("eq", (Object)projectParam.getParentCode()));
                projectSetPoolEntities = this.queryList(param);
                if (ListUtil.isNotEmpty((List)projectSetPoolEntities)) {
                    projectSetPoolEntity.setParentProjectId(((ProjectSetPoolEntity)((Object)projectSetPoolEntities.get(0))).getId());
                    projectSetPoolEntity.setParentProjectName(((ProjectSetPoolEntity)((Object)projectSetPoolEntities.get(0))).getName());
                } else {
                    this.logger.error("\u7236\u9879\u76ee\u7f16\u7801{}\u6ca1\u6709\u627e\u5230\u5177\u4f53\u9879\u76ee\uff0c\u5e94\u8be5\u6ca1\u540c\u6b65\u8fc7\u6765\uff01", (Object)JSONObject.toJSONString((Object)projectParam.getParentCode()));
                }
            } else {
                projectSetPoolEntity.setHasParent(0);
                projectSetPoolEntity.setParentProjectId(null);
                projectSetPoolEntity.setParentProjectName(null);
            }
            if (StringUtils.isEmpty((CharSequence)projectParam.getOrgId())) {
                projectSetPoolEntity.setAttribute("1");
                orgVO = new OrgVO();
                orgVO.setCode("DJB01-GSNFXM");
                oneByOrgVO = this.iOrgNoAuthApi.findOneByOrgVO(orgVO);
                if (oneByOrgVO.isSuccess()) {
                    projectSetPoolEntity.setOrgId(((OrgVO)oneByOrgVO.getData()).getId());
                    projectSetPoolEntity.setOrgName(((OrgVO)oneByOrgVO.getData()).getName());
                } else {
                    this.logger.error("DJB01-GSNFXM \u516c\u53f8\u5185\u7236\u9879\u76ee \u6ca1\u6709\u627e\u5230\u5177\u4f53\u7ec4\u7ec7\uff0c\u5e94\u8be5\u6ca1\u5efa\u7acb\uff01");
                }
            } else {
                projectSetPoolEntity.setAttribute("2");
                projectSetPoolEntity.setOrgId(projectSetPoolEntity.getBuildUnitId());
                projectSetPoolEntity.setOrgName(projectSetPoolEntity.getBuildUnitName());
            }
        } else if ("DJB01".equals(projectParam.getContractMainCode()) && !"DJB01".equals(projectParam.getOperateMainCode())) {
            projectSetPoolEntity.setBuildUnitId(null);
            projectSetPoolEntity.setBuildUnitName(null);
            if ("\u662f".equals(hasParent)) {
                if (StringUtils.isEmpty((CharSequence)projectParam.getOrgId())) {
                    projectSetPoolEntity.setHasParent(0);
                    projectSetPoolEntity.setParentProjectId(null);
                    projectSetPoolEntity.setParentProjectName(null);
                    projectSetPoolEntity.setAttribute("1");
                } else {
                    projectSetPoolEntity.setAttribute("2");
                    projectSetPoolEntity.setHasParent(1);
                    param = new QueryParam();
                    param.getParams().put("code", new Parameter("eq", (Object)projectParam.getParentCode()));
                    projectSetPoolEntities = this.queryList(param);
                    if (ListUtil.isNotEmpty((List)projectSetPoolEntities)) {
                        projectSetPoolEntity.setParentProjectId(((ProjectSetPoolEntity)((Object)projectSetPoolEntities.get(0))).getId());
                        projectSetPoolEntity.setParentProjectName(((ProjectSetPoolEntity)((Object)projectSetPoolEntities.get(0))).getName());
                    } else {
                        this.logger.error("\u7236\u9879\u76ee\u7f16\u7801{}\u6ca1\u6709\u627e\u5230\u5177\u4f53\u9879\u76ee\uff0c\u5e94\u8be5\u6ca1\u540c\u6b65\u8fc7\u6765\uff01", (Object)JSONObject.toJSONString((Object)projectParam.getParentCode()));
                    }
                }
            } else {
                dataInfo = new YnsbjDataInfo(projectParam.getUuid(), projectParam.getMasterDataCode(), "1", "\u201c\u5408\u540c\u4e3b\u4f53\u201d\u662f\u201c\u603b\u627f\u5305\u516c\u53f8\u201d\uff0c\u201c\u5b9e\u65bd\u4e3b\u4f53\u201d\u4e0d\u662f\u201c\u603b\u627f\u5305\u516c\u53f8\u201d\uff0c\u5f53\u524d\u6570\u636e\u5e94\u8be5\u662f\u7236\u9879\u76ee\uff01");
                return dataInfo;
            }
            if (StringUtils.isNotEmpty((CharSequence)projectParam.getOrgStructureCode())) {
                orgVO = new OrgVO();
                orgVO.setCode(projectParam.getOrgStructureCode());
                oneByOrgVO = this.iOrgNoAuthApi.findOneByOrgVO(orgVO);
                if (oneByOrgVO.isSuccess()) {
                    projectSetPoolEntity.setOrgId(((OrgVO)oneByOrgVO.getData()).getId());
                    projectSetPoolEntity.setOrgName(((OrgVO)oneByOrgVO.getData()).getName());
                } else {
                    this.logger.error("\u4e3b\u6570\u636e \u7ec4\u7ec7\u67b6\u6784\u7f16\u7801{} \u6ca1\u6709\u627e\u5230\u5177\u4f53\u7ec4\u7ec7\uff0c\u5e94\u8be5\u6ca1\u540c\u6b65\uff01", (Object)projectParam.getOrgStructureCode());
                }
            } else {
                this.logger.error("\u4e3b\u6570\u636e \u7ec4\u7ec7\u67b6\u6784\u7f16\u7801{} \u4e3a\u7a7a\uff01", (Object)projectParam.getOrgStructureCode());
            }
        } else if (!"DJB01".equals(projectParam.getContractMainCode()) && "DJB01".equals(projectParam.getOperateMainCode())) {
            if (StringUtils.isNotEmpty((CharSequence)code)) {
                projectSetPoolEntity.setAttribute("2");
                orgVO = new OrgVO();
                orgVO.setCode(code);
                oneByOrgVO = this.iOrgNoAuthApi.findOneByOrgVO(orgVO);
                if (oneByOrgVO.isSuccess()) {
                    projectSetPoolEntity.setBuildUnitId(((OrgVO)oneByOrgVO.getData()).getId());
                    projectSetPoolEntity.setBuildUnitName(((OrgVO)oneByOrgVO.getData()).getName());
                }
            } else {
                projectSetPoolEntity.setAttribute("1");
            }
            param = new QueryParam();
            param.getParams().put("code", new Parameter("eq", (Object)projectParam.getParentCode()));
            projectSetPoolEntities = this.queryList(param);
            if ("\u662f".equals(hasParent) && ListUtil.isNotEmpty((List)projectSetPoolEntities)) {
                projectSetPoolEntity.setHasParent(1);
                projectSetPoolEntity.setParentProjectId(((ProjectSetPoolEntity)((Object)projectSetPoolEntities.get(0))).getId());
                projectSetPoolEntity.setParentProjectName(((ProjectSetPoolEntity)((Object)projectSetPoolEntities.get(0))).getName());
            } else {
                projectSetPoolEntity.setHasParent(0);
                projectSetPoolEntity.setParentProjectId(null);
                projectSetPoolEntity.setParentProjectName(null);
            }
            if (StringUtils.isNotEmpty((CharSequence)projectParam.getOrgStructureCode())) {
                orgVO = new OrgVO();
                orgVO.setCode(projectParam.getOrgStructureCode());
                oneByOrgVO = this.iOrgNoAuthApi.findOneByOrgVO(orgVO);
                if (oneByOrgVO.isSuccess()) {
                    projectSetPoolEntity.setOrgId(((OrgVO)oneByOrgVO.getData()).getId());
                    projectSetPoolEntity.setOrgName(((OrgVO)oneByOrgVO.getData()).getName());
                } else {
                    this.logger.error("\u4e3b\u6570\u636e \u7ec4\u7ec7\u67b6\u6784\u7f16\u7801{} \u6ca1\u6709\u627e\u5230\u5177\u4f53\u7ec4\u7ec7\uff0c\u5e94\u8be5\u6ca1\u540c\u6b65\uff0c\u65e0\u6cd5\u4e3a\u6240\u5c5e\u7ec4\u7ec7\u8d4b\u503c\uff01", (Object)projectParam.getOrgStructureCode());
                }
            } else {
                this.logger.error("\u4e3b\u6570\u636e \u7ec4\u7ec7\u67b6\u6784\u7f16\u7801{} \u4e3a\u7a7a,\u65e0\u6cd5\u4e3a\u6240\u5c5e\u7ec4\u7ec7\u8d4b\u503c\uff01", (Object)projectParam.getOrgStructureCode());
            }
        }
        orgVO = this.generateProjectDepartment(projectSetPoolEntity);
        if (orgVO != null) {
            CommonResponse response1 = this.iOrgNoAuthApi.saveOrgInfo(orgVO);
            this.logger.info("\u4e91\u5357\u5efa\u6295 \uff1a\u751f\u6210\u9879\u76ee\u90e8----\uff01orgVO=>{},{},{}", new Object[]{orgVO, JSONObject.toJSONString((Object)((Object)projectSetPoolEntity)), response1.getMsg()});
            if (response1.isSuccess()) {
                orgVO = (OrgVO)response1.getData();
                projectSetPoolEntity.setProjectDepartmentId(orgVO.getId());
                projectSetPoolEntity.setProjectDepartmentName(orgVO.getName());
            } else {
                this.logger.error("\u4e91\u5357\u5efa\u6295 \uff1a\u751f\u6210\u9879\u76ee\u90e8\u5931\u8d25\uff01{},{}", (Object)JSONObject.toJSONString((Object)((Object)projectSetPoolEntity)), (Object)response1.getMsg());
            }
        }
        if (projectSetPoolEntity.getProjectDepartmentId() != null) {
            DeptVO deptVO = new DeptVO();
            deptVO.setOrgId(projectSetPoolEntity.getProjectDepartmentId());
            deptVO.setCode(projectSetPoolEntity.getCode());
            deptVO.setName(projectSetPoolEntity.getName());
            deptVO.setShortName(projectSetPoolEntity.getShortName());
            deptVO.setNote("\u540c\u6b65\u4e3b\u6570\u636e\u751f\u6210\uff01" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            deptVO.setState(Integer.valueOf(1));
            deptVO.setSequence(Integer.valueOf(0));
            deptVO.setType(Integer.valueOf(2));
            this.iOrgNoAuthApi.saveDeptInfo(deptVO);
        }
        projectSetPoolEntity.setParentProjectNumber(projectParam.getParentCode());
        projectSetPoolEntity.setHasContract(projectParam.getContractFlag());
        projectSetPoolEntity.setContractName(projectParam.getContractName());
        projectSetPoolEntity.setContractType(projectParam.getContractType());
        projectSetPoolEntity.setContractAmount(projectParam.getContractMny());
        projectSetPoolEntity.setContractSubject(projectParam.getContractMain());
        projectSetPoolEntity.setPlanStartDate(projectParam.getPlanStartDate());
        projectSetPoolEntity.setPlanEndDate(projectParam.getPlanEndDate());
        projectSetPoolEntity.setActualStartDate(projectParam.getActualStartDate());
        projectSetPoolEntity.setActualEndDate(projectParam.getActualEndDate());
        projectSetPoolEntity.setFirstDate(projectParam.getInitVerifyDate());
        projectSetPoolEntity.setProjectManagementName(projectParam.getProjectManagementName());
        projectSetPoolEntity.setProjectManagementPhone(projectParam.getProjectManagementPhone());
        projectSetPoolEntity.setTechnologyName(projectParam.getTechnologyName());
        projectSetPoolEntity.setQualityName(projectParam.getQualityName());
        projectSetPoolEntity.setSafeName(projectParam.getSafeName());
        projectSetPoolEntity.setRelationCode(projectParam.getRelationCode());
        projectSetPoolEntity.setRelationName(projectParam.getRelationName());
        projectSetPoolEntity.setLegalPersonAccountBookCode(projectParam.getLegalPersonAccountBookCode());
        projectSetPoolEntity.setLegalPersonAccountBookName(projectParam.getLegalPersonAccountBookName());
        projectSetPoolEntity.setOrgStructureCode(projectParam.getOrgStructureCode());
        projectSetPoolEntity.setOrgStructureName(projectParam.getOrgStructureName());
        projectSetPoolEntity.setCloudBusinessTenantCode(projectParam.getCloudBusinessTenantCode());
        projectSetPoolEntity.setDeptStructureCode(projectParam.getOrgId());
        projectSetPoolEntity.setDeptStructureName(projectParam.getOrgName());
        if (projectSetPoolEntity.getId() == null) {
            if ("\u5728\u5efa\u5de5\u7a0b".equals(projectParam.getProjectStatus())) {
                projectSetPoolEntity.setProjectStatus("1");
            } else if ("\u7ae3\u5de5\u672a\u7ed3\u7b97".equals(projectParam.getProjectStatus())) {
                projectSetPoolEntity.setProjectStatus("3");
            } else if ("\u7ae3\u5de5\u5df2\u7ed3\u7b97".equals(projectParam.getProjectStatus())) {
                projectSetPoolEntity.setProjectStatus("3");
            } else if ("\u7b7e\u8ba2\u5408\u540c".equals(projectParam.getProjectStatus())) {
                projectSetPoolEntity.setProjectStatus("1");
            } else {
                projectSetPoolEntity.setProjectStatus("1");
            }
            if ("\u65b0\u5f00\u5de5".equals(projectParam.getProjectBuildStatus())) {
                projectSetPoolEntity.setBusinessStatus("1");
            } else if ("\u5728\u5efa".equals(projectParam.getProjectBuildStatus())) {
                projectSetPoolEntity.setBusinessStatus("2");
            } else if ("\u505c\u5de5".equals(projectParam.getProjectBuildStatus())) {
                projectSetPoolEntity.setBusinessStatus("3");
            } else if ("\u5b8c\u5de5".equals(projectParam.getProjectBuildStatus())) {
                projectSetPoolEntity.setBusinessStatus("5");
            } else if ("\u7ae3\u5de5".equals(projectParam.getProjectBuildStatus())) {
                projectSetPoolEntity.setBusinessStatus("6");
            } else {
                projectSetPoolEntity.setBusinessStatus("1");
            }
            if ("\u7ae3\u5de5\u672a\u7ed3\u7b97".equals(projectParam.getProjectStatus())) {
                projectSetPoolEntity.setSettleStatus("1");
            } else if ("\u7ae3\u5de5\u5df2\u7ed3\u7b97".equals(projectParam.getProjectStatus())) {
                projectSetPoolEntity.setSettleStatus("9");
            } else {
                projectSetPoolEntity.setSettleStatus("1");
            }
            projectSetPoolEntity.setArchiveStatus("10");
            projectSetPoolEntity.setCapitalStatus("14");
        }
        if ((response = this.iDefdocApi.getDefDocDetailByDefCodeAndTenantId("pro-market-project-measureType", Long.valueOf(999999L))).isSuccess() && ListUtil.isNotEmpty((List)((List)response.getData()))) {
            for (int i4 = 0; i4 < ((List)response.getData()).size(); ++i4) {
                DefdocDetailVO detailVO2 = (DefdocDetailVO)((List)response.getData()).get(i4);
                if (!detailVO2.getName().equals(projectParam.getMeasureType())) continue;
                projectSetPoolEntity.setMeasureType(detailVO2.getId());
            }
        }
        projectSetPoolEntity.setMeasureValue(projectParam.getMeasureValue());
        projectSetPoolEntity.setTenantId(999999L);
        projectSetPoolEntity.setPaymentDate(new Date());
        projectSetPoolEntity.setKeyProject(false);
        this.saveOrUpdate((Object)projectSetPoolEntity);
        dataInfo = new YnsbjDataInfo(projectParam.getUuid(), projectParam.getMasterDataCode(), "0", "\u64cd\u4f5c\u6210\u529f");
        return dataInfo;
    }

    @Override
    public OrgVO generateProjectDepartment(ProjectSetPoolEntity projectSetVO) {
        if (projectSetVO.getOrgId() == null) {
            this.logger.error("\u4fdd\u5b58\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff0c\u6240\u5c5e\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u5b58\u5728\u3002");
            return null;
        }
        OrgVO parentOrg = new OrgVO();
        parentOrg.setId(projectSetVO.getOrgId());
        CommonResponse response = this.iOrgNoAuthApi.findOneByOrgVO(parentOrg);
        if (!response.isSuccess()) {
            this.logger.error("\u4fdd\u5b58\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff0c\u67e5\u8be2\u6240\u5c5e\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25: " + response.getMsg());
            return null;
        }
        parentOrg = (OrgVO)response.getData();
        if (null == parentOrg) {
            this.logger.error("\u4fdd\u5b58\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff0c\u6240\u5c5e\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u5b58\u5728\u3002");
            return null;
        }
        OrgVO projectDepartment = new OrgVO();
        projectDepartment.setCode(projectSetVO.getCode());
        response = this.iOrgNoAuthApi.findOneByOrgVO(projectDepartment);
        if (response.isSuccess() && response.getData() != null) {
            projectDepartment = (OrgVO)response.getData();
            projectDepartment.setParentId(projectSetVO.getOrgId());
            projectDepartment.setEnterpriseId(parentOrg.getEnterpriseId());
            projectDepartment.setName(projectSetVO.getName());
            projectDepartment.setShortName(projectSetVO.getShortName());
        } else {
            projectDepartment.setId(Long.valueOf(IdWorker.getId()));
            projectDepartment.setParentId(projectSetVO.getOrgId());
            projectDepartment.setTenantId(parentOrg.getTenantId());
            projectDepartment.setEnterpriseId(parentOrg.getEnterpriseId());
            projectDepartment.setIsParent(Boolean.valueOf(false));
            projectDepartment.setName(projectSetVO.getName());
            projectDepartment.setShortName(projectSetVO.getShortName());
            projectDepartment.setState(Integer.valueOf(1));
            projectDepartment.setOrgType(OrgVO.ORG_TYPE_DEPARTMENT);
        }
        return projectDepartment;
    }

    @Override
    public ProjectDesktopVO queryProjectBusinessStatusCount(List<Long> commonOrgIds, List<Long> departmentIds, List<String> businessStatusList) {
        ProjectDesktopVO projectDesktopVO = null;
        List<ProjectDesktopSubVO> projectDesktopSubVOS = ((ProjectSetMapper)this.baseMapper).countBusinessStatus(commonOrgIds, departmentIds, businessStatusList);
        if (CollectionUtils.isNotEmpty(projectDesktopSubVOS)) {
            BigDecimal totalNum;
            projectDesktopVO = ((ProjectSetMapper)this.baseMapper).countProjectStatus(commonOrgIds, departmentIds, null);
            BigDecimal otherNum = totalNum = projectDesktopVO.getTotalNum();
            HashMap<String, ProjectDesktopSubVO> map = new HashMap<String, ProjectDesktopSubVO>();
            for (ProjectDesktopSubVO t : projectDesktopSubVOS) {
                map.put(t.getBusinessStatus(), t);
                otherNum = ComputeUtil.safeSub((BigDecimal)otherNum, (BigDecimal)t.getNum());
                t.setBusinessStatusName(ProjectBusinessStatusEnum.getNameByCode((String)t.getBusinessStatus()));
            }
            for (String businessStatus : businessStatusList) {
                ProjectDesktopSubVO projectDesktopSubVO = (ProjectDesktopSubVO)map.get(businessStatus);
                if (projectDesktopSubVO != null) continue;
                ProjectDesktopSubVO subVO = new ProjectDesktopSubVO();
                subVO.setBusinessStatus(businessStatus);
                subVO.setBusinessStatusName(ProjectBusinessStatusEnum.getNameByCode((String)businessStatus));
                subVO.setNum(BigDecimal.ZERO);
                map.put(businessStatus, subVO);
            }
            ProjectDesktopSubVO other = new ProjectDesktopSubVO();
            other.setBusinessStatus("99");
            other.setBusinessStatusName("\u5176\u4ed6");
            other.setNum(ComputeUtil.nullToZero((BigDecimal)otherNum));
            map.put(other.getBusinessStatus(), other);
            projectDesktopVO.setDetail(new ArrayList(map.values()));
        }
        return projectDesktopVO;
    }

    @Override
    public ProjectDesktopVO queryProjectBusinessStatusCountParent(List<Long> commonOrgIds, List<Long> departmentIds, List<String> businessStatusList) {
        ProjectDesktopVO projectDesktopVO = null;
        List projectDesktopSubVOSParent = new ArrayList();
        ArrayList<ProjectDesktopSubVO> desktopSubVOS = new ArrayList<ProjectDesktopSubVO>();
        String thisYear = EJCDateUtil.getYear() + "";
        List<ProjectDesktopSubParentVO> projectDesktopSubVOS = ((ProjectSetMapper)this.baseMapper).countBusinessStatusParent(commonOrgIds, departmentIds);
        if (CollectionUtils.isNotEmpty(projectDesktopSubVOS)) {
            BigDecimal totalNum;
            projectDesktopSubVOSParent = TreeNodeBUtil.buildTree(projectDesktopSubVOS);
            projectDesktopVO = new ProjectDesktopVO();
            BigDecimal otherNum = totalNum = new BigDecimal(projectDesktopSubVOSParent.size());
            projectDesktopVO.setTotalNum(totalNum);
            Long buildNum = projectDesktopSubVOSParent.stream().filter(e -> null != e.getProjectStatus() && "1".equals(e.getProjectStatus())).count();
            projectDesktopVO.setBuildNum(new BigDecimal(buildNum));
            Long thisYearProjectNum = projectDesktopSubVOSParent.stream().filter(e -> null != e.getProjectDate() && thisYear.equals(e.getProjectDate().substring(0, 4))).count();
            projectDesktopVO.setThisYearProjectNum(new BigDecimal(thisYearProjectNum));
            for (String businessStatus : businessStatusList) {
                ProjectDesktopSubVO projectDesktopSubVO = new ProjectDesktopSubVO();
                projectDesktopSubVO.setBusinessStatus(businessStatus);
                projectDesktopSubVO.setBusinessStatusName(ProjectBusinessStatusEnum.getNameByCode((String)businessStatus));
                Long num = projectDesktopSubVOSParent.stream().filter(e -> null != e.getBusinessStatus() && businessStatus.equals(e.getBusinessStatus())).count();
                if (null != num) {
                    projectDesktopSubVO.setNum(new BigDecimal(num));
                    otherNum = ComputeUtil.safeSub((BigDecimal)otherNum, (BigDecimal)new BigDecimal(num));
                }
                desktopSubVOS.add(projectDesktopSubVO);
            }
            ProjectDesktopSubVO other = new ProjectDesktopSubVO();
            other.setBusinessStatus("99");
            other.setBusinessStatusName("\u5176\u4ed6");
            other.setNum(ComputeUtil.nullToZero((BigDecimal)otherNum));
            desktopSubVOS.add(other);
            projectDesktopVO.setDetail(desktopSubVOS);
        }
        return projectDesktopVO;
    }

    @Override
    public ProjectDesktopVO queryProjectBusinessStatusCountZzyj(List<Long> commonOrgIds, List<Long> departmentIds, List<String> businessStatusList, String yearType) {
        List<ProjectDesktopSubVO> projectDesktopSubList;
        ProjectDesktopVO projectDesktopVO = null;
        List projectDesktopSubVOSParent = new ArrayList();
        String year = EJCDateUtil.getYear() + "";
        if (yearType != null && "0".equals(yearType)) {
            year = EJCDateUtil.getYear() - 1 + "";
        }
        String thisYear = year;
        List<ProjectDesktopSubParentVO> projectDesktopSubVOS = ((ProjectSetMapper)this.baseMapper).countBusinessStatusParent(commonOrgIds, departmentIds);
        if (CollectionUtils.isNotEmpty(projectDesktopSubVOS)) {
            projectDesktopVO = new ProjectDesktopVO();
            BigDecimal totalNumAll = new BigDecimal(projectDesktopSubVOS.size());
            projectDesktopVO.setTotalNumAll(totalNumAll);
            projectDesktopSubVOSParent = TreeNodeBUtil.buildTree(projectDesktopSubVOS);
            BigDecimal totalNum = new BigDecimal(projectDesktopSubVOSParent.size());
            projectDesktopVO.setTotalNum(totalNum);
            Long buildNum = projectDesktopSubVOSParent.stream().filter(e -> null != e.getProjectStatus() && "1".equals(e.getProjectStatus())).count();
            projectDesktopVO.setBuildNum(new BigDecimal(buildNum));
            Long thisYearProjectNum = projectDesktopSubVOSParent.stream().filter(e -> null != e.getProjectDate() && thisYear.equals(e.getProjectDate().substring(0, 4))).count();
            projectDesktopVO.setThisYearProjectNum(new BigDecimal(thisYearProjectNum));
        }
        if (CollectionUtils.isNotEmpty(projectDesktopSubList = ((ProjectSetMapper)this.baseMapper).countBusinessStatus(commonOrgIds, departmentIds, businessStatusList))) {
            HashMap<String, ProjectDesktopSubVO> map = new HashMap<String, ProjectDesktopSubVO>();
            for (ProjectDesktopSubVO t : projectDesktopSubList) {
                map.put(t.getBusinessStatus(), t);
                t.setBusinessStatusName(ProjectBusinessStatusEnum.getNameByCode((String)t.getBusinessStatus()));
            }
            for (String businessStatus : businessStatusList) {
                ProjectDesktopSubVO projectDesktopSubVO = (ProjectDesktopSubVO)map.get(businessStatus);
                if (projectDesktopSubVO != null) continue;
                ProjectDesktopSubVO subVO = new ProjectDesktopSubVO();
                subVO.setBusinessStatus(businessStatus);
                subVO.setBusinessStatusName(ProjectBusinessStatusEnum.getNameByCode((String)businessStatus));
                subVO.setNum(BigDecimal.ZERO);
                map.put(businessStatus, subVO);
            }
            projectDesktopVO.setDetail(new ArrayList(map.values()));
        }
        return projectDesktopVO;
    }

    @Override
    public void deleteProjectById(List<Long> ids) {
        ((ProjectSetMapper)this.baseMapper).deleteProjectById(ids);
    }

    @Override
    public IPage<ProjectSetPoolEntity> queryMdmPage(QueryParam param) {
        HashMap<String, Object> condition = new HashMap<String, Object>();
        Parameter parameter = (Parameter)param.getParams().get("syncTime");
        if (parameter != null) {
            condition.put("syncTime", parameter.getValue());
        }
        condition.put("pageIndex", (param.getPageIndex() - 1) * param.getPageSize());
        condition.put("pageSize", param.getPageSize());
        List<ProjectSetPoolEntity> poolEntities = this.projectSetMapper.queryMdmPage(condition);
        Page page = new Page();
        page.setRecords(poolEntities);
        return page;
    }

    @Override
    public BigDecimal queryThisYearProjectNum(List<Long> commonOrgIds, List<Long> departmentIds, String thisYear) {
        return this.projectSetMapper.queryThisYearProjectNum(commonOrgIds, departmentIds, thisYear);
    }
}

